package com.gtis.web.action;

import com.gtis.plat.dao.*;
import com.gtis.plat.vo.*;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

import java.util.ArrayList;
import java.util.List;

public class AuthorAction {
    String rid;
    String proid;
    String taskid;
    String from;
    SysAuthorDao authorDao;
    SysTaskDao taskDao;
    SysWorkFlowInstanceDao workFlowInstanceDao;

    private static final String ENTER_FROM_TASK = "task";
    private static final String ENTER_FROM_PROJECT = "pro";
    private static final String ENTER_FROM_SYS = "sys";

    public SysWorkFlowInstanceDao getWorkFlowInstanceDao() {
        return workFlowInstanceDao;
    }

    public void setWorkFlowInstanceDao(
            SysWorkFlowInstanceDao workFlowInstanceDao) {
        this.workFlowInstanceDao = workFlowInstanceDao;
    }

    public SysTaskDao getTaskDao() {
        return taskDao;
    }

    public void setTaskDao(SysTaskDao taskDao) {
        this.taskDao = taskDao;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public SysAuthorDao getAuthorDao() {
        return authorDao;
    }

    public void setAuthorDao(SysAuthorDao authorDao) {
        this.authorDao = authorDao;
    }

    public String execute() throws Exception {
        if (ENTER_FROM_PROJECT.equals(from)) {
            return project();
        } else if (ENTER_FROM_TASK.equals(from)) {
            return task();
        } else {
            return system();
        }
    }

    /**
     * 任务列表 传入taskid 和 rid
     *
     * @return
     * @throws Exception
     */
    public String task() throws Exception {
        if (taskid == null || taskid.equals("")) {
            return Action.NONE;
        }
        PfTaskVo taskVo = taskDao.getTask(taskid);
        PfActivityVo activityVo = taskDao.getActivity(taskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = workFlowInstanceDao
                .getWorkflowInstance(activityVo.getWorkflowInstanceId());
        //String roles = SessionUtil.getUserInfo(
                //ServletActionContext.getRequest()).getRoleIds();
        //if (roles != null && !roles.equals("")) {
            List<PfPartitionInfoVo> lstResult = authorDao
                    .getTaskFormAuthorList(workFlowInstanceVo
                            .getWorkflowDefinitionId(), activityVo
                            .getActivityDefinitionId(), rid);
            ServletActionContext.getResponse().getWriter().println(
                    JSONUtil.serialize(lstResult));
        //}
        return Action.NONE;
    }

    /**
     * 由系统主界面进入 传入proid和 rid
     *
     * @return
     * @throws Exception
     */
    public String system() throws Exception {
        String roles = SessionUtil.getUserInfo(
                ServletActionContext.getRequest()).getRoleIds();
        if (roles != null && !roles.equals("")) {
            List<PfPartitionInfoVo> lstResult = authorDao
                    .getSystemResrouceEnableList(rid, roles);
            ServletActionContext.getResponse().getWriter().println(
                    JSONUtil.serialize(lstResult));

        }
        return Action.NONE;
    }

    /**
     * 由项目列表进入,可用列表 传入proid和 rid
     *
     * @return
     * @throws Exception
     */
    public String project() throws Exception {
        if (proid == null || proid.equals("")) {
            return Action.NONE;
        }
        Object result = new Object();
        PfWorkFlowInstanceVo workFlowInstanceVo = workFlowInstanceDao
                .getWorkflowInstanceByProId(proid);
        UserInfo userinfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
        if (userinfo != null && userinfo.isAdmin()) {
			result = authorDao.getIntanceAuthorXML(workFlowInstanceVo.getWorkflowDefinitionId(), rid, null);
		}else {
	        String roles = SessionUtil.getUserInfo(ServletActionContext.getRequest()).getRoleIds();
	        if (roles != null && !roles.equals("")) {
	        	result = authorDao.getIntanceAuthorXML(workFlowInstanceVo.getWorkflowDefinitionId(), rid, roles);
	        }
		}
        List<PfPartitionInfoVo> lstResult = new ArrayList<PfPartitionInfoVo>();
        try {
            if (result != null) {
                Document doc = DocumentHelper.parseText("<Rows>" + result.toString() + "</Rows>");
                List<Node> lstNodes = (List<Node>) doc
                        .selectNodes("//Partition[@OperType='0']");
                for (Node node : lstNodes) {
                    String pId = node.valueOf("@Id");
                    List<PfPartitionInfoVo> lstResult1 = authorDao
                            .getPartitionList(pId);
                    
                    lstResult.addAll(lstResult1);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(lstResult));
        return Action.NONE;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
		this.from = from;
	}

}
