package com.gtis.web;

import java.util.ArrayList;
import java.util.List;

import org.springframework.dao.DataAccessException;   
import org.springframework.security.userdetails.UserDetails;   
import org.springframework.security.userdetails.UserDetailsService;   
import org.springframework.security.userdetails.UsernameNotFoundException;   
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
  
public class UserDetailsSerivceImpl_temp implements UserDetailsService {   
    public UserDetails loadUserByUsername(String username)   
            throws UsernameNotFoundException, DataAccessException {
    	SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
    	
    	UserInfo user=new UserInfo();
    	PfUserVo userVo=userService.getUserByloginName(username);
    	String userId=userVo.getUserId();
    	user.setId(userVo.getUserId());
    	user.setUsername(userVo.getUserName());
    	user.setPassword(userVo.getLoginPassWord());
    	user.setLstOragn(userService.getOrganListByUser(userId));
    	user.setConfig(userService.getConfigVo(userId));
    	if ("0".equals(userId)){  //判断是否管理员
    		user.setAdmin(true);
    		user.setUsersIdAll(null);
    		user.setRoleIds(null);
    	}else{
        	user.setLstRole(userService.getRoleListByUser(userId));
    		user.setUsersIdAll(userService.getUserAgentList(userId));
    		BuildUserRoles(userService,user);
    	}
        return user;
    }
    
    /**
	 * 获取一个用户所有的角色
	 * 
	 * @param userService
	 * @param userInfo
	 */
	public static void BuildUserRoles(SysUserService userService,
			UserInfo userInfo) {
		List<String> lstAgentRoles = userService
				.getRoleListByAgentUser(userInfo.getId());
		List<PfRoleVo> lstRoles = userInfo.getLstRole();
		List<String> tmpList = new ArrayList<String>();
		StringBuffer strRoles = new StringBuffer("");
		for (PfRoleVo roleVo : lstRoles) {
			strRoles.append("'" + roleVo.getRoleId() + "',");
			tmpList.add(roleVo.getRoleId());
		}
		for (String roleStr : lstAgentRoles) {
			if (!tmpList.contains(roleStr))
				strRoles.append("'" + roleStr + "',");
		}
		if (strRoles.length()>1)
			userInfo.setRoleIds(strRoles.toString().substring(0,strRoles.toString().length()-1));
		else
			userInfo.setRoleIds("");
	}
}  

