package com.gtis.plat.wf.bean;

import com.gtis.config.AppConfig;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.TransitionModel;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkFlowTaskTurnScriptBean extends WorkFlowBeanAbstract {
    static Log log = LogFactory.getLog(WorkFlowTaskTurnScriptBean.class);
	/**
	 * 工作流转发脚本执行
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		HashMap<String, Object> gobalMap = WorkFlowXmlUtil.getGobalVals(infoObj
				.getWorkFlowIntanceVo().getWorkflowIntanceId());
		Binding b = new Binding();
		if (gobalMap==null){
            gobalMap=new HashMap<String, Object>();
        }
        gobalMap.put("PROID",infoObj.getWorkFlowIntanceVo().getProId());
        gobalMap.put("USERID",infoObj.getUserId());
        gobalMap.put("TASKID",infoObj.getSourceTask().getTaskId());
		Iterator iter = gobalMap.entrySet().iterator(); 
		while (iter.hasNext()) { 
			Map.Entry entry = (Map.Entry) iter.next(); 
		    Object key = entry.getKey(); 
		    Object val = entry.getValue(); 
		    b.setVariable(key.toString(), val);
		} 
		
		
		WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(infoObj.getWorkFlowIntanceVo());
		ActivityModel activityModel = workXml.getActivity( infoObj.getSourceActivity()
				.getActivityDefinitionId());
		
		List<TransitionModel> lstTrans=activityModel.getTransitionsList();
		for (TransitionModel  tranModel: lstTrans) {
			if (tranModel.getCondition()!=null && !tranModel.getCondition().equals("")){
				GroovyShell gs=new GroovyShell(b);
                String script= AppConfig.getPlaceholderValue(tranModel.getCondition());
                try{
                    Object result= gs.evaluate(script);
                    if (result.equals(false)){
                        List<ActivityModel> lstModel=infoObj.getTransInfo().getTranActivitys();
                        for (ActivityModel  aModel: lstModel) {
                            if (tranModel.getToId().equals(aModel.getDefineId())){
                                lstModel.remove(aModel);
                                break;
                            }
                        }
                    }
                }catch(Exception ex){
                    log.error("脚本错误！"+script);
                    log.error(ex);
                }

			}
		}
		
		return true;
	}

    public static void  main(String[] param)throws Exception{
        GroovyShell gs=new GroovyShell();
        Object result= gs.evaluate("def baseUrl = \"http://192.168.50.85:8888/finance/workflowTurnConditionAction!applierToFg.action?proid=012d743bde3f2d743bde00034028b2d5\";\n" +
                "return baseUrl.toURL().text;");
        System.out.println(result);
    }
}
