package com.gtis.plat.wf.bean;

import java.util.ArrayList;
import java.util.List;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import org.apache.commons.lang.StringUtils;

public class WorkFlowTaskTurnBackBean extends WorkFlowBeanAbstract {
    
	/**
	 * 工作流的初始化工作
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		try {
            String xmlModel=this.getWorFlowInstanceService().getWorkflowInstanceXml(infoObj.getWorkFlowIntanceVo());
            WorkFlowXml workXml =new WorkFlowXml(xmlModel);
			if (infoObj.getTargetActivitys() != null
					&& infoObj.getTargetActivitys().size() > 0) {
				String workflowInstanceId = infoObj.getSourceActivity()
						.getWorkflowInstanceId();
				List<PfActivityVo> lstActivitys = infoObj.getTargetActivitys();
				// 将活动设置为退回状态
				this.getTaskService().updateActivityStadus(
						infoObj.getSourceActivity().getActivityId(),
						WorkFlowEnum.ACTIVITY_BACK);
                List<PfTaskVo> history_taskList=this.getTaskService().getHistoryTaskListByActivity(infoObj.getSourceActivity().getActivityId());
                int isRepeat=0;//0表示没有重复的
                if(history_taskList.size()>0){
                    for(PfTaskVo pfTaskVo:history_taskList){
                        if(pfTaskVo!=null && StringUtils.isNotBlank(pfTaskVo.getUserVo().getUserId()) && StringUtils.equals(pfTaskVo.getUserVo().getUserId(),infoObj.getUserId())){
                            isRepeat=1;
                            break;
                        }
                    }
                }
				// 办结任务
				this.getTaskService().insertTaskHistory(
						infoObj.getSourceTask().getTaskId());
                //重复状态为1，更新历史任务的重复状态
                if(isRepeat==1  && StringUtils.isNotBlank(infoObj.getSourceTask().getTaskId()))
                    this.getTaskService().updateAssignmentHistoryRepeat(infoObj.getSourceTask().getTaskId());
				// 更新任务意见
				if (infoObj.getTransInfo() != null
						&& infoObj.getTransInfo().getRemark() != null) {
					PfTaskVo taskHisVo = this.getTaskService().getHistoryTask(
							infoObj.getSourceTask().getTaskId());
					taskHisVo.setRemark(infoObj.getTransInfo().getRemark());
					this.getTaskService().updateHistoryTask(taskHisVo);
				}

				// 删除多余任务
				this.getTaskService().deleteActivityTask(
						infoObj.getSourceActivity().getActivityId());

				//将退回活动启动
				for (PfActivityVo vo : lstActivitys) {
					PfActivityVo backActivityVo = super.getTaskService()
							.getActivityBywIdandadId(workflowInstanceId,
									vo.getActivityDefinitionId());

					Boolean isSubProcessActivity = false;
					String subProcessWiid=null;
					ActivityModel backActivityModel = workXml
							.getActivity(backActivityVo.getActivityDefinitionId());
					if (backActivityModel.getSubProcess()!=null) {
						isSubProcessActivity = true;
					}



					//创建退回活动任务
					List<PfTaskVo> lstTasks = this.getTaskService()
							.getHistoryTasks(backActivityVo.getActivityId());
					List<String> users = new ArrayList<String>();
					for (PfTaskVo taskVo : lstTasks) {
						if (!users.contains(taskVo.getUserVo().getUserId())) {

							users.add(taskVo.getUserVo().getUserId());
							if(isSubProcessActivity){
								subProcessWiid = taskVo.getTaskId();

							}else{
								taskVo.setTaskId(UUIDGenerator.generate());
							}
                            taskVo.setTaskBefore(infoObj.getSourceTask().getTaskId());
                            taskVo.setBackState(true);
							this.getTaskService().createTask(taskVo);


						}
					}
					//修改退回到活动的标示和状态
					this.getTaskService().updateActivityBackStadus(
							backActivityVo.getActivityId(), true);
					this.getTaskService().updateActivityStadus(
							backActivityVo.getActivityId(),
							WorkFlowEnum.ACTIVITY_START);
                    this.getTaskService().updateActivityHandlesDay(
                            backActivityVo.getActivityId(),0);

					//处理子流程
					if(isSubProcessActivity&&StringUtils.isNotBlank(subProcessWiid)) {
						//删除历史活动表中重复的子流程节点活动信息，避免重复
						this.getTaskService().deleteHistoryTaskByActivityId(backActivityVo.getActivityId());
						restartSubProcess(subProcessWiid);
					}
				}
                //考虑协办的状态问题，退回后
                ActivityModel sourceActivityModel = workXml
                        .getActivity(infoObj.getSourceActivity().getActivityDefinitionId());
                //1、当前任务为协办
                if (StringUtils.isNotBlank(sourceActivityModel.getCooperRootId())) {
                    PfActivityVo rootActityVo = this.getTaskService()
                            .getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),
                                    sourceActivityModel.getCooperRootId());
                    this.getTaskService().updateCooperateStateUp(rootActityVo.getActivityId()); // 设置协办状态
                }
                //2、如果退回的任务也是协办
                List<PfActivityVo> transActivitys=infoObj.getTargetActivitys();
                for(PfActivityVo transActivity:transActivitys){
                    ActivityModel transModel = workXml
                            .getActivity(transActivity.getActivityDefinitionId());
                    if (transModel.getCooperRootId() != null
                            && !transModel.getCooperRootId().equals("")) {
                        PfActivityVo cooperActityVo = this.getTaskService()
                                .getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),
                                        transModel.getDefineId());
                        if (cooperActityVo!=null &&  cooperActityVo.getActivityState()==WorkFlowEnum.ACTIVITY_START){
                            throw new WorkFlowException(
                                    WorkFlowException.ExceptionNum.CooperatAlready);
                        }
                        //设置协办状态
                        this.getTaskService().updateCooperateStateDown(infoObj.getSourceActivity().getActivityId());
                    }
                }


			}
		} catch (Exception e) {
			throw e;
		}
		return true;
	}

	/**
	 * 重启子流程，并将最后一个活动启动
	 * @param subProcessWiid
	 */
	private void restartSubProcess(String subProcessWiid){
		PfWorkFlowInstanceVo intanceVo = getWorFlowInstanceService().getWorkflowInstance(subProcessWiid);
		if (intanceVo.getWorkflowState() == WorkFlowEnum.WORKFLOW_END){
			//更新工作流状态
			intanceVo.setWorkflowState(WorkFlowEnum.WORKFLOW_START);
			getWorFlowInstanceService().updateWorkFlowIntanceStadus(intanceVo);

			PfWorkFlowDefineVo defineVo = workFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
			WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(defineVo);

			String activityDefinitionId = workFlowXml.getEndActivityDefine();
			PfActivityVo backActivityVo = getTaskService().getActivityBywIdandadId(subProcessWiid,activityDefinitionId);

			// 创建重新开始活动任务
			List<PfTaskVo> lstTasks = this.getTaskService().getHistoryTasks(backActivityVo.getActivityId());
			List<String> users = new ArrayList<String>();
			for (PfTaskVo taskVo : lstTasks) {
				if (!users.contains(taskVo.getUserVo().getUserId())) {
					users.add(taskVo.getUserVo().getUserId());
					taskVo.setTaskId(UUIDGenerator.generate());
					//taskVo.setTaskBefore(null);
					taskVo.setBackState(true);
					this.getTaskService().createTask(taskVo);
				}
			}
			//将其他待办任务删除
			List<PfActivityVo> activitys=this.getTaskService().getWorkFlowInstanceActivityList(subProcessWiid);
			for (PfActivityVo activityVo : activitys) {
				if (!activityVo.getActivityDefinitionId().equals(activityDefinitionId)){
					List<PfTaskVo> tasks=this.getTaskService().getTaskListByActivity(activityVo.getActivityId());
					for(PfTaskVo task:tasks)
						this.getTaskService().deleteTask(task.getTaskId());
				}
			}
			// 修改创建活动的标示和状态
			this.getTaskService().updateActivityBackStadus(backActivityVo.getActivityId(), true);
			this.getTaskService().updateActivityStadus(backActivityVo.getActivityId(),WorkFlowEnum.ACTIVITY_START);
		}

	}

}
