package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;

public class WorkFlowTaskFirstBean extends WorkFlowBeanAbstract {
	
	/**
	 * 工作流的初始化工作
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		try {
			if (infoObj.getSourceTask() != null) {
				String taskId = infoObj.getSourceTask().getTaskId();
				//任务对象
				PfTaskVo taskVo = this.getTaskService().getTask(taskId);
				infoObj.setSourceTask(taskVo);
				//活动对象
				PfActivityVo activityVo = this.getTaskService().getActivity(
						taskVo.getActivityId());
				if (activityVo.getActivityState() != WorkFlowEnum.ACTIVITY_START)
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.StadusChange);
				infoObj.setSourceActivity(activityVo);
				//工作流实例对象
				PfWorkFlowInstanceVo instanceVo = this
						.getWorFlowInstanceService().getWorkflowInstance(
								activityVo.getWorkflowInstanceId());
				if (instanceVo.getWorkflowState() != WorkFlowEnum.WORKFLOW_START)
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.StadusChange);
				infoObj.setWorkFlowIntanceVo(instanceVo);
				//工作流定义
				PfWorkFlowDefineVo workFlowDefineVo = this
						.getWorkFlowDefineService().getWorkFlowDefine(
								instanceVo.getWorkflowDefinitionId());
				if (workFlowDefineVo == null)
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.NoDefine);
				infoObj.setWorkFlowDefineVo(workFlowDefineVo);
			}
		} catch (Exception e) {
			throw new WorkFlowException(
					WorkFlowException.ExceptionNum.StadusChange);
		}
		return true;
	}
}
