package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.TransitionModel;

import java.util.ArrayList;
import java.util.List;

/**
 * 根据转发信息创建活动和任务 需要考虑创建活动的前置条件
 *
 * @author jiff
 */
public class WorkFlowTaskBuilderBean extends WorkFlowBeanAbstract {
    final static String CREATETEMPTASK="CreateTempTask";
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        List<ActivityModel> lstActivityModel = infoObj.getTransInfo()
                .getTranActivitys();

        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
                .getWorkFlowIntanceVo());
        PfActivityVo sourceActivityVo = infoObj.getSourceActivity();
        ActivityModel sourceActivityModel = workXml
                .getActivity(sourceActivityVo.getActivityDefinitionId());
        if (sourceActivityModel.isWaitAllUsers()) { // WaitAllUsers
            List<PfTaskVo> lstTasks = this.getTaskService()
                    .getTaskListByActivity(sourceActivityVo.getActivityId());
            if (lstTasks.size() > 0) {
                if (sourceActivityModel.getExtendedAttribute(CREATETEMPTASK).equalsIgnoreCase("false")){
                    //直接创建的任务
                    List<String> transActivitys=new ArrayList<String>();
                    for (ActivityModel activityModel : lstActivityModel) {
                        BuilderActivity(infoObj, activityModel);
                        transActivitys.add(activityModel.getDefineId());
                    }    
                }else{
                    // 当前活动的其他任务还没有办结,创建临时任务
                    for (ActivityModel activityModel : lstActivityModel) {
                        CreateTempActivityAndTask(infoObj,activityModel);
                    }
                }
            }else{
                //再创建当前任务
                List<String> transActivitys=new ArrayList<String>();
                for (ActivityModel activityModel : lstActivityModel) {
                    BuilderActivity(infoObj, activityModel);
                    transActivitys.add(activityModel.getDefineId());
                }
                //将所有其他人创建的临时任务变成正式任务，这里还要判断这些需要创建的活动的and或xor的条件
                List<PfActivityVo> lstTempActivity=
                        this.getTaskService().getActivityByBefore(infoObj.getSourceActivity().getActivityId());
                if (lstTempActivity!=null){
                    for (PfActivityVo transActivity : lstTempActivity) {
                        if (!transActivitys.contains(transActivity.getActivityDefinitionId())){
                            ActivityModel activityModel=workXml.getActivity(transActivity.getActivityDefinitionId());
                            //UpdateTempActivity(infoObj,activityModel);
                            BuilderActivity(infoObj, activityModel);
                        }
                    }
                }
            }
        } else {
            for (ActivityModel activityModel : lstActivityModel) {
                BuilderActivity(infoObj, activityModel);
            }
        }
        return true;
    }

    private void BuilderActivity(WorkFlowInfo infoObj, ActivityModel activityModel) {
        if (activityModel.getJoinType().equalsIgnoreCase("and")) {
            BuilderAndActivity(infoObj, activityModel);
        } else if (activityModel.getJoinType().equalsIgnoreCase("xor")) {
            BuilderXorActivity(infoObj, activityModel);
            UpdateTempActivity(infoObj, activityModel);
        } else {
            CreateActivityAndTask(infoObj, activityModel);
            UpdateTempActivity(infoObj, activityModel);
        }
    }

    private void BuilderAndActivity(WorkFlowInfo infoObj, ActivityModel activityModel) {
        List<ActivityModel> lstActivityModel = infoObj.getTransInfo()
                .getTranActivitys();
        String workflowInstanceId = infoObj.getWorkFlowIntanceVo()
                .getWorkflowIntanceId();
        List<String> lstFormActivitys = activityModel
                .getFormActivitys();
        boolean isNotAllOver = false;
        //判断前面的节点是否办结
        for (String formActivityId : lstFormActivitys) {
            PfActivityVo vo = this.getTaskService()
                    .getActivityBywIdandadId(workflowInstanceId,
                            formActivityId);
            if (vo==null || (vo != null && vo.getActivityState() == WorkFlowEnum.ACTIVITY_START)) {
                isNotAllOver = true;
                break;
            }
        }
        //判断前面的前面节点是否办结（就考虑2层吧，再多就复杂了暂时不支持）
        if (!isNotAllOver) {
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
                    .getWorkFlowIntanceVo());
            for (String formActivityId : lstFormActivitys) {
                ActivityModel beforeActivityModel=workXml.getActivity(formActivityId);
                List<String> lstBeforeFormActivitys = beforeActivityModel
                        .getFormActivitys();
                for (String formBeforeActivityId : lstBeforeFormActivitys) {
                    PfActivityVo vo = this.getTaskService()
                            .getActivityBywIdandadId(workflowInstanceId,
                                    formBeforeActivityId);
                    if (vo != null && vo.getActivityState() == WorkFlowEnum.ACTIVITY_START) {
                        isNotAllOver = true;
                        break;
                    }
                }
            }
        }
        //需要判断另一种情况，如果转发列表中的活动又是目标活动的前面的活动
        if (!isNotAllOver) {
            int count = 0;
            for (String formActivityId : lstFormActivitys) {
                for (ActivityModel turnActivityModel : lstActivityModel) {
                    if (formActivityId.equals(turnActivityModel.getDefineId())) {
                        count++;
                    }
                }
            }
            if (count > 0)
                isNotAllOver = true;
        }
        if (isNotAllOver) {
            CreateTempActivityAndTask(infoObj, activityModel);
        } else {
            CreateActivityAndTask(infoObj, activityModel);
            UpdateTempActivity(infoObj, activityModel);
        }
    }

    private void BuilderXorActivity(WorkFlowInfo infoObj, ActivityModel activityModel) {
        String workflowInstanceId = infoObj.getWorkFlowIntanceVo()
                .getWorkflowIntanceId();
        // 设置新活动的前置所有活动办结
        List<String> lstFormActivitys = activityModel
                .getFormActivitys();
        for (String formActivityId : lstFormActivitys) {
            PfActivityVo vo = this.getTaskService()
                    .getActivityBywIdandadId(workflowInstanceId,
                            formActivityId);
            this.getTaskService().updateActivityStadus(formActivityId,
                    WorkFlowEnum.ACTIVITY_END);
            this.getTaskService().deleteActivityTask(formActivityId);
        }
        CreateActivityAndTask(infoObj, activityModel);
    }

    private void UpdateTempActivity(WorkFlowInfo infoObj, ActivityModel activityModel) {
        String workflowInstanceId = infoObj.getWorkFlowIntanceVo()
                .getWorkflowIntanceId();
        PfActivityVo newActivityVo = WorkFlowBeanUtil.createActivityVoByModel(activityModel);
        //判断活动是否已经存在
        PfActivityVo aVo = this.getTaskService().getActivityBywIdandadId(workflowInstanceId, newActivityVo.getActivityDefinitionId());
        String newActivityId = "";
        if (aVo != null) {
            newActivityId = UUIDGenerator.generate();
            this.getTaskService().updateTempTask(
                    aVo.getActivityId());
        }
    }

    /**
     * 创建正式的活动和任务
     *
     * @param infoObj
     * @param activityModel
     */
    private void CreateActivityAndTask(WorkFlowInfo infoObj, ActivityModel activityModel) {
        List<PfActivityVo> targetActivitys = new ArrayList<PfActivityVo>();
        List<PfTaskVo> targetTasks = new ArrayList<PfTaskVo>();
        String workflowInstanceId = infoObj.getWorkFlowIntanceVo()
                .getWorkflowIntanceId();
        PfActivityVo newActivityVo = WorkFlowBeanUtil.createActivityVoByModel(activityModel);
        PfActivityVo aVo = this.getTaskService().getActivityBywIdandadId(workflowInstanceId, newActivityVo.getActivityDefinitionId());
        String newActivityId = "";
        if (aVo == null) {
            newActivityId = UUIDGenerator.generate();
            newActivityVo.setActivityId(newActivityId);
            newActivityVo.setWorkflowInstanceId(workflowInstanceId);
            newActivityVo.setActivityBefore(infoObj.getSourceActivity().getActivityId());
            targetActivitys.add(newActivityVo);
        } else {
            newActivityId = aVo.getActivityId();

//            aVo.setBackState(false);
            targetActivitys.add(aVo);
        }

        ///////////////
        String taskBefore= infoObj.getSourceTask().getTaskId();
        List<PfTaskVo> taskList = WorkFlowBeanUtil.createTasks(activityModel.getPerformerModelList(), newActivityId,taskBefore);
        targetTasks.addAll(taskList);
        MergeActivityAndTask(infoObj, targetActivitys, taskList);

    }

    /**
     * 将该需要转发的活动创建为临时活动和任务
     *
     * @param infoObj
     * @param activityModel
     */
    private void CreateTempActivityAndTask(WorkFlowInfo infoObj, ActivityModel activityModel) {
        List<PfActivityVo> targetActivitys = new ArrayList<PfActivityVo>();
        List<PfTaskVo> targetTasks = new ArrayList<PfTaskVo>();
        String workflowInstanceId = infoObj.getWorkFlowIntanceVo()
                .getWorkflowIntanceId();
        PfActivityVo newActivityVo = WorkFlowBeanUtil.createActivityVoByModel(activityModel);
        //判断活动是否已经存在
        PfActivityVo aVo = this.getTaskService().getActivityBywIdandadId(workflowInstanceId, newActivityVo.getActivityDefinitionId());
        String newActivityId = "";
        if (aVo == null) {
            newActivityId = UUIDGenerator.generate();
            newActivityVo.setActivityId(newActivityId);
            newActivityVo.setWorkflowInstanceId(workflowInstanceId);
            newActivityVo.setActivityBefore(infoObj.getSourceActivity().getActivityId());
            targetActivitys.add(newActivityVo);
        } else{
            newActivityId = aVo.getActivityId();
        }
        //targetActivitys.add(newActivityVo);
        ///////////////
        String taskBefore= infoObj.getSourceTask().getTaskId();
        List<PfTaskVo> taskList = WorkFlowBeanUtil.createTasks(activityModel.getPerformerModelList(), newActivityId,taskBefore);
        String tempActivityId = WorkFlowUtil
                .buildTEMPActivityId(newActivityId);
        for (PfTaskVo vo : taskList) {
            vo.setActivityId(tempActivityId);
        }
        targetTasks.addAll(taskList);
        MergeActivityAndTask(infoObj, targetActivitys, taskList);
    }

    public static void MergeActivityAndTask(WorkFlowInfo infoObj, List<PfActivityVo> targetActivitys, List<PfTaskVo> targetTasks) {
        if (infoObj.getTargetActivitys() == null)
            infoObj.setTargetActivitys(targetActivitys);
        else
            infoObj.getTargetActivitys().addAll(targetActivitys);

        if (infoObj.getTargetTasks() == null)
            infoObj.setTargetTasks(targetTasks);
        else
            infoObj.getTargetTasks().addAll(targetTasks);
    }
}
