package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @(#)ZsPlanAction.java 2010-4-23 11:09:45
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					: 工作流重新启动
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class WorkFlowRestartBean extends WorkFlowBeanAbstract {
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        String workflowIntanceId = infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId();
        PfWorkFlowInstanceVo intanceVo = getWorFlowInstanceService().getWorkflowInstance(workflowIntanceId);
        infoObj.setWorkFlowIntanceVo(intanceVo);
        PfWorkFlowDefineVo defineVo = workFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
        infoObj.setWorkFlowDefineVo(defineVo);
        WorkFlowXml workFlowXml =WorkFlowXmlUtil.getDefineModel(defineVo);

        if (intanceVo.getWorkflowState() == WorkFlowEnum.WORKFLOW_END){
            //更新工作流状态
            intanceVo.setWorkflowState(WorkFlowEnum.WORKFLOW_START);
            intanceVo.setRemark(infoObj.getWorkFlowIntanceVo().getRemark());
            getWorFlowInstanceService().updateWorkFlowIntanceStadus(intanceVo);
        }

        // 将退回活动启动
        // 获取首活动
		String activityDefinitionId = workFlowXml.getBeginActivityDefine();
        PfActivityVo backActivityVo = getTaskService().getActivityBywIdandadId(workflowIntanceId,activityDefinitionId);

        // 创建重新开始活动任务
        List<PfTaskVo> lstTasks = this.getTaskService().getHistoryTasks(backActivityVo.getActivityId());
        List<String> users = new ArrayList<String>();
        for (PfTaskVo taskVo : lstTasks) {
            if (!users.contains(taskVo.getUserVo().getUserId())) {
                users.add(taskVo.getUserVo().getUserId());
                taskVo.setTaskId(UUIDGenerator.generate());
                taskVo.setTaskBefore(null);
                taskVo.setBackState(true);
                this.getTaskService().createTask(taskVo);
            }
        }
        //将其他待办任务删除
        List<PfActivityVo> activitys=this.getTaskService().getWorkFlowInstanceActivityList(workflowIntanceId);
        for (PfActivityVo activityVo : activitys) {
            if (!activityVo.getActivityDefinitionId().equals(activityDefinitionId)){
                List<PfTaskVo> tasks=this.getTaskService().getTaskListByActivity(activityVo.getActivityId());
                for(PfTaskVo task:tasks)
                    this.getTaskService().deleteTask(task.getTaskId());
            }
        }
        // 修改创建活动的标示和状态
        this.getTaskService().updateActivityBackStadus(backActivityVo.getActivityId(), true);
        this.getTaskService().updateActivityStadus(backActivityVo.getActivityId(),WorkFlowEnum.ACTIVITY_START);

        return true;
    }
}
