package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;

public class WorkFlowFirstBean extends WorkFlowBeanAbstract {

	/**
	 * 工作流的初始化工作
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception{
		try {
			if (infoObj.getWorkFlowDefineVo() == null) {
				if (infoObj.getWorkFlowIntanceVo() != null) {
					String workDefineId = infoObj.getWorkFlowIntanceVo()
							.getWorkflowDefinitionId();
					infoObj.setWorkFlowDefineVo(this.getWorkFlowDefineService()
							.getWorkFlowDefine(workDefineId));
				}else if (infoObj.getSourceTask()!=null){
					String taskId = infoObj.getSourceTask().getTaskId();
					//任务对象
					PfTaskVo taskVo = this.getTaskService().getTask(taskId);
					infoObj.setSourceTask(taskVo);
					//活动对象
					PfActivityVo activityVo = this.getTaskService().getActivity(
							taskVo.getActivityId());
					infoObj.setSourceActivity(activityVo);
					//工作流实例对象
					PfWorkFlowInstanceVo instanceVo = this
							.getWorFlowInstanceService().getWorkflowInstance(
									activityVo.getWorkflowInstanceId());
					infoObj.setWorkFlowIntanceVo(instanceVo);
					//工作流定义
					PfWorkFlowDefineVo workFlowDefineVo = this
							.getWorkFlowDefineService().getWorkFlowDefine(
									instanceVo.getWorkflowDefinitionId());
					infoObj.setWorkFlowDefineVo(workFlowDefineVo);
				}
			}
		} catch (Exception e) {
			throw new WorkFlowException(WorkFlowException.ExceptionNum.NoDefine);
		}
		return true;
	}
}
