package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;

import java.text.MessageFormat;
import java.util.List;

/**
 * 任务委托
 * 
 * @author jiff
 * 
 */
public class WorkFlowEntrustTaskBean extends WorkFlowBeanAbstract {

	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        PfTaskVo taskVo=this.getTaskService().getTask(infoObj.getSourceTask().getTaskId());
        if (taskVo!=null){
            PfTaskVo targetTaskVo =new PfTaskVo();
            PfUserVo trustUserVo=this.userService.getUserVo(infoObj.getUserId());
            // 办结当前任务
            this.getTaskService().insertTaskHistory(taskVo.getTaskId());
            PfTaskVo taskHisVo = this.getTaskService().getHistoryTask(
                    taskVo.getTaskId());
            taskHisVo.setRemark(MessageFormat.format("将任务委托给【{0}】。",trustUserVo.getUserName()));
            this.getTaskService().updateHistoryTask(taskHisVo);
            this.getTaskService().deleteTask(taskVo.getTaskId());
            //创建代理任务
            targetTaskVo.setActivityId(taskVo.getActivityId());
            targetTaskVo.setTaskId(UUIDGenerator.generate());
            targetTaskVo.setTaskBefore(taskVo.getTaskId());
            targetTaskVo.setUserVo(trustUserVo);
            this.getTaskService().createTask(targetTaskVo);
            return true;
        }
        else
            return false;
	}

}
