package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 判断父结点是否办结，
 *
 * @author jiff
 */
public class ParentActivityFinishBean extends WorkFlowBeanAbstract {
    private SysTaskService taskService;
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
                .getWorkFlowIntanceVo());
        PfActivityVo sourceActivityVo = infoObj.getSourceActivity();
        ActivityModel sourceActivityModel = workXml
        				.getActivity(sourceActivityVo.getActivityDefinitionId());
        if(sourceActivityModel!=null && sourceActivityModel.isWaitAllActivitysFinish()){
            List<String> parentActivityDefIdList = workXml
                          .getToActivitys(sourceActivityVo.getActivityDefinitionId());
            for(String activityDefId:parentActivityDefIdList){
                PfActivityVo activityVo=taskService.getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(), activityDefId);
                if(activityVo==null ||(activityVo!=null && activityVo.getActivityState()!=2))
                    throw new WorkFlowException(activityVo.getActivityName()+new WorkFlowException(WorkFlowException.ExceptionNum.ParentActivitysNoFinish));
            }
        }
        return true;
    }

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }
}
