package com.gtis.plat.wf.bean;

import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowPostService;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.PfWorkFlowPostVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;

import java.util.Calendar;

public class LockWorkFlowInstanceBean extends WorkFlowBeanAbstract {

    SysWorkFlowPostService workFlowPostService;
    SysCalendarService calendarService;

    public void setWorkFlowPostService(SysWorkFlowPostService workFlowPostService) {
        this.workFlowPostService = workFlowPostService;
    }

    public void setCalendarService(SysCalendarService calendarService) {
        this.calendarService = calendarService;
    }

    /**
	 * 挂起工作流
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		String workflowIntanceId = infoObj.getWorkFlowIntanceVo()
				.getWorkflowIntanceId();
		PfWorkFlowInstanceVo intanceVo = super.getWorFlowInstanceService()
				.getWorkflowInstance(workflowIntanceId);
		if (intanceVo.getWorkflowState() != WorkFlowEnum.WORKFLOW_STOP) {
			intanceVo.setWorkflowState(WorkFlowEnum.WORKFLOW_STOP);
			//intanceVo.setRemark(infoObj.getWorkFlowIntanceVo().getRemark());
            PfTaskVo sourceTask=super.getTaskService().getTask(infoObj.getSourceTask().getTaskId());
            //super.getTaskService().getActivity(sourceTask.getActivityId());
            //if (StringUtils.isNotBlank(infoObj.getWorkFlowIntanceVo().getRemark()))
                //super.getTaskService().updateActivityRemark(sourceTask.getActivityId(),infoObj.getWorkFlowIntanceVo().getRemark());
			super.getWorFlowInstanceService().updateWorkFlowIntanceStadus(
                    intanceVo);
            super.getWorFlowInstanceService().updateWorkFlowIntanceOverTime(workflowIntanceId,calendarService.getMaxDate());
            super.getTaskService().updateTaskOverTime(sourceTask.getTaskId(),calendarService.getMaxDate());

            PfWorkFlowPostVo workFlowPostVo=new PfWorkFlowPostVo();
            workFlowPostVo.setWorkflowIntanceId(intanceVo.getWorkflowIntanceId());
            workFlowPostVo.setTaskId(sourceTask.getTaskId());
            workFlowPostVo.setPostDate(Calendar.getInstance().getTime());
            workFlowPostVo.setPostUser(SessionUtil.getCurrentUserId());
            workFlowPostVo.setPostReason(infoObj.getWorkFlowIntanceVo().getRemark());
            workFlowPostService.createPost(workFlowPostVo);
		}else{
			throw new WorkFlowException(WorkFlowException.ExceptionNum.AlreadyStop);
		}
		return true;
	}
}

