package com.gtis.plat.task;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysDzjcDAO;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.vo.PfSmsVo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/8/30
 */
public class OvertimeTaskRemind implements InitializingBean {

    static Logger logger = LoggerFactory.getLogger(OvertimeTaskRemind.class);

    private SysSmsService sysSmsService;
    private SysDzjcDAO sysDzjcDAO;
    private boolean enabled;
    @Override
    public void afterPropertiesSet() throws Exception {
        enabled = AppConfig.getBooleanProperty("overtimeTask.smsRemind.enable",false);
    }

    private void sendSmsMsg(PfSmsVo pfSmsVo){
        try {
            sysSmsService.sendMsg(pfSmsVo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remindOvertimeTask(){
        if(enabled){
            List<Map> overtimeTaskList = sysDzjcDAO.QueryActivityOvertime();
            if(overtimeTaskList.size()>0){
                for(Map overtimeTask:overtimeTaskList){
                    if(overtimeTask.get("MOBILE_PHONE")!=null&& StringUtils.isNotBlank(String.valueOf(overtimeTask.get("MOBILE_PHONE")))){
                        PfSmsVo pfSmsVo = new PfSmsVo();
                        pfSmsVo.setSmsId(UUIDGenerator.generate());
                        pfSmsVo.setMobileNo(String.valueOf(overtimeTask.get("MOBILE_PHONE")));
                        pfSmsVo.setSendDate(Calendar.getInstance().getTime());
                        String workflowName = String.valueOf(overtimeTask.get("WORKFLOW_NAME"));
                        String projectName = String.valueOf(overtimeTask.get("WORKFLOW_INSTANCE_NAME"));
                        String activityName = String.valueOf(overtimeTask.get("ACTIVITY_NAME"));
                        String overtime = String.valueOf(overtimeTask.get("CDAY"));
                        String smsContent = "您当前有{0}类型项目：{1},在{2}节点已超期{3}天，请尽快办理！";
                        smsContent = MessageFormat.format(smsContent, workflowName,projectName,activityName,overtime);
                        pfSmsVo.setContent(smsContent);
                        sendSmsMsg(pfSmsVo);
                    }

                }
            }
        }

    }

    public SysSmsService getSysSmsService() {
        return sysSmsService;
    }

    public void setSysSmsService(SysSmsService sysSmsService) {
        this.sysSmsService = sysSmsService;
    }

    public SysDzjcDAO getSysDzjcDAO() {
        return sysDzjcDAO;
    }

    public void setSysDzjcDAO(SysDzjcDAO sysDzjcDAO) {
        this.sysDzjcDAO = sysDzjcDAO;
    }
}
