package com.gtis.plat.service.impl.search;

import com.gtis.common.AbstractSplitDataIndexProvider;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.*;
import com.gtis.search.*;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class SysWorkFlowIndexProviderImpl extends AbstractSplitDataIndexProvider<PfWorkFlowInstanceVo> {
    private SysWorkFlowInstanceDao intanceDAO;
    private SysUserService sysUserService;
    private SysWorkFlowDefineService workFlowDefineService;
    private SysTaskService taskService;
    private BusinessFactory defaultBusinessFactory;
    private CategoryFactory defaultCategoryFactory;

    public void setIntanceDAO(SysWorkFlowInstanceDao intanceDAO) {
        this.intanceDAO = intanceDAO;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setDefaultBusinessFactory(BusinessFactory defaultBusinessFactory) {
        this.defaultBusinessFactory = defaultBusinessFactory;
    }

    public void setDefaultCategoryFactory(CategoryFactory defaultCategoryFactory) {
        this.defaultCategoryFactory = defaultCategoryFactory;
    }

    @Override
    public List<Business> getBusinesses() {
        List<Business> businesses = super.getBusinesses();
        for (Business sBiz : getSysBusinesses()) {
            int i = businesses.indexOf(sBiz);
            if (i > -1) {
                Business biz = businesses.get(i).clone();
                biz.setLastModified(null);
                if (biz.getName() == null) {
                    biz.setName(sBiz.getName());
                }
                if (biz.getIcon() == null) {
                    biz.setIcon(sBiz.getIcon());
                }
                for (Map.Entry<String, String> entry : sBiz.getTpls().entrySet()) {
                    Map<String, String> tpls = biz.getTpls();
                    if (!tpls.containsKey(entry.getKey())) {
                        tpls.put(entry.getKey(), entry.getValue());
                    }
                }
                for (Map.Entry<String, Serializable> entry : sBiz.getTplVars().entrySet()) {
                    Map<String, Serializable> vars = biz.getTplVars();
                    if (!vars.containsKey(entry.getKey())) {
                        vars.put(entry.getKey(), entry.getValue());
                    }
                }
                List<Category> categories = biz.getCategories();
                List<Category> sysCategory = sBiz.getCategories();
                for (Category sCat : sysCategory) {
                    int j = categories.indexOf(sCat);
                    if (j > -1) {
                        Category cat = categories.get(j);
                        if (cat.getName() == null) {
                            cat.setName(sBiz.getName());
                        }
                        if (cat.getIcon() == null) {
                            cat.setIcon(sBiz.getIcon());
                        }
                    } else {
                        categories.add(sCat);
                    }
                }
                businesses.set(i, biz);
            } else {
                businesses.add(sBiz);
            }
        }
        return businesses;
    }

    protected Collection<Business> getSysBusinesses() {
        Map<String, Business> map = new LinkedHashMap<String, Business>();
        for (PfWorkFlowDefineVo vo : workFlowDefineService.getWorkFlowDefineList()) {
            Business biz = map.get(vo.getBusinessId());
            if (biz == null) {
                biz = defaultBusinessFactory.getBusiness().clone();
                biz.setCategories(new ArrayList<Category>());
                PfBusinessVo bvo = vo.getBusinessVo();
                biz.setId(vo.getBusinessId());
                if (StringUtils.isNotBlank(bvo.getBusinessCode()))
                    biz.setIcon(bvo.getBusinessCode());
                biz.setName(bvo.getBusinessName());
                map.put(vo.getBusinessId(), biz);
            }
            Category cat = defaultCategoryFactory.getCategory(biz).clone();
            cat.setId(vo.getWorkflowDefinitionId());
            cat.setName(vo.getWorkflowName());
            if (StringUtils.isNotBlank(vo.getWorkflowCode()))
                cat.setIcon(vo.getWorkflowCode());
            biz.getCategories().add(cat);
        }
        return map.values();
    }

    @Override
    protected PfWorkFlowInstanceVo getEntity(String categoryId, String id) {
        return intanceDAO.getWorkflowInstance(id);
    }

    @Override
    protected void extractEntity(PfWorkFlowInstanceVo entity, Index index) {
        index.setBusinessId(workFlowDefineService.getWorkFlowDefine(entity.getWorkflowDefinitionId()).getBusinessId());
        index.setCategoryId(entity.getWorkflowDefinitionId());
        index.setId(entity.getWorkflowIntanceId());
        index.setTitle(entity.getWorkflowIntanceName());
        index.setDate(getWfDate(entity));
        PfUserVo user = sysUserService.getUserVo(entity.getCreateUser());
        if (user != null) {
            index.appendBody(user.getUserName());
        }
        index.appendBody(entity.getRemark());
    }

    private Date getWfDate(PfWorkFlowInstanceVo entity) {
        Date date = new Date();
        List<PfActivityVo> list = taskService.getWorkFlowInstanceActivityList(entity.getWorkflowIntanceId());
        if (!list.isEmpty()) {
            date = list.get(0).getBeginTime();
        }
        if (date == null) {
            date = entity.getCreateTime();
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    @Override
    protected String getStatementName() {
        return "getWorkFlowInstanceList";
    }

    @Override
    protected void parepareSplitParams(Map<String, String> params, String categoryId) {
        params.put("WORKFLOW_DEFINITION_ID", categoryId);
    }
}
