package com.gtis.plat.service.impl.search;

import com.gtis.common.AbstractSplitDataIndexProvider;
import com.gtis.plat.service.SysNewsService;
import com.gtis.plat.vo.PfNewsVo;
import com.gtis.search.Category;
import com.gtis.search.Index;
import org.apache.commons.lang.StringUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-11
 */
public class NewsIndexProviderImpl extends AbstractSplitDataIndexProvider<PfNewsVo> {
    private SysNewsService sysNewsService;

    public void setSysNewsService(SysNewsService sysNewsService) {
        this.sysNewsService = sysNewsService;
    }

    @Override
    protected PfNewsVo getEntity(String categoryId, String id) {
        return sysNewsService.getNewsById(id);
    }

    @Override
    protected void extractEntity(PfNewsVo entity, Index index) {
        Category cat = getDefaultCategory();
        index.setBusinessId(cat.getBusinessId());
        index.setCategoryId(cat.getId());
        index.setId(entity.getNewsId());
        index.setTitle(entity.getNewsTitle());
        index.setDate(entity.getNewsDate());
        String body = StringUtils.replace(entity.getNewsContent(), "&nbsp;", "");
        body = StringUtils.replace(body, "nbsp;", "");
        index.appendBody(body, 500);
        if (StringUtils.isNotBlank(entity.getImageUrl()))
            index.addField("img", entity.getImageUrl());
    }

    @Override
    protected String getStatementName() {
        return "getNewsList1";
    }
}
