package com.gtis.plat.service.impl;

import com.gtis.common.util.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.*;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.util.*;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
/**
 * 
* @文件名 SysSjdServiceImpl.java
 * @作者 卢向伟
 * @创建日期 2013-11-1
 * @创建时间 下午7:58:43 
 * @版本号 V 1.0
 */
public class SysSjdServiceImpl implements SysSjdService {
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private NodeService nodeService;
	private BaseDao sjdDaoImpl;

	public SjdVo getSjdVoByProid(String proid) {
		return sjdDaoImpl.getObject(proid,"PROID");
	}

	public List<SjdclVo> getSjdclListByProid(String proid) {
		SjdVo vo = getSjdVoByProid(proid);
		if (vo != null) {
			return SjdUtil.getSjdclListBySjdVo(vo);
		}
		return null;
	}
	public BaseDao getSjdDaoImpl() {
		return sjdDaoImpl;
	}
	public void setSjdDaoImpl(BaseDao sjdDaoImpl) {
		this.sjdDaoImpl = sjdDaoImpl;
	}

    public void createSjdByPreviousWorkflow(String proId,String userName,Integer nodeId,String oldProId){
        try {
            String configId = "";
            String configName = "";
            PfWorkFlowInstanceVo newWorkflowInstance = sysWorkFlowInstanceService.getWorkflowInstance(proId);
            if (newWorkflowInstance != null && StringUtils.isNotBlank(newWorkflowInstance.getWorkflowDefinitionId())) {
                configId = newWorkflowInstance.getWorkflowDefinitionId();
                PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(configId);
                configName = workFlowDefineVo.getWorkflowName();
            }
            if (StringUtils.isBlank(configId)) {
                configId = "custom";
            }
            SjdVo sjdVo = new SjdVo();
            sjdVo.setProid(newWorkflowInstance.getProId());
            sjdVo.setSjdid(com.gtis.common.util.UUIDGenerator.generate());
            sjdVo.setSjd_sj_date(CommonUtil.getCurrDate());
            sjdVo.setSjd_sjr(userName);
            sjdVo.setBusiType(configId);
            sjdVo.setSjd_sqlx(configName);

            sjdVo.setSjd_bh_year(Integer.parseInt(CommonUtil.getCurrYear()));
            HashMap param = new HashMap();
            if (StringUtils.isNotBlank(configName)) {
                param.put("SJD_SQLX",configName);
            }
            param.put("SJD_BH_YEAR",sjdVo.getSjd_bh_year());
            Integer bh_xh = sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
            if (bh_xh == null) {
                bh_xh = 0;
            }
            sjdVo.setSjd_bh_xh(bh_xh+1);
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            String lsh = decimalFormat.format(sjdVo.getSjd_bh_xh());
            sjdVo.setSjd_bh("");
            sjdDaoImpl.insertObjectByIbatisStr(sjdVo,null);

            SjdVo relsjdVo=getSjdVoByProid(oldProId);
            List relsjdclList = new ArrayList();
            if (relsjdVo != null && relsjdVo.getSjd_cl() != null) {
                sjdVo.setSjd_cl(relsjdVo.getSjd_cl());
                relsjdclList = SjdUtil.getSjdclListBySjdVo(sjdVo);
            }
            initDefaultFile(sjdVo, nodeId, configId, relsjdclList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertSjdVo(String proid,String userName,String busiType,String sqlx) {
        SjdVo sjdVo = new SjdVo();
        sjdVo.setProid(proid);
        sjdVo.setSjdid(com.gtis.common.util.UUIDGenerator.generate());
        sjdVo.setSjd_sj_date(CommonUtil.getCurrDate());
        if(StringUtils.isNotBlank(userName))
            sjdVo.setSjd_sjr(userName);
        if (StringUtils.isBlank(busiType)) {
            sjdVo.setBusiType("custom");
        }else{
            sjdVo.setBusiType(busiType);
        }
        
        SimpleDateFormat sdf1= new SimpleDateFormat("yyyyMMdd");
        sjdVo.setSjd_bh_year(Integer.parseInt(sdf1.format(new Date())));
        HashMap param = new HashMap();
        if (StringUtils.isNotBlank(sqlx)) {
            param.put("SJD_SQLX",sqlx);
            sjdVo.setSjd_sqlx(sqlx);
        }
        param.put("SJD_BH_YEAR",sjdVo.getSjd_bh_year());
        Integer bh_xh = sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
        if (bh_xh == null) {
            bh_xh = 0;
        }
        sjdVo.setSjd_bh_xh(bh_xh+1);
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        String lsh = decimalFormat.format(sjdVo.getSjd_bh_xh());
        String bh = sqlx + sjdVo.getSjd_bh_year() + lsh;
        sjdVo.setSjd_bh(bh);
        sjdDaoImpl.insertObjectByIbatisStr(sjdVo,null);
    }

    private List<SjdclVo> initDefaultFile(SjdVo vo,int nid,String wdid,List<SjdclVo> clList){
        try {
            if (clList == null) {
                clList = new ArrayList<SjdclVo>();
            }
            String curFileNames = "";
            for (int i = 0; i < clList.size(); i++) {
                curFileNames += "[@"+clList.get(i).getName()+"@],";
            }
            HashMap param = new HashMap();
            param.put("WORKFLOW_DEFINITION_ID", wdid);
            List<StuffConfigVo> zdbList = sjdDaoImpl.getObjectListByIbatisStr(param, "get_PF_STUFF_CONFIG");
            if(zdbList != null && zdbList.size() > 0){
                for (int i = 0; i < zdbList.size(); i++) {
                    StuffConfigVo configVo = zdbList.get(i);
                    if (configVo != null && StringUtils.isNotBlank(configVo.getStuffName())) {
                        //如果有重复资料名称，则不予处理，只有不重复资料名称的记录才进行存储
                        if (StringUtils.indexOf(curFileNames, "[@"+configVo.getStuffName()+"@]") < 0) {
                            SjdclVo clVo = new SjdclVo();
                            clVo.setData_id(UUIDGenerator.generate());
                            clVo.setProid(vo.getProid());
                            clVo.setSjdid(vo.getSjdid());
                            clVo.setName(configVo.getStuffName());
                            clVo.setXh(configVo.getStuffXh());
                            clVo.setNum(configVo.getStuffCount());
                            clVo.setBz(configVo.getRemark());
                            clVo.setType(configVo.getMeterial());
                            clVo.setYsnum(configVo.getYsnum());
                            clVo.setDbnum(configVo.getDbnum());
                            //每一个材料创建之后，创建对应的文件中心id
                            Node nodeChild = getOrCreateNode(nid,clVo.getName());
                            clVo.setNode_id(nodeChild.getId());
                            clList.add(i,clVo);
                        }
                    }
                }
            }
            //将初始化好的材料列表存储到材料字段中
            if (clList != null) {
                String clJson = JSONUtil.serialize(clList);
                vo.setSjd_cl(clJson.getBytes());
                sjdDaoImpl.updateObjectByIbatisStr(vo,"update_PF_SJD_CL");
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return clList;
    }

    private Node getOrCreateNode(Integer nid,String fName){
        Node nodeChild = null;
        try {
            nodeChild = nodeService.getNode(nid, fName, true);//getChildNode(nid, fName);
        } catch (Exception e) {
            nodeChild = nodeService.createNode(nid,fName);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            nodeService.save(nodeChild);
        }
        if (nodeChild == null) {
            nodeChild = nodeService.getNode(nid,fName, true);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            nodeService.save(nodeChild);
        }
        return nodeChild;
    }

    public NodeService getNodeService() {
        return nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public SysWorkFlowDefineService getSysWorkFlowDefineService() {
        return sysWorkFlowDefineService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }
}
