package com.gtis.plat.service.impl;

import java.util.List;
import java.util.Map;

import com.gtis.plat.dao.SysMessageDAO;
import com.gtis.plat.service.SysMessageAwokeService;
import com.gtis.plat.vo.PfMessageAcceptAwokeVo;
import com.gtis.plat.vo.PfMessageAcceptVo;
import com.gtis.plat.vo.PfMessageSendAwokeVo;


public class SysMessageAwokeServiceImpl implements SysMessageAwokeService{

	private SysMessageDAO sysMessageDao;

	public void setSysMessageDao(SysMessageDAO sysMessageDao) {
		this.sysMessageDao = sysMessageDao;
	}
    
	public PfMessageAcceptAwokeVo getAcceptAwoke(String msgAcceptAwokeId) {
		return sysMessageDao.getAcceptMsgAwoke(msgAcceptAwokeId);
	}
    
	public PfMessageSendAwokeVo getSendAwoke(String msgSendAwokeId) {
		return sysMessageDao.getSendMsgAwokeById(msgSendAwokeId);
	}
    
	public boolean insertNotifyAwoke(PfMessageSendAwokeVo vo) {
		 return sysMessageDao.insertMsgAwoke(vo);
	}

	public void updateNotifyStatus(String msgAwokeId) {
		sysMessageDao.updateNotifyStatus(msgAwokeId);
	}

	public void delAcceptAwokeById(String awokeAcceptId) {
		sysMessageDao.delAcceptAwokeById(awokeAcceptId);
	}

	public void delSendAwokeById(String awokeSendId) {
		sysMessageDao.delSendAwokeById(awokeSendId);
	}

	public String getReadedAwokeByAwokeId(String awokeId){
		return sysMessageDao.getReadedAwokeCount(awokeId);
	}

	public List<PfMessageAcceptAwokeVo> getAcceptNotifyListRss(Map<String, String> map) {
		return sysMessageDao.getAcceptNotifyListRss(map);
	}

    public List<PfMessageSendAwokeVo> getSendMsgAwokeByTitle(String sendMsgTitle){
        return sysMessageDao.getSendMsgAwokeByTitle(sendMsgTitle);
    }
}
