package com.gtis.plat.service.impl;

import java.util.HashMap;
import java.util.List;

import com.gtis.plat.dao.SysDynamicSignDao;
import com.gtis.plat.service.SysDynamicSignService;
import com.gtis.plat.vo.PFDynamicSignVo;
import com.gtis.plat.vo.PfUserSignVo;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;


/**
 * 动态签名
 * @author xtdi
 *
 */
public class SysDynamicSignServiceImpl implements SysDynamicSignService{
   private SysDynamicSignDao dynamicSignDao;
	public List<PFDynamicSignVo> getDynamicSign(HashMap<String,String> paraMap){
		return dynamicSignDao.getDynamicSign(paraMap);
	}

    @Caching(evict={
            @CacheEvict(value="SignCache",allEntries=true)
    })
	public void  saveDynamicSign(PFDynamicSignVo dynamicSignVo){
		dynamicSignDao.saveDynamicSign(dynamicSignVo);
	}

    @Caching(evict={
            @CacheEvict(value="SignCache",allEntries=true)
    })
	public void updateDynamicSign(PFDynamicSignVo dynamicSignVo){
		dynamicSignDao.updateDynamicSign(dynamicSignVo);
	}
	
	public List<PfUserSignVo> getUserSign(HashMap<String,String> paraMap){
		return dynamicSignDao.getUserSign(paraMap);
	}
	public SysDynamicSignDao getDynamicSignDao() {
		return dynamicSignDao;
	}
	public void setDynamicSignDao(SysDynamicSignDao dynamicSignDao) {
		this.dynamicSignDao = dynamicSignDao;
	}
	public List<PfUserSignVo> getUserSignBySignKey(HashMap<String,String> paraMap){
		 
		return dynamicSignDao.getUserSignBySignKey( paraMap);
	}

    @Caching(evict={
            @CacheEvict(value="SignCache",allEntries=true)
    })
	public void deleteUserSignByProId(String proId) {
		dynamicSignDao.deleteUserSignByProId(proId);
	}

    @Caching(evict={
            @CacheEvict(value="SignCache",allEntries=true)
    })
	public void deleteUserSignBySignId(String signId){
		dynamicSignDao.deleteUserSignByProId(signId);
	}

    @Caching(evict={
            @CacheEvict(value="SignCache",allEntries=true)
    })
	public void deleteUserSignBySignIds(List<String> signIds){
		dynamicSignDao.deleteUserSignBySignIds(signIds);
	}
}
