package com.gtis.plat.service.impl;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

import com.gtis.plat.dao.SysAuthorDao;
import com.gtis.plat.dao.SysTaskDao;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import java.util.*;
import javax.servlet.http.HttpServletRequest;

public class SysAuthorServiceImpl implements SysAuthorService {

	SysAuthorDao authorDAO;
	SysWorkFlowInstanceDao intanceDAO;
	SysTaskDao taskDao;

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#getTaskFormFunAuthorList(java.lang.String, java.lang.String)
	 */
	public List<PfPartitionInfoVo> getTaskFormFunAuthorList(String taskId,String roles,
			String rId) {
		List<PfPartitionInfoVo> lstResult = new Vector<PfPartitionInfoVo>();
		if (taskId == null || taskId.equals("")) {
			return lstResult;
		}
		PfTaskVo taskVo = taskDao.getTaskAll(taskId);
		PfActivityVo activityVo = taskDao.getActivity(taskVo.getActivityId());
		PfWorkFlowInstanceVo workFlowInstanceVo = intanceDAO.getWorkflowInstance(activityVo.getWorkflowInstanceId());

		//if (roles != null && !roles.equals("")) {
			lstResult = authorDAO.getTaskFormFunAuthorList(workFlowInstanceVo
							.getWorkflowDefinitionId(), activityVo
							.getActivityDefinitionId(), rId);
		//}
		return lstResult;
	}

	public List<PfPartitionInfoVo> getTaskFormAuthorList(String taskId,String roles,
			String rId) {
		List<PfPartitionInfoVo> lstResult = new Vector<PfPartitionInfoVo>();
		if (taskId == null || taskId.equals("")) {
			return lstResult;
		}
		PfTaskVo taskVo = taskDao.getTask(taskId);
		PfActivityVo activityVo = taskDao.getActivity(taskVo.getActivityId());
		PfWorkFlowInstanceVo workFlowInstanceVo = intanceDAO.getWorkflowInstance(activityVo.getWorkflowInstanceId());

		if (roles != null && !roles.equals("")) {
			lstResult = authorDAO.getTaskFormAuthorList(workFlowInstanceVo
							.getWorkflowDefinitionId(), activityVo
							.getActivityDefinitionId(), rId);
		}
		return lstResult;
	}	
	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#getProjectResrouceFunAuthorList(java.lang.String, java.lang.String)
	 */
	public List<PfPartitionInfoVo> getProjectResrouceFunAuthorList(String proid,
			String roles, String rId) {
		List<PfPartitionInfoVo> lstResult = new Vector<PfPartitionInfoVo>();
		if (proid == null || proid.equals("")) {
			return lstResult;
		}
		PfWorkFlowInstanceVo workFlowInstanceVo = intanceDAO.getWorkflowInstanceByProId(proid);
		//if (roles != null && !roles.equals("")) {
			Object result = authorDAO.getIntanceAuthorXML(workFlowInstanceVo
					.getWorkflowDefinitionId(), rId, roles);
			lstResult = new ArrayList<PfPartitionInfoVo>();
			try {
				if (result != null) {
					Document doc = DocumentHelper.parseText("<Rows>" + result.toString() + "</Rows>");
					List<Node> lstNodes = (List<Node>) doc
							.selectNodes("//Partition[@OperType='0']");
					for (Node node : lstNodes) {
						String pId = node.valueOf("@Id");
						List<PfPartitionInfoVo> lstResult1 = authorDAO.getPartitionFunList(pId);
                        //lstResult.addAll(lstResult1);
                        for(PfPartitionInfoVo partitionInfoVo:lstResult1){
                            if (!IsPartitionAlReadyIn(lstResult,partitionInfoVo.getElementId()))
                                lstResult.add(partitionInfoVo);
                        }
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		//}

		for (int i=0;i<lstResult.size();i++){//此处疑似数据查询脚本有错误，返回的operate_type值是-1,此处通过本循环进行修正为0
			lstResult.get(i).setOperateType(0);
		}


		return lstResult;
	}

    /**
     * 判断元素是否已经在list中了
     * @param lstResult
     * @return
     */
    private boolean  IsPartitionAlReadyIn(List<PfPartitionInfoVo> lstResult,String eId){
        for(PfPartitionInfoVo partitionInfoVo:lstResult){
            if (partitionInfoVo.getElementId().equals(eId)){
                return true;
            }
        }
        return false;
    }
	/**
	 * 如果是从系统主界面进入，获取相应的权限
	 * @return
	 */
	public List<PfPartitionInfoVo> getSystemResrouceFunAuthorList(String roles, String rId){
		List<PfPartitionInfoVo> lstResult = null;
		if (roles != null && roles.trim().length()>0) {
			lstResult = authorDAO.getSystemResrouceEnableList(rId, roles);
		}
		return lstResult;
	}
	
	
	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#processXmlDocument(org.dom4j.Document, java.lang.String, java.lang.String)
	 */
	public void processXmlDocument(Document doc, String taskId,
			String resourceId) {
		PfTaskVo taskVo = taskDao.getTask(taskId);
		PfActivityVo activityVo = taskDao.getActivity(taskVo
					.getActivityId());
		PfWorkFlowInstanceVo vo = intanceDAO.getWorkflowInstance(activityVo.getWorkflowInstanceId());
		String wdId = vo.getWorkflowDefinitionId();
		
		String aId = activityVo.getActivityDefinitionId();
		if (wdId == null || aId == null)
			processXmlReadOnly(doc);
		else {
			List<PfPartitionInfoVo> lstElement = authorDAO
					.getTaskFormAuthorList(wdId, aId, resourceId);
			processXmlDocument(doc, buildElementMap(lstElement));
		}
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#processProjectXmlDocument(org.dom4j.Document, javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public void processProjectXmlDocument(Document doc,
			HttpServletRequest request, String resourceId) {
		// String rolesId=UserInfoService.getAllRolesId(request);
		// List<PfPartitionInfoVo>
		// lstElement=authorDAO.getProjectResrouceAuthorList(resourceId,
		// rolesId);
		// processXmlDocument(doc,buildElementMap(lstElement));
		processXmlReadOnly(doc);
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#processSystemXmlDocument(org.dom4j.Document, javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public void processSystemXmlDocument(Document doc,
			HttpServletRequest request, String resourceId) {
		String rolesId = SessionUtil.getUserInfo(request).getRoleIds();
		List<PfPartitionInfoVo> lstElement = authorDAO
				.getSystemResrouceAuthorList(resourceId, rolesId);
		processXmlDocument(doc, buildElementMap(lstElement));
	}

	private HashMap<String, PfPartitionInfoVo> buildElementMap(
			List<PfPartitionInfoVo> lstElement) {
		HashMap<String, PfPartitionInfoVo> map = new HashMap<String, PfPartitionInfoVo>();
		for (PfPartitionInfoVo vo : lstElement) {
			map.put(vo.getElementId(), vo);
		}
		return map;
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#processXmlReadOnly(org.dom4j.Document)
	 */
	public void processXmlReadOnly(Document doc) {
		List lstNodes = doc.selectNodes("//ElementDefine");
		for (int i = 0; i < lstNodes.size(); i++) {
			Element elementData = (Element) lstNodes.get(i);
			elementData.addAttribute("Disabled", "true");
		}

		List lstGroupNodes = doc.selectNodes("//GroupDefine");
		for (int i = 0; i < lstGroupNodes.size(); i++) {
			Element elementData = (Element) lstGroupNodes.get(i);
			elementData.addAttribute("Disabled", "true");
			List lstChildNodes = elementData.selectNodes("ElementDefine");
			for (int j = 0; j < lstChildNodes.size(); j++) {
				Element elementChildData = (Element) lstChildNodes.get(j);
				elementChildData.addAttribute("Disabled", "true");
			}

		}
	}

	private void processXmlDocument(Document doc,
			HashMap<String, PfPartitionInfoVo> map) {
		List lstNodes = doc.selectNodes("//Define/ElementDefine");
		StringBuffer strOprateId = new StringBuffer();
		for (int i = 0; i < lstNodes.size(); i++) {
			Element elementData = (Element) lstNodes.get(i);
			String id = elementData.valueOf("@Id");
			if (map.get(id) != null) {
				PfPartitionInfoVo element = map.get(id);
				// element.getOperateType() + "++");
				if (element.getOperateType() > 0)
					elementData.addAttribute("Disabled", "true");
				else {
					elementData.addAttribute("Disabled", "");
					strOprateId.append(element.getElementId() + ",");
				}
			} else {
				strOprateId.append(id + ",");
			}
		}

		List lstGroupNodes = doc.selectNodes("//GroupDefine");
		for (int i = 0; i < lstGroupNodes.size(); i++) {
			Element elementData = (Element) lstGroupNodes.get(i);
			String id = elementData.valueOf("@Id");
			if (map.get(id) != null) {
				PfPartitionInfoVo element = map.get(id);
				// System.out.print(element.getElementId()+
				// element.getOperateType() + "++");
				if (element.getOperateType() > 0) {
					elementData.addAttribute("Disabled", "true");
					List lstChildNodes = elementData
							.selectNodes("ElementDefine");
					for (int j = 0; j < lstChildNodes.size(); j++) {
						Element elementChildData = (Element) lstChildNodes
								.get(j);
						elementChildData.addAttribute("Disabled", "true");
					}
				} else {
					elementData.addAttribute("Disabled", "");
					List lstChildNodes = elementData
							.selectNodes("ElementDefine");
					for (int j = 0; j < lstChildNodes.size(); j++) {
						Element elementChildData = (Element) lstChildNodes
								.get(j);
						elementChildData.addAttribute("Disabled", "");
					}
				}
			} else {
				strOprateId.append(id + ",");
			}
		}
		strOprateId.append("-1");
		addHiddenElement(doc, strOprateId.toString());
	}

	private void addHiddenElement(Document iDoc, String xml) {
		Element root = iDoc.getRootElement();
		Element hiddenNode = (Element) root.selectSingleNode("//HiddenData");
		if (hiddenNode == null)
			hiddenNode = root.addElement("HiddenData");
		try {
			// 当前人
			Element tmpNode = hiddenNode.addElement("ElementData");
			tmpNode.addAttribute("Id", "_ElmenetIdArray");
			tmpNode.setText(xml);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/* (non-Javadoc)
	 * @see com.gtis.plat.service.impl.SysAuthorService#getAuthorJsHtml(java.util.List)
	 */
	public String getAuthorJsHtml(List<PfPartitionInfoVo> lstElement) {
		StringBuffer strBuffer = new StringBuffer();
		for (PfPartitionInfoVo vo : lstElement) {
			if (vo.getOperateType() > 0)
				strBuffer.append("setControl('" + vo.getElementId()
						+ "',false);");
		}
		return strBuffer.toString();
	}

    /**
     * 判断一个特定元素的权限
     * @param wiid
     * @param taskid
     * @param rId
     * @param eleName
     * @return
     */
    public boolean queryTaskElement(String wiid,String taskid, String rId,String eleName){
        return authorDAO.queryTaskElement(wiid,taskid,rId,eleName);
    }
    
	public SysAuthorDao getAuthorDAO() {
		return authorDAO;
	}

	public void setAuthorDAO(SysAuthorDao authorDAO) {
		this.authorDAO = authorDAO;
	}

	public SysWorkFlowInstanceDao getIntanceDAO() {
		return intanceDAO;
	}

	public void setIntanceDAO(SysWorkFlowInstanceDao intanceDAO) {
		this.intanceDAO = intanceDAO;
	}

	public SysTaskDao getTaskDao() {
		return taskDao;
	}

	public void setTaskDao(SysTaskDao taskDao) {
		this.taskDao = taskDao;
	}

}
