package com.gtis.plat.form.print.xmlutil;

import org.apache.commons.lang.StringUtils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ResultSetXml {
	
	public final static String DATA_TYPE_MASTER="master";//表示主表数据
	public final static String DATA_TYPE_DETAIL="detail";//表示从表数据
	
	private ResultSet rs=null;
	private String datatype="master";
	
	public ResultSetXml(ResultSet rs,String datatype) {
		this.rs=rs;
		this.datatype=datatype;
	}
	
	public String getXMLData()
	{
		String retvalue="";
		if (datatype.equalsIgnoreCase("Master"))
			retvalue=getMaster();
		else
			retvalue=getDetial();

		return retvalue;
	}

	private String getDetial()
	{
		String xml="";
		String lineStr="";
		String datavalue="";
		try
		{
			ResultSetMetaData rsmd=rs.getMetaData();
			if(rsmd != null){
		        int count  = rsmd.getColumnCount();
		        int j=0;
		        while (rs.next())
		        {
		        	xml=xml+"<row ID=\""+j+"\">\n";
		        	int i=1;
			        for(i=1;i<=count;i++){
			        	lineStr="";
			        	
			        	String fieldType = rsmd.getColumnTypeName(i);
//			        	System.out.println(rsmd.getColumnName(i)+"  type="+ttype);
			        	if (fieldType.equalsIgnoreCase("date")){
			        		Date tempDate =rs.getDate(rsmd.getColumnName(i));
			        		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd"); 
			        		datavalue = sdf.format(tempDate); 
			        	}else if(fieldType.equalsIgnoreCase("varchar2")||fieldType.equalsIgnoreCase("varchar")||fieldType.equalsIgnoreCase("char")){
			        		datavalue=rs.getString(rsmd.getColumnName(i));
			        	}else if(fieldType.equalsIgnoreCase("number")){
			        		datavalue=rs.getBigDecimal(i)+"";
			        	}else{
			        		datavalue=rs.getString(rsmd.getColumnName(i));
			        	}
			        	if ((datavalue==null)||(datavalue=="0") || StringUtils.endsWithIgnoreCase(datavalue,"null"))
			        		datavalue="";
			        	
			        	
			        	//System.out.println(datavalue);
			        	lineStr=lineStr+" name=\"" +rsmd.getColumnName(i)+"\""+" type=\"String\"";
			        	lineStr="<data "+lineStr+">"+datavalue+"</data>\n";
			        	xml=xml+lineStr;
			        	}
			        xml=xml+"</row>\n";
			        j++;
		        }
			}
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		return xml ;
	}
	
	private String getMaster()
	{
		String xml="";
		String lineStr="";
		String datavalue="";
	
		try
		{
			ResultSetMetaData rsmd=rs.getMetaData();
			if(rsmd != null){
		        int count  = rsmd.getColumnCount();
		        int j=0;
		        if (rs.next())
		        {
		        	int i=1;
			        for(i=1;i<=count;i++){
			        	lineStr="";
			        	datavalue=rs.getString(rsmd.getColumnName(i));
			        	if ((datavalue==null)||(datavalue=="0"))
			        		datavalue="";
			        	lineStr=lineStr+" name=\"" +rsmd.getColumnName(i)+"\""+" type=\""+rsmd.getColumnTypeName(i)+"\"";
			        	lineStr="<data "+lineStr+">"+datavalue+"</data>";
			        	xml=xml+lineStr;
			        	}
		        }
		        
		        
			}
		}catch(Exception e)
		{
			xml="";
			e.printStackTrace();
		}finally
		{
		}
		return xml;
	}
	
}
