package com.gtis.plat.form;

import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.form.print.xmlutil.ResultSetXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.spring.Container;
import com.gtis.util.DataSourceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormXmlBuilder {

    private static final org.apache.commons.logging.Log log = LogFactory
            .getLog(FormXmlBuilder.class);

    @SuppressWarnings("unchecked")
    public static Document buildFormXml(FormInstance formInstance){
        FormSqlProcessor formSqlProcessor = (FormSqlProcessor) Container
                .getBean("FormSqlProcessor");
        Document docInstance = null;
        DataSource ds = BusinessDataSource.getDataSourceByBusiness(formInstance
                .getBusinessVo());
        String selectSql = formInstance.getFormDefineVo().getSelectCommand();
//        selectSql = FormSqlBuilder.replaceProIdSql(selectSql, formInstance
//                .getProId());

        Connection conn = null;
        ResultSet rs = null;
        Statement st = null;
        try {
//            selectSql =formSqlProcessor.processor(selectSql, formInstance
//                    .getProId());
            selectSql = formSqlProcessor.processor(selectSql, formInstance.getProId(), formInstance.getQueryParam());
            if (selectSql.trim().equals("") || selectSql.trim() == null) {
                log.error("!!!!SELECT语句为空!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            docInstance = getBlankXML(formInstance);
            conn = ds.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(selectSql);
            if (rs.next()) {
                //List lstNode = docInstance.selectNodes("//DataSet/Data/ElementData"); //wanghao 2009-06-18
                List lstNode = docInstance.selectNodes("//DataSet/ElementData");
                for (int i = 0; i < lstNode.size(); i++) {
                    Element elementData = (Element) lstNode.get(i);
                    if (!elementData.valueOf("@Id").equals("")) {
                        String value = getValue(rs, elementData
                                .valueOf("@Id"));
                        if (value != null)
                            elementData.setText(value);
                    }
                }
            }
            getGridForm(formInstance, docInstance, conn);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("表单查询SQL定义错误"
                    + formInstance.getFormDefineVo().getFormDefinitionId()
                    + "，请检查！" + selectSql, e);
        } finally {
            DataSourceManager.attemptClose(rs);
            DataSourceManager.attemptClose(st);
            DataSourceManager.attemptClose(conn);
        }
        AddHiddenData(docInstance, formInstance);
        return docInstance;
    }

    /**
     * 获取grid表数据
     * @param formInstance
     * @param docDefine
     * @param conn
     */
    public static void getGridForm(FormInstance formInstance, Document docDefine, Connection conn) {
        ResultSet rs = null;
        Statement st = null;
        try {
            //Element dataSet = (Element) docDefine.selectSingleNode("//DataSet/Data");//wanghao 2009-06-18
            Element dataSet = (Element) docDefine.selectSingleNode("//DataSet");
            st = conn.createStatement();
            List lstNode = docDefine.selectNodes("//Define/GroupDefine");
            for (int i = 0; i < lstNode.size(); i++) {
                Element groupDefine = (Element) lstNode.get(i);
                String groudId = groupDefine.valueOf("@Id");
                // String groudName = groupDefine.valueOf("@Name");
                String groudFkTable = groupDefine.valueOf("@FkTable");
                String groudPkField = groupDefine.valueOf("@PkField");
                String groudFkField = groupDefine.valueOf("@FkField");
                String orderByField = groupDefine.valueOf("@OrderField");
                if (StringUtils.isBlank(orderByField)){
                    orderByField= groudPkField;
                }
                String pkValue = FormInstanceFactory.getFormTablePKValue(formInstance, groudFkField, conn);

                List lstChildNodes = groupDefine.selectNodes("ElementDefine");
                Element groupData = dataSet.addElement("GroupData");
                groupData.addAttribute("Id", groudId);
                if (lstChildNodes.size() > 0) {
                    rs = st.executeQuery("select t.* from " + groudFkTable
                            + " t where " + groudFkField + "='" + pkValue
                            + "' order by " + orderByField);
                    int index = 0;
                    while (rs.next()) {
                        Element groupLineData = groupData
                                .addElement("LineData");
                        groupLineData.addAttribute("Index", String.valueOf(index));
                        groupLineData.addAttribute("Id", getValue(rs, groudPkField));
                        for (int j = 0; j < lstChildNodes.size(); j++) {
                            Element groupChildDefine = (Element) lstChildNodes
                                    .get(j);
                            String childId = groupChildDefine.valueOf("@Id");
                            String value = getValue(rs, GroupDefine.eraseGroupIdOfElementId(childId));
                            if (value == null) {
                                value = "";
                            }
                            Element groupLineElementData = groupLineData
                                    .addElement("ElementData");
                            groupLineElementData.addAttribute("Id", childId);
                            groupLineElementData.setText(value);

                        }
                        index++;
                    }
                }

                DataSourceManager.attemptClose(rs);
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            DataSourceManager.attemptClose(st);
        }
    }


    /**
     * 构造子表的打印数据
     *
     * @param formInstance
     * @param conn
     */
    public static String buildGridPrintXml(FormInstance formInstance, Connection conn) {

        ResultSet rs = null;
        Statement st = null;
        StringBuffer printXml = new StringBuffer();
        try {
            Document docDefine = formInstance.getFormDefineDoc();

            //System.out.println("子表>>>>>>>"+docDefine.asXML());

            //System.out.println(">>>>>>>>>>子表");

            st = conn.createStatement();

            List lstNode = docDefine.selectNodes("//Define/GroupDefine");
            for (int i = 0; i < lstNode.size(); i++) {
                Element groupDefine = (Element) lstNode.get(i);
                String groudId = groupDefine.valueOf("@Id");
                //String groudId = groupDefine.valueOf("@Name");
                String groudFkTable = groupDefine.valueOf("@FkTable");
                String groudPkField = groupDefine.valueOf("@PkField");
                String groudFkField = groupDefine.valueOf("@FkField");

                String pkValue = FormInstanceFactory.getFormTablePKValue(formInstance, groudFkField, conn);
                StringBuffer groupBuf = new StringBuffer();

                //System.out.println("&&&&&&&&&&&&&&&&&&&&&&groupId="+groudId);
                List lstChildNodes = groupDefine.selectNodes("ElementDefine");
                if (lstChildNodes.size() > 0) {
                    groupBuf.append("\n<detail ID=\"");
                    groupBuf.append(groudId);
                    groupBuf.append("\">\n");

                    rs = st.executeQuery("select t.* from " + groudFkTable
                            + " t where " + groudFkField + "='" + pkValue
                            + "' order by " + groudPkField);
                    ResultSetXml rsXml = new ResultSetXml(rs, ResultSetXml.DATA_TYPE_DETAIL);
                    String rowsXml = rsXml.getXMLData();
                    if (rowsXml.trim().length() == 0) {
                        //如果子表没有数据,则查找下一个子表
                        continue;
                    }
                    groupBuf.append(rowsXml);
                    groupBuf.append("</detail>\n");
                    printXml.append(groupBuf.toString());
                }
                DataSourceManager.attemptClose(rs);
            }
//			System.out.println("-------------"+printXml);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            DataSourceManager.attemptClose(st);
        }

        return printXml.toString();
    }

    public static void AddHiddenData(Document bDoc, FormInstance formInstance) {
        HashMap<String, Object> map = WorkFlowXmlUtil.getGobalValsByProId(formInstance.getProId());
        if (map != null && map.size() > 0) {
            Element root = bDoc.getRootElement();
            Element hiddenDataElement = root.addElement("HiddenData");
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                Element dataElement = hiddenDataElement.addElement("ElementData");
                dataElement.addAttribute("Id", key.toString());
                dataElement.setText(val.toString());
            }

        }
    }

    public static void AddHiddenData(Document bDoc, String name, String value) {
        Element root = bDoc.getRootElement();
        Node hiddenNode = root.selectSingleNode("//HiddenData");
        if (hiddenNode == null)
            hiddenNode = root.addElement("HiddenData");
        Element hiddenDataElement = (Element) hiddenNode;
        Element dataElement = hiddenDataElement.addElement("ElementData");
        dataElement.addAttribute("Id", name);
        dataElement.setText(value);

    }

    @SuppressWarnings("unchecked")
    public static Document getBlankXML(FormInstance formInstance) {
        Document bDoc = null;
        bDoc = DocumentHelper.createDocument();
        Element root = bDoc.addElement("DataSet");

        //Element rootData = root.addElement("Data");

        Element dataSetElement = formInstance.getFormDefineDoc()
                .getRootElement();

        // 加入样式单
        root.addAttribute("xmlns:xsi",
                "http://www.w3.org/2001/XMLSchema-instance");
        root.addAttribute("xsi:noNamespaceSchemaLocation",
                "http://www.oracle.com/DForms.xsd");


        //System.out.println("主表>>>>>>>>>"+dataSetElement.asXML());

        //System.out.println(">>>>>>>>>主表");
        // 加入属性
        for (int i = 0; i < dataSetElement.attributeCount(); i++) {
            root.addAttribute(dataSetElement.attribute(i).getName(),
                    dataSetElement.attribute(i).getText());
        }

        // 根据ElementDefine生成空白数据
        List lstDefine = dataSetElement
                .selectNodes("/DataSet/Define/ElementDefine");
        for (int i = 0; i < lstDefine.size(); i++) {
            Element defineElement = (Element) lstDefine.get(i);
            //Element dataElement = rootData.addElement("ElementData");
            Element dataElement = root.addElement("ElementData");
            dataElement.addAttribute("Id", defineElement.attributeValue("Id"));

            //2009-09-09 by wanghao
            dataElement.addAttribute("Name", defineElement.attributeValue("Name"));
            dataElement.addAttribute("Type", defineElement.attributeValue("Type"));
            dataElement.addAttribute("DataType", defineElement.attributeValue("DataType"));
            dataElement.addAttribute("DefaultValue", defineElement.attributeValue("DefaultValue"));
        }
        Node node = dataSetElement.selectSingleNode("/DataSet/Define");
        if (node != null)
            root.add((Element) node.clone());
        Node nodeConfig = dataSetElement.selectSingleNode("/DataSet/Config");
        if (nodeConfig != null)
            root.add((Element) nodeConfig.clone());
        return bDoc;
    }

    public static String getValue(ResultSet rs, String fieldName) {
        String result = null;
        try {
            int pos = rs.findColumn(fieldName);
            if (pos >= 0) {
                if (rs.getString(fieldName) != null) {
                    result = rs.getString(pos);
                    // result=result.replaceAll("\n", "&#13;&#10;");
                    if (rs.getMetaData().getColumnTypeName(pos).startsWith(
                            "DATE")) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        result = df.format(rs.getDate(pos));
                    } else if (rs.getMetaData().getColumnTypeName(pos)
                            .startsWith("NUMBER")) {
                        if (rs.getMetaData().getScale(pos) == 0)
                            result = String.valueOf(rs.getInt(pos));
                        else {
                            double value = rs.getDouble(pos);
                            // String zero="";
                            // for(int
                            // i=0;i<rs.getMetaData().getScale(pos);i++){
                            // zero+="0";
                            // }
                            DecimalFormat fnum = new DecimalFormat("##0.0");
                            // String dd=fnum.format(value);
                            // fnum.setMaximumFractionDigits(rs.getMetaData().getScale(pos));
                            fnum.setMinimumFractionDigits(rs.getMetaData()
                                    .getScale(pos));
                            // BigDecimal bigDec=new BigDecimal(value);
                            // bigDec.setScale(rs.getMetaData().getScale(pos),BigDecimal.ROUND_HALF_UP);
                            // result = rs.getString(pos);
                            result = fnum.format(value);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.info("--读取表单出错，字段" + fieldName + "不存在！");
        }
        // if (result.equals("")) result="tt";
        return result;
    }


}
