package com.gtis.plat.datasource;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.LogFactory;
import com.gtis.spring.Container;
public class DataSourceManager {
	private static final org.apache.commons.logging.Log log = LogFactory
			.getLog(DataSourceManager.class);

	public static DataSource getDataSource() throws Exception {
		return getDataSource("egov");
	}

	//
	// /**
	// * 获取单元测试用数据源，根据数据源名称获取
	// *
	// * @param alias
	// * @return
	// * @throws SQLException
	// */
	public static DataSource getDataSource(String alias) throws Exception {
		return (DataSource) Container.getBean(alias);
	}

	public static void attemptClose(Connection conn) {
		try {
			if (conn != null)
				conn.close();
		} catch (SQLException e) {
			log.error("closeConnection error, " + e.getMessage());
		}
	}

	public static synchronized void attemptClose(ResultSet o) {
		try {
			if (o != null)
				o.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static synchronized void attemptClose(Statement o) {
		try {
			if (o != null)
				o.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static synchronized void attemptClose(PreparedStatement o) {
		try {
			if (o != null)
				o.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
