package com.gtis.plat.dao;

import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.PfWorkFlowPostVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SysWorkFlowPostDao extends SqlMapClientDaoSupport {
	private static final Log log = LogFactory.getLog(SysWorkFlowPostDao.class);

	public void updatePost(PfWorkFlowPostVo workFlowPostVo) {
		super.getSqlMapClientTemplate().update("updatePost",
                workFlowPostVo);
	}

	public PfWorkFlowPostVo getPost(String postId) {
		return (PfWorkFlowPostVo) super.getSqlMapClientTemplate()
				.queryForObject("getPost", postId);
	}
	
	public List<PfWorkFlowPostVo> getPostByTask(String taskId) {
		return (List<PfWorkFlowPostVo>) super.getSqlMapClientTemplate()
				.queryForList("getPostByTask", taskId);
	}

    public List<PfWorkFlowPostVo> getPostByInstance(String instanceId) {
        return (List<PfWorkFlowPostVo>) super.getSqlMapClientTemplate()
                .queryForList("getPostByInstance", instanceId);
    }

    public void createPost(PfWorkFlowPostVo workFlowPostVo) {
        super.getSqlMapClientTemplate().insert("insertPost",
                workFlowPostVo);
    }
}
