package com.gtis.plat.dao;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.impl.SysSmsServiceImpl;
import com.gtis.plat.service.impl.SysUserServiceImpl;
import com.gtis.plat.vo.PfMessageAcceptAwokeVo;
import com.gtis.plat.vo.PfMessageAcceptVo;
import com.gtis.plat.vo.PfMessageSendAwokeVo;
import com.gtis.plat.vo.PfSmsVo;
import com.gtis.plat.vo.PfUserVo;
//import com.gtis.plat.vo.PfMessageFileVo;
import com.gtis.plat.vo.PfMessageSendVo;
import com.gtis.spring.Container;
import com.gtis.util.WebFormatter;

public class SysMessageDAO extends SqlMapClientDaoSupport {

	// ------------------------消息接受人状态------------------//
	// 未查看
	public static final int MESSAGEACCEPT_STATUS1 = 1;
	// 已查看
	public static final int MESSAGEACCEPT_STATUS2 = 2;

	// ----------------------------------------------------------//

	// 获取接收消息信息
	public PfMessageAcceptVo getAcceptMessage(String acceptMessageId) {
		return (PfMessageAcceptVo) super.getSqlMapClientTemplate()
				.queryForObject("queryacceptmsg", acceptMessageId);
	}
	// 获取接收通知息信息
	public PfMessageAcceptAwokeVo getAcceptMsgAwoke(String acceptMessageId) {
		return (PfMessageAcceptAwokeVo) super.getSqlMapClientTemplate()
				.queryForObject("queryacceptmsgawoke", acceptMessageId);
	}

	// 获取发送消息信息
	public PfMessageSendVo getSendMessage(String sendMessageId) {
		return (PfMessageSendVo) super.getSqlMapClientTemplate()
				.queryForObject("querysendmsg", sendMessageId);
	}
	
	//获取发送通知信息
	public PfMessageSendAwokeVo getSendMsgAwokeById(String sendMsgAwokeId) {
		return (PfMessageSendAwokeVo) super.getSqlMapClientTemplate()
				.queryForObject("querysendmsgawoke", sendMsgAwokeId);
	}
	
	// 消息状态更新
	public void updateMessageStatus(String acceptMessageId) {
		super.getSqlMapClientTemplate().update("updatemsgstatus", acceptMessageId);
	}
	
	//通知状态更新
	public void updateNotifyStatus(String acceptMessageId) {
		super.getSqlMapClientTemplate().update("updatenotifystatus", acceptMessageId);
	}
	
	// 获取消息列表
	@SuppressWarnings("unchecked")
	public List<String> getMessageList(HashMap<String, String> map) {
		return super.getSqlMapClientTemplate().queryForList("querymessagelist",
				map);
	}
	
	//获取未查看的消息个数
	@SuppressWarnings("unchecked")
	public String getPopMessage(String acceptUserId){
		return (String)super.getSqlMapClientTemplate().queryForObject("selectnoreadmsgcount", acceptUserId);
	}
	
	//获取未读的通知数量
	public String getPopNotify(String acceptUserId){
		return (String)super.getSqlMapClientTemplate().queryForObject("selectnoreadnotifycount", acceptUserId);
	}
	
	//获取信息是否被查看
	public String getReadedMessageCount(String msgSendId){
		return (String)super.getSqlMapClientTemplate().queryForObject("selectreadmsgcount", msgSendId);
	}
	//获取通知是否被查看
	public String getReadedAwokeCount(String awokeId){
		return (String)super.getSqlMapClientTemplate().queryForObject("selectreadAwokecount", awokeId);
	}
	/**
	 * 发送消息
	 * 
	 * @param pfMessageSendVo
	 * @return
	 */
	public boolean insertMessage(PfMessageSendVo pfMessageSendVo) {
		boolean isok = true;
		List<String> userIdList;
		try {
			
			java.text.DateFormat df = new java.text.SimpleDateFormat(
					"yyyy-MM-dd HH:mm:ss"); // 这里格式化
			String datestr = df.format(new java.util.Date());
			java.sql.Timestamp orldate = Timestamp.valueOf(datestr);
			pfMessageSendVo.setMessageSendDate(orldate);
			super.getSqlMapClientTemplate().insert("insertsendmessage",
					pfMessageSendVo);

			// 接收人批量更新
			if (pfMessageSendVo.getMessageAcceptUser().length() > 0) {
				if(pfMessageSendVo.getMessageAcceptUser().equals("1")){
					userIdList=this.getAllUserId();
					for(int i=0;i<userIdList.size();i++){
						PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
						pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
						pfMessageAcceptVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
						pfMessageAcceptVo.setUserId(userIdList.get(i));
						pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
						super.getSqlMapClientTemplate().insert("insertacceptmessage", pfMessageAcceptVo);
					}
				}else if(pfMessageSendVo.getMessageAcceptUser().equals("2")){
                    userIdList=this.getUserIdWhereBJJG("BJJG");
                    for(int i=0;i<userIdList.size();i++){
                        PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
                        pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
                        pfMessageAcceptVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
                        pfMessageAcceptVo.setUserId(userIdList.get(i));
                        pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
                        super.getSqlMapClientTemplate().insert("insertacceptmessage", pfMessageAcceptVo);
                    }
                }else if(pfMessageSendVo.getMessageAcceptUser().equals("3")){
					userIdList=this.getUserIdByRegionCodeLength(9);
					if(userIdList!=null){
						for(int i=0;i<userIdList.size();i++){
							PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
							pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
							pfMessageAcceptVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
							pfMessageAcceptVo.setUserId(userIdList.get(i));
							pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
							super.getSqlMapClientTemplate().insert("insertacceptmessage", pfMessageAcceptVo);
						}
					}
				}else{
					StringTokenizer  st = new StringTokenizer(pfMessageSendVo.getMessageAcceptUser(),",");
					while (st.hasMoreTokens()){
						PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
						pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
						pfMessageAcceptVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
						pfMessageAcceptVo.setUserId(st.nextToken());
						pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
						super.getSqlMapClientTemplate().insert("insertacceptmessage", pfMessageAcceptVo);
					}
				}
				
			}
		} catch (Exception e) {
			e.printStackTrace();
			isok = false;
		}
		return isok;
	}
	/**
	 * 发送消息
	 * 
	 * @param pfMessageSendAwokeVo
	 * @return
	 */
	public boolean insertMsgAwoke(PfMessageSendAwokeVo pfMessageSendAwokeVo) {
		boolean isok = true;
		List<String> userIdList;
		PfSmsVo pfSmsVo = new PfSmsVo();
		PfUserVo pfUserVo=new PfUserVo();
		SysSmsServiceImpl smsServiceImpl=(SysSmsServiceImpl) Container.getBean("SysSmsServiceImpl");
		SysUserServiceImpl userService=(SysUserServiceImpl)Container.getBean("SysUserServiceImpl");
		try {
			
			java.text.DateFormat df = new java.text.SimpleDateFormat(
					"yyyy-MM-dd HH:mm:ss"); // 这里格式化
			String datestr = df.format(new java.util.Date());
			java.sql.Timestamp orldate = Timestamp.valueOf(datestr);
			pfMessageSendAwokeVo.setMessageAwokeDate(orldate);
			super.getSqlMapClientTemplate().insert("insertsendmsgawoke",
					pfMessageSendAwokeVo);

			
			// 接收人批量更新
			if (pfMessageSendAwokeVo.getMessageAcceptUser().length() > 0) {
				if(pfMessageSendAwokeVo.getMessageAcceptUser().equals("1")){
					userIdList=this.getAllUserId();
					for(int i=0;i<userIdList.size();i++){
						PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
						pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
						pfMessageAcceptAwokeVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
						pfMessageAcceptAwokeVo.setUserId(userIdList.get(i));
						pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
						super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", pfMessageAcceptAwokeVo);
					}					
				}else if(pfMessageSendAwokeVo.getMessageAcceptUser().equals("1,2")){					 
					 userIdList=this.getAllUserId();	
					 for(int i=0;i<userIdList.size();i++){
						PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
						pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
						pfMessageAcceptAwokeVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
						pfMessageAcceptAwokeVo.setUserId(userIdList.get(i));
						pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
						super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", pfMessageAcceptAwokeVo);
					}
					 for(int i=0;i<userIdList.size();i++){
						pfUserVo=userService.getUserVo(userIdList.get(i));
						if(!(pfUserVo.getMobilePhone()==null)||!(pfUserVo.getMobilePhone().equals(""))){
							pfSmsVo.setMobileNo(pfUserVo.getMobilePhone().trim());
							pfSmsVo.setContent(WebFormatter.html2text(pfMessageSendAwokeVo.getMessageAwokeContent()));
							pfSmsVo.setSender(pfMessageSendAwokeVo.getUserName());
							smsServiceImpl.sendMsg(pfSmsVo);
						}
					 }
				}else{
					String userIdStr="";
					if(pfMessageSendAwokeVo.getMessageAcceptUser().endsWith(",2")){
						userIdStr=pfMessageSendAwokeVo.getMessageAcceptUser().substring(0, pfMessageSendAwokeVo.getMessageAcceptUser().length()-2);
						StringTokenizer  st = new StringTokenizer(userIdStr,",");
						while (st.hasMoreTokens()){
							String userId=st.nextToken();
							pfUserVo=userService.getUserVo(userId);
							if(!(pfUserVo.getMobilePhone()==null)||!(pfUserVo.getMobilePhone().equals(""))){
								pfSmsVo.setMobileNo(pfUserVo.getMobilePhone().trim());
								pfSmsVo.setContent(WebFormatter.html2text(pfMessageSendAwokeVo.getMessageAwokeContent()));
								pfSmsVo.setSender(pfMessageSendAwokeVo.getUserName());
								smsServiceImpl.sendMsg(pfSmsVo);
							}
							PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
							pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
							pfMessageAcceptAwokeVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
							pfMessageAcceptAwokeVo.setUserId(userId);
							pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
							super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", pfMessageAcceptAwokeVo);
						}
					}else{
						userIdStr=pfMessageSendAwokeVo.getMessageAcceptUser();
						StringTokenizer  st = new StringTokenizer(userIdStr,",");
						while (st.hasMoreTokens()){
							PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
							pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
							pfMessageAcceptAwokeVo.setMessageAcceptStadus(MESSAGEACCEPT_STATUS1);
							pfMessageAcceptAwokeVo.setUserId(st.nextToken());
							pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
							super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", pfMessageAcceptAwokeVo);
						}
					}	
				}				
			}
		} catch (Exception e) {
			e.printStackTrace();
			isok = false;
		}
		return isok;
	}
	
	//消息删除
	  public void delSendMsgById(String messageSendId) {
	    super.getSqlMapClientTemplate().delete("delAcceptMsgBySendId", messageSendId);
	    super.getSqlMapClientTemplate().delete("delSendMsg", messageSendId);
	  }

	  public void delAcceptMsgById(String messageAcceptId) {
	    super.getSqlMapClientTemplate().delete("delAcceptMsg", messageAcceptId);
	  }
	  
	 //通知删除
	  public void delSendAwokeById(String AwokeSendId) {
	    super.getSqlMapClientTemplate().delete("delAcceptAwokeBySendId", AwokeSendId);
	    super.getSqlMapClientTemplate().delete("delSendMsg", AwokeSendId);
	  }

	  public void delAcceptAwokeById(String AwokeAcceptId) {
	    super.getSqlMapClientTemplate().delete("delAcceptAwoke", AwokeAcceptId);
	  }
	  //获取全局用户id
	public List<String> getAllUserId(){
	     return (List<String>)super.getSqlMapClientTemplate().queryForList("getAllUserId");
	}
	//获取接收消息列表RSS
	public List<PfMessageAcceptVo> getAcceptMsgListRss(Map<String, String> map){
		return (List<PfMessageAcceptVo>)super.getSqlMapClientTemplate().queryForList("queryacceptmsglistRss", map);
	}
	
	public List<PfMessageAcceptAwokeVo> getAcceptNotifyListRss(Map<String, String> map){
		return (List<PfMessageAcceptAwokeVo>)super.getSqlMapClientTemplate().queryForList("queryacceptnotifylistRss", map);
	}

    //获取发送通知信息
	public List<PfMessageSendAwokeVo> getSendMsgAwokeByTitle(String sendMsgTitle) {
		return (List<PfMessageSendAwokeVo>) super.getSqlMapClientTemplate()
				.queryForObject("getSendMsgAwokeByTitle", sendMsgTitle);
	}

    //获取本局机关人员的id
    public List<String> getUserIdWhereBJJG(String remark){
        return (List<String>)super.getSqlMapClientTemplate().queryForList("getUserIdWhereBJJG", remark);
    }

	/**
	 * 根据部门代码长度，获取用户
	 * @param length 部门代码长度
	 * @return
	 */
	public List<String> getUserIdByRegionCodeLength(Integer length){
		return (List<String>)super.getSqlMapClientTemplate().queryForObject("getUserIdByRegionCodeLength",length);
	}
}
