package com.gtis.plat.dao;

import com.gtis.plat.vo.PfMenuVo;
import com.gtis.plat.vo.PfResourceVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

public class SysMenuDao extends SqlMapClientDaoSupport {
    /**
     * 根据角色获取系统菜单
     *
     * @param roles
     * @return
     */
    @Cacheable(value="MenuCache",key="#roles+'MenuListByRoles'")
    public List<PfMenuVo> getMenuListByRoles(String roles) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        return super.getSqlMapClientTemplate().queryForList("getMenuListByRoles", mapParam);
    }

    /**
     * 根据角色获取系统菜单
     *
     * @param roles
     * @return
     */
    @Cacheable(value="MenuCache",key="#roles+'SysMenuListByRoles'")
    public List<PfMenuVo> getSysMenuByRoles(String roles) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        return super.getSqlMapClientTemplate().queryForList("getSysMenuByRoles", mapParam);
    }

    /**
     * 根据角色获取系统根菜单
     *
     * @param roles
     * @return
     */
    @Cacheable(value="MenuCache",key="#roles+#leaves+'RootMenuListByRoles'")
    public List<PfMenuVo> getRootMenuListByRoles(String roles, boolean leaves) {
        HashMap mapParam = new HashMap();
        mapParam.put("roles", roles);
        mapParam.put("leaves", leaves);
        return super.getSqlMapClientTemplate().queryForList("getRootMenuListByRoles", mapParam);
    }

    /**
     * 根据角色获取子菜单
     *
     * @param roles
     * @return
     */
    @Cacheable(value="MenuCache",key="#roles+#menuParentId+'RootMenuChildsByRoles'")
    public List<PfMenuVo> getRootMenuChildsByRoles(String roles, String menuParentId) {
        HashMap mapParam = new HashMap();
        mapParam.put("roles", roles);
        if (menuParentId != null) {
            mapParam.put("menuParentId", menuParentId);
        } else {
            mapParam.put("menuParentId", "1");
        }
        return super.getSqlMapClientTemplate().queryForList("getRootMenuChildsByRoles", mapParam);
    }

    /**
     * 根据资源编号获取资源
     *
     * @param rid
     * @return
     */
    public PfResourceVo getResource(String rid) {
        return (PfResourceVo) super.getSqlMapClientTemplate().queryForObject("getResource", rid);
    }

    public PfResourceVo getResourceByCode(String code) {
        return (PfResourceVo) super.getSqlMapClientTemplate().queryForObject("getResourceByCode", code);
    }

    /**
     * 获取项目列表的菜单
     *
     * @param roles
     * @param wdid
     * @return
     */
    public List<PfResourceVo> getProjectMenu(String roles, String wdid) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        mapParam.put("wdid", wdid);
        return (List<PfResourceVo>) super.getSqlMapClientTemplate().queryForList("getProjectMenu", mapParam);
    }

    public List<String> getProjectWorkFlowDefineIds(String roles) {
        if (StringUtils.isNotBlank(roles))
            return super.getSqlMapClientTemplate().queryForList("getProjectWorkFlowDefineIds", roles);
        else
            return null;
    }

    public List<String> getWorkFlowDefineRoleIds(String workflowDefinitionId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("workflowDefinitionId", workflowDefinitionId);
        return super.getSqlMapClientTemplate().queryForList("getWorkFlowDefineRoleIds", mapParam);
    }
}
