package com.gtis.plat.dao;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.PFDynamicSignVo;
import com.gtis.plat.vo.PfUserSignVo;
import java.util.Calendar;


public class SysDynamicSignDao extends SqlMapClientDaoSupport {

	public List<PFDynamicSignVo> getDynamicSign(HashMap<String,String> paraMap){
		return   super.getSqlMapClientTemplate().queryForList("getDynamicSign", paraMap);
	}
	
	public List<PfUserSignVo> getUserSignBySignKey(HashMap<String,String> paraMap){
		return   super.getSqlMapClientTemplate().queryForList("getUserSignBySignKey", paraMap);
	}
	
	public void  saveDynamicSign(PFDynamicSignVo dynamicSignVo){
		super.getSqlMapClientTemplate().insert("saveDynamicSign", dynamicSignVo);
	}
	
	public void updateDynamicSign(PFDynamicSignVo dynamicSignVo){
		super.getSqlMapClientTemplate().update("updateDynamicSign", dynamicSignVo);
	}
	
	/**
	 * 通过signKey和proId在userSign表里查询对应的签名信息
	 * @param paraMap
	 * @return
	 */
	public List<PfUserSignVo> getUserSign(HashMap<String,String> paraMap){
		return super.getSqlMapClientTemplate().queryForList("getUserSign", paraMap);
	}
	
	public void deleteUserSignByProId(String proId) {
		super.getSqlMapClientTemplate().delete("deleteUserSignByProId",proId);
	}
	
	public void deleteUserSignBySignIds(List<String> signIds){
		super.getSqlMapClientTemplate().delete("deleteUserSignBySignIds",signIds);
	}
}
