package com.gtis.plat.aop;

import com.gtis.plat.vo.PfNewsVo;
import com.gtis.util.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;

import javax.jms.Destination;
import java.lang.reflect.Method;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-6-8
 */
public class NewsJmsAdvice implements AfterReturningAdvice {

    private static final Logger logger = LoggerFactory.getLogger(NewsJmsAdvice.class);

    private JmsTemplate jmsTemplate;

    private Destination destination;

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        if (args[0] instanceof PfNewsVo) {
            final PfNewsVo news = (PfNewsVo) args[0];
            ThreadPool.execute(new Runnable() {
                public void run() {
                    try {
                        jmsTemplate.convertAndSend(destination, news);
                    } catch (JmsException e) {
                        logger.error("send jms message error:[{}]", e.getMessage());
                    }
                }
            });
        }
    }
}
