package com.gtis.web.print;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.dao.*;
import com.gtis.plat.form.print.XMLBuildHelper;
import com.gtis.plat.vo.*;
import com.gtis.util.*;

/**
 * @文件名 SjdPrintImpl.java
 * @作者 陈东
 * @创建日期 Sep 3, 2012
 * @创建时间 6:59:18 PM 
 * @版本号 V 1.0
 */
public class SjdPrintImpl extends XMLBuildHelper{
	private Logger logger = Logger.getLogger(this.getClass().getName());
	private BaseDao sjdDaoImpl;
	SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy年MM月dd日");
	public String getPrintDetailXml(Map map, HttpServletRequest request) {
		return null;
	}
    //获得需要打印的数据
	public String getPrintXml(Map map, HttpServletRequest request) {
		StringBuilder xml = new StringBuilder();
		String proid=map.get("proid") + "";
		String sjdid=map.get("sjdid") + "";
		SjdVo sjdVo = new SjdVo();
		List<SjdclVo> dataList = new ArrayList<SjdclVo>();
		if (StringUtils.isNotBlank(sjdid)) {
			sjdVo=sjdDaoImpl.getObject(sjdid);
			if (sjdVo == null) {
				sjdVo = new SjdVo();
				sjdVo.setProid(proid);
				sjdVo.setSjdid(sjdid);
			}
		}
		xml.append(super.voToXml(sjdVo));
		xml.append("</datas>");
		
		dataList = getSjdclListBySjdid(sjdVo);
		if(dataList==null||dataList.size()==0){
			dataList =new ArrayList<SjdclVo>();
			SjdclVo tempVo = new SjdclVo();
			dataList.add(tempVo);
		}
		//记录总数
		xml.append("<detail ID=\"SJDCL\">");
		xml.append(super.voListToXml(dataList));
		String res=xml.toString();
		return res;
	}
	//循环输出资料信息list数据
	private StringBuilder getZdbcbaXZQcz(List<SjdclVo> dataList){
		StringBuilder xml = new StringBuilder();
		for(int i=0;i<dataList.size();i++){
			SjdclVo tempVo=dataList.get(i);
			xml.append("<data name=\"" + "XH" + i + "\"" + " type=\"String\">");
			if (tempVo.getXh()!=null) {
				xml.append((tempVo.getXh()).toString());
			}
			xml.append("</data>");
		}
		return xml;
	}
	public SimpleDateFormat getDateFormat() {
		return dateFormat;
	}
	public void setDateFormat(SimpleDateFormat dateFormat) {
		this.dateFormat = dateFormat;
	}
	/**
	 * 获取收件单材料list
	 * @param sjdid
	 * @return
	 */
	private List<SjdclVo> getSjdclListBySjdid(SjdVo vo){
		List<SjdclVo> clList = new ArrayList<SjdclVo>();
		try {
			if (vo != null && vo.getSjd_cl() != null) {
				List<HashMap> tempList = (List<HashMap>)JSONUtil.deserialize(new String(vo.getSjd_cl()));
				for (int i = 0; i < tempList.size(); i++) {
					HashMap map = tempList.get(i);
					SjdclVo clVo = new SjdclVo();
					if (map.get("data_id") != null) {
						clVo.setData_id(map.get("data_id").toString());
					}
					if (map.get("bz") != null) {
						clVo.setBz(map.get("bz").toString());
					}
					
					if (map.get("jjr") != null) {
						clVo.setJjr(map.get("jjr").toString());
					}
					if (map.get("lxdh") != null) {
						clVo.setLxdh(map.get("lxdh").toString());
					}
					if (map.get("name") != null) {
						clVo.setName(map.get("name").toString());
					}
					
					if (map.get("xh") != null) {
						long value = (Long)map.get("xh");
						clVo.setXh((int)value);
					}
					if (map.get("node_id") != null) {
						long value = (Long)map.get("node_id");
						clVo.setNode_id((int)value);
					}
					if (map.get("num") != null) {
						long value = (Long)map.get("num");
						clVo.setNum((int)value);
					}
					if (map.get("ysnum") != null) {
						long value = (Long)map.get("ysnum");
						clVo.setYsnum((int)value);
					}else {
						clVo.setYsnum(clVo.getNum());
					}
					if (map.get("dbnum") != null) {
						long value = (Long)map.get("dbnum");
						clVo.setDbnum((int)value);
					}
					
					if (map.get("proid") != null) {
						clVo.setProid(map.get("proid").toString());
					}
					if (map.get("sj_date") != null) {
						clVo.setSj_date(CommonUtil.formateDateToStr(map.get("sj_date").toString()));
					}
					if (map.get("sjdid") != null) {
						clVo.setSjdid(map.get("sjdid").toString());
					}
					if (map.get("sjr") != null) {
						clVo.setSjr(map.get("sjr").toString());
					}
					if (map.get("type") != null) {
						clVo.setType(map.get("type").toString());
					}
					if (map.get("user_id") != null) {
						clVo.setUser_id(map.get("user_id").toString());
					}
					clList.add(clVo);
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return clList;
	}
}
