package com.gtis.web.old;

import java.sql.*;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import javax.sql.DataSource;
import org.dom4j.Document;
import org.dom4j.Element;

import com.gtis.util.DataSourceManager;
import com.gtis.web.old.core.GroupDefine;

public class FormInstance4DataBase {
	private DataSource ds = null;
	private String tableName = ""; // 表名
	private String tblKeyField = ""; // 主键
	private String tblKeyValue = ""; // 主键值
	private boolean isSave = false;

	public boolean isSave() {
		return isSave;
	}

	public void setSave(boolean isSave) {
		this.isSave = isSave;
	}

	public FormInstance4DataBase(String dsName, String tblName,
			String tblkeyField, String keyValue) {
		this.tableName = tblName;
		this.tblKeyField = tblkeyField;
		this.tblKeyValue = keyValue;
		setDsName(dsName);
	}

	public FormInstance4DataBase(FormInstance iForm) {
		this.tableName = iForm.getTblName();
		this.tblKeyField = iForm.getTblkeyField();
		this.tblKeyValue = iForm.getTblkeyValue();
		setDsName(iForm.getDsName());
	}

	public void setDsName(String dsName) {
		try {
			if (dsName.equals(""))
				this.ds = DataSourceManager.getDataSource();
			else
				this.ds = DataSourceManager.getDataSource(dsName);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public Document getDocumentFromDataBase(FormDefintion formDefine) {
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		Document docDefine = formDefine.getBlackXML();
		try {
			con = ds.getConnection();
			st = con.createStatement();
			rs = st.executeQuery("select t.* from " + tableName + " t where "
					+ tblKeyField + "='" + tblKeyValue + "'");
			if (rs.next()) {
				List lstNode = docDefine.selectNodes("//DataSet/ElementData");
				for (int i = 0; i < lstNode.size(); i++) {
					Element elementData = (Element) lstNode.get(i);
					if (!elementData.valueOf("@Id").equals("")) {
						elementData.setText(getValue(rs, elementData
								.valueOf("@Id")));
					}
				}
				isSave = true;
			}
			getChildDocumentFromDataBase(formDefine, docDefine);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return docDefine;
	}

	// 获取子表
	public void getChildDocumentFromDataBase(FormDefintion formDefine,
			Document docDefine) {
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		Document docXmlDefine = formDefine.getXMLDocument();
		try {
			Element dataSet = (Element) docDefine.selectSingleNode("//DataSet");
			con = ds.getConnection();
			st = con.createStatement();
			List lstNode = docXmlDefine.selectNodes("//Define/GroupDefine");
			for (int i = 0; i < lstNode.size(); i++) {
				Element groupDefine = (Element) lstNode.get(i);
				String groudId = groupDefine.valueOf("@Id");
				// String groudName = groupDefine.valueOf("@Name");
				String groudFkTable = groupDefine.valueOf("@FkTable");
				String groudPkField = groupDefine.valueOf("@PkField");
				String groudFkField = groupDefine.valueOf("@FkField");
				List lstChildNodes = groupDefine.selectNodes("ElementDefine");
				Element groupData = dataSet.addElement("GroupData");
				groupData.addAttribute("Id", groudId);
				if (lstChildNodes.size() > 0) {
					rs = st.executeQuery("select t.* from " + groudFkTable
							+ " t where " + groudFkField + "='" + tblKeyValue
							+ "' order by " + groudPkField);
					int index = 0;
					while (rs.next()) {
						Element groupLineData = groupData
								.addElement("LineData");
						groupLineData.addAttribute("Index", String
								.valueOf(index));
						groupLineData.addAttribute("Id", getValue(rs,
								groudPkField));
						for (int j = 0; j < lstChildNodes.size(); j++) {
							Element groupChildDefine = (Element) lstChildNodes
									.get(j);
							String childId = groupChildDefine.valueOf("@Id");
							String value = getValue(rs, childId);
							Element groupLineElementData = groupLineData
									.addElement("ElementData");
							groupLineElementData.addAttribute("Id", childId);
							groupLineElementData.setText(value);

						}
						index++;
					}
				}
				DataSourceManager.attemptClose(rs);
			}

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
	}

	private List getElementList(String ElementIds) {
		List lstElement = new ArrayList<String>();
		if (!ElementIds.equalsIgnoreCase("")
				&& !ElementIds.equalsIgnoreCase("all_disabled")) {
			String[] str = ElementIds.split(",");
			for (int i = 0; i < str.length; i++) {
				if (!str[i].trim().equals(""))
					lstElement.add(str[i].trim());
			}
		}
		return lstElement;
	}

	private boolean inElementList(List lstElement, String eleId) {
		for (int i = 0; i < lstElement.size(); i++) {
			if (lstElement.get(i).toString().equalsIgnoreCase(eleId))
				return true;
		}
		return false;
	}

	public boolean saveFormToDataBase(FormInstance iForm, String elementIds) {
		StringBuffer sql = new StringBuffer();
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		// Document doc = null;
		Document docDefine = iForm.getSaveDocument();
		List lstElement = getElementList(elementIds);
		try {
			// List lstNode = docDefine.selectNodes("//DataSet/ElementData");
			con = ds.getConnection();
			st = con.createStatement();
			rs = st.executeQuery("select t.* from " + tableName + " t where "
					+ tblKeyField + "='" + tblKeyValue + "'");
			if (rs.next()) {
				sql.append("update " + tableName + " set ");
				for (int i = 0; i < lstElement.size(); i++) {
					Element elementData = (Element) docDefine
							.selectSingleNode("//DataSet/ElementData[@Id='"
									+ lstElement.get(i).toString() + "']");
					if (elementData == null)
						continue;
					// Element elementData = (Element) lstNode.get(i);
					// if (!elementData.valueOf("@Id").equals("")) {
					sql.append(getUpdateString(rs, elementData.valueOf("@Id"),
							elementData.getText()));
					// }
				}
				if (lstElement.size() > 0)
					sql.append(tblKeyField + "='" + tblKeyValue + "' where "
							+ tblKeyField + "='" + tblKeyValue + "'");
			} else {
				sql.append("insert into " + tableName + "(");
				StringBuffer valuesBuffer = new StringBuffer();
				for (int i = 0; i < lstElement.size(); i++) {
					Element elementData = (Element) docDefine
							.selectSingleNode("//DataSet/ElementData[@Id='"
									+ lstElement.get(i).toString() + "']");
					if (elementData == null)
						continue;
					// Element elementData = (Element) lstNode.get(i);
					if (!elementData.valueOf("@Id").equals("")
							&& !elementData.getText().trim().equals("")) {
						int fieldPos = getFieldValue(rs, elementData
								.valueOf("@Id"), elementData.getText());
						if (fieldPos > 0) {
							sql.append(elementData.valueOf("@Id") + ",");
							valuesBuffer.append(getFieldValue(rs, fieldPos,
									elementData.getText())
									+ ",");
						}
					}
				}
				sql.append(tblKeyField + ") values (");
				sql.append(valuesBuffer);
				sql.append("'" + tblKeyValue + "')");
			}
			DataSourceManager.attemptClose(st);
			if (lstElement.size() > 0) {
				st = con.createStatement();
				st.executeUpdate(sql.toString());
				saveChildGrid(iForm, elementIds);
			}
			return true;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return false;
	}

	private boolean saveChildGrid(FormInstance iForm, String elementIds) {
		Connection con = null;
		Statement st = null;
		try {
			con = ds.getConnection();
			Document docInstance = iForm.getSaveDocument();
			Document docDefine = iForm.getFormDefineObj().getXMLDocument();
			List lstNode = docInstance.selectNodes("//DataSet/GroupData");
			for (int i = 0; i < lstNode.size(); i++) {

				Element elementData = (Element) lstNode.get(i);
				String groupId = elementData.valueOf("@Id");
				List lstLineNode = elementData.selectNodes("LineData");
				Element groudDefineElement = (Element) docDefine
						.selectSingleNode("//GroupDefine[@Id='" + groupId
								+ "']");
				GroupDefine defineobj = new GroupDefine(groudDefineElement);
				for (int j = 0; j < lstLineNode.size(); j++) {
					HashMap elementsMap = new HashMap();
					Element elementLineData = (Element) lstLineNode.get(j);
					String lineId = elementLineData.valueOf("@Id");
					// pstmt = con.prepareStatement(sql);
					elementsMap.put("Id", lineId);

					List lstLineElement = elementLineData
							.selectNodes("ElementData");
					for (int k = 0; k < lstLineElement.size(); k++) {
						Element elementLineElement = (Element) lstLineElement
								.get(k);
						elementsMap.put(elementLineElement.valueOf("@Id"),
								elementLineElement.getText());
					}
					String sql = defineobj.getUpdateSql(elementsMap, iForm
							.getTblkeyValue());
					if (!sql.equals("")) {
						st = con.createStatement();
						st.executeUpdate(sql);
						DataSourceManager.attemptClose(st);
					}
				}
				st = con.createStatement();
				st
						.executeUpdate(defineobj.getDeleteSql(iForm
								.getTblkeyValue()));
				DataSourceManager.attemptClose(st);
			}

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return false;
	}

	private String getUpdateString(ResultSet rs, String fieldName, String value)
			throws Exception {
		int pos = -1;
		try {
			pos = rs.findColumn(fieldName);
			if (pos >= 0) {
				if (rs.getString(pos) == null
						|| rs.getString(pos).trim().equals("")) {
					if (!value.trim().equals(""))
						return fieldName + "=" + getFieldValue(rs, pos, value)
								+ ",";
				} else {
					// if (value.trim().equals("")){
					return fieldName + "=" + getFieldValue(rs, pos, value)
							+ ",";
					// }
				}
			}
		} catch (Exception e) {
			System.out.println("表单更新列" + fieldName + "不存在！");
		}
		return "";
	}

	private int getFieldValue(ResultSet rs, String fieldName, String value) {
		int pos = -1;
		try {
			pos = rs.findColumn(fieldName);
		} catch (Exception e) {
			System.out.println("表单插入列" + fieldName + "不存在！");
		}
		return pos;
	}

	private String getFieldValue(ResultSet rs, int fieldPos, String value)
			throws Exception {
		String result = "";
		value = value.replaceAll("'", "''");
		if (fieldPos > 0) {
			// System.out.println(rs.getMetaData().getColumnTypeName(fieldPos));
			if (rs.getMetaData().getColumnTypeName(fieldPos).startsWith("DATE"))
				result = "to_date('" + value + "','yyyy-mm-dd')";
			else if (rs.getMetaData().getColumnTypeName(fieldPos).startsWith(
					"NUMBER")) {
				if (value.trim().equals(""))
					result = " null ";
				else
					result = "'" + value + "'";
			} else
				result = "'" + value + "'";
		}
		return result;
	}

	private String getValue(ResultSet rs, String fieldName) {
		String result = "";
		try {
			int pos = rs.findColumn(fieldName);
			if (pos >= 0) {
				if (rs.getString(fieldName) != null) {
					result = rs.getString(pos);
					// result=result.replaceAll("\n", "&#13;&#10;");
					if (rs.getMetaData().getColumnTypeName(pos).startsWith(
							"DATE")) {
						SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
						result = df.format(rs.getDate(pos));
					} else if (rs.getMetaData().getColumnTypeName(pos)
							.startsWith("NUMBER")) {
						if (rs.getMetaData().getScale(pos) == 0)
							result = String.valueOf(rs.getInt(pos));
						else {
							double value = rs.getDouble(pos);
							// String zero="";
							// for(int
							// i=0;i<rs.getMetaData().getScale(pos);i++){
							// zero+="0";
							// }
							DecimalFormat fnum = new DecimalFormat("##0.0");
							// String dd=fnum.format(value);
							// fnum.setMaximumFractionDigits(rs.getMetaData().getScale(pos));
							fnum.setMinimumFractionDigits(rs.getMetaData()
									.getScale(pos));
							// BigDecimal bigDec=new BigDecimal(value);
							// bigDec.setScale(rs.getMetaData().getScale(pos),BigDecimal.ROUND_HALF_UP);
							// result = rs.getString(pos);
							result = fnum.format(value);
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println("--读取表单出错，字段" + fieldName + "不存在！");
		}
		// if (result.equals("")) result="tt";
		return result;
	}

}
