package com.gtis.web.old;

import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;



public class BuessinesBeanDAO {
	
	private static final org.apache.commons.logging.Log log = LogFactory
    .getLog(BuessinesBeanDAO.class);
	
	private static Object getBean(String name){
		if (name==null || name.equals("")) return null; 
		Object objResult=null;
		objResult=Container.getBean(name);
		if (objResult==null) 
			log.error("名称为：" + name +"的bean不存在，请检查spring配置！");
		return objResult;
	}
	
	/**
	 * 过滤参与者
	 * @param request
	 * @param name
	 * @param wfinstance
	 * @param wfac
	 * @param doc
	 * @return
	 */
	
	public static void doFilterUser(String name,PfWorkFlowInstanceVo instanceVo,String aDId,Document doc){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				//ActivityUsersFilter filter=(ActivityUsersFilter)obj;
				//filter.doFilter(instanceVo, aDId, doc);
			}
		} catch (Exception e) {
			//log.error(e.getMessage());
			log.error(e);
		}
	}
	/**
	 * 显示表单
	 * @param request
	 * @param name
	 * @param proId
	 * @param dfId
	 * @param doc
	 * @return
	 */
	public static boolean doShowForm(String name,String proId,String dfId,Document doc){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				FormEvent event=(FormEvent)obj;
				return event.doShow(proId, dfId, doc);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	public static boolean doSaveForm(String name,String proId,String dfId,Document doc){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				FormEvent event=(FormEvent)obj;
				return event.doSave(proId, dfId, doc);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	/**
	 * 创建工作流
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @return
	 */
	public static boolean doCreateAfter(String name,PfWorkFlowInstanceVo instanceObj){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doCreateAfter(instanceObj);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	/**
	 * 工作流转发前
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	
	public static String doTurnBefore(String name,PfWorkFlowInstanceVo instanceObj, PfActivityVo wfac){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doTurnBefore(instanceObj,wfac);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return "";
		
	}
	/**
	 * 工作流转发后
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	
	public static boolean doTurnAfter(String name,PfWorkFlowInstanceVo instanceObj, PfActivityVo wfac){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doTurnAfter(instanceObj,wfac);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	/**
	 * 工作流退回
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	
	public static boolean doTurnBackAfter(String name,PfWorkFlowInstanceVo instanceObj, PfActivityVo wfac){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doTurnBackAfter(instanceObj,wfac);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	
	/**
	 * 工作流挂起后
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	public static boolean doTurnPostAfter(String name,PfWorkFlowInstanceVo instanceObj){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doTurnPostAfter(instanceObj);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	
	/**
	 * 工作流办结后
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	public static boolean doTurnOverAfter(String name,PfWorkFlowInstanceVo instanceObj, PfActivityVo wfac){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doTurnOverAfter(instanceObj,wfac);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	
	/**
	 * 工作流删除后
	 * @param request
	 * @param instanceObj   工作流实例对象
	 * @return
	 */
	public static boolean doDelAfter(String name,PfWorkFlowInstanceVo instanceObj){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doDelAfter(instanceObj);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	public static boolean doGetBackAfter(String name,PfWorkFlowInstanceVo instanceObj, PfActivityVo wfac){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doGetBackAfter(instanceObj,wfac);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
	}
	
	public static boolean doStopAfter(String name,PfWorkFlowInstanceVo instanceObj){
		try {
			Object obj=getBean(name);
			if (obj!=null){
				WorkFlowEvent event=(WorkFlowEvent)obj;
				return event.doStopAfter(instanceObj);
			}
		} catch (Exception e) {
			log.error(e);
		}
		return false;
		
	}
}
