/*
*本地、异地办件统计
 */

package com.gtis.web.action.dzjc;

import com.gtis.plat.dao.SysDzjcDAO;
import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.opensymphony.xwork2.Action;

import java.util.*;

/**
 * Created by shenjian on 2014-06-10.
 */
public class OffSiteProjectAction extends AbstractPageAction{
    Date beginDate;
    Date endDate;

    List<Map> result;

    SysWorkFlowDefineDao sysWorkFlowDefineDao;

    List<PfWorkFlowDefineVo> workFlowDefineList;

    String wdid;

    SysDzjcDAO sysDzjcDAO;

    public String execute() throws Exception {
        init();
        workFlowDefineList=sysWorkFlowDefineDao.getWorkFlowDefineList();
        Map<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("wdid",wdid);
        int count=  sysDzjcDAO.QueryOffSiteOrganCount(wdid,beginDate,endDate);
        this.setCount(count);
        this.CalPageInfo();
        result=sysDzjcDAO.QueryOffSiteOrgan(mapParam, this.startNum, this.endNum);
        return Action.SUCCESS;
    }


    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<Map> getResult() {
        return result;
    }

    public void setResult(List<Map> result) {
        this.result = result;
    }

    public List<PfWorkFlowDefineVo> getWorkFlowDefineList() {
        return workFlowDefineList;
    }

    public void setWorkFlowDefineList(List<PfWorkFlowDefineVo> workFlowDefineList) {
        this.workFlowDefineList = workFlowDefineList;
    }

    private void init(){
        if (beginDate==null){
            Calendar ca   =   Calendar.getInstance();
            ca.setTime(Calendar.getInstance().getTime());                            //  someDate 为你要获取的那个月的时间
            ca.set(Calendar.DAY_OF_MONTH,   1);
            beginDate  =   ca.getTime();
            ca.add(Calendar.MONTH,   1);
            ca.add(Calendar.DAY_OF_MONTH,   -1);
            endDate   =   ca.getTime();
        }
    }


    public SysWorkFlowDefineDao getSysWorkFlowDefineDao() {
        return sysWorkFlowDefineDao;
    }

    public void setSysWorkFlowDefineDao(SysWorkFlowDefineDao sysWorkFlowDefineDao) {
        this.sysWorkFlowDefineDao = sysWorkFlowDefineDao;
    }

    public String getWdid() {
        return wdid;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }

    public SysDzjcDAO getSysDzjcDAO() {
        return sysDzjcDAO;
    }

    public void setSysDzjcDAO(SysDzjcDAO sysDzjcDAO) {
        this.sysDzjcDAO = sysDzjcDAO;
    }
}
