package com.gtis.web.action.dzjc;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.impl.SysActivityServiceImpl;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 12-7-12
 * Time: 下午2:03
 * 获取当前的活动和用户
 */
public class CurrentActivityAction {
    String wiid;
    SysActivityServiceImpl sysActivityServiceImpl;
    SysTaskService sysTaskService;

    String userNames;
    String activityNames;
    String activityId;
    String taskId;

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public SysActivityServiceImpl getSysActivityServiceImpl() {
        return sysActivityServiceImpl;
    }

    public void setSysActivityServiceImpl(SysActivityServiceImpl sysActivityServiceImpl) {
        this.sysActivityServiceImpl = sysActivityServiceImpl;
    }

    public String getUserNames() {
        return userNames;
    }

    public void setUserNames(String userNames) {
        this.userNames = userNames;
    }

    public String getActivityNames() {
        return activityNames;
    }

    public void setActivityNames(String activityNames) {
        this.activityNames = activityNames;
    }

    public String execute() throws Exception {
        String[] result=sysActivityServiceImpl.getCurrentActivityAndUsers(wiid);
        activityNames=result[0];
        userNames=result[1];
        return Action.SUCCESS;
    }

    public String getActivityById() throws Exception {
        PfActivityVo pfActivityVo = sysActivityServiceImpl.getActivityById(activityId);
        activityNames = pfActivityVo.getActivityName();
        List<PfTaskVo> pfTaskVoList =null;
        if(pfActivityVo.getActivityState()==2){
            pfTaskVoList=sysTaskService.getHistoryTaskListByActivity(pfActivityVo.getActivityId());
        }else{
            pfTaskVoList = sysTaskService.getTaskListByActivity(pfActivityVo.getActivityId());
        }
        if (pfTaskVoList!=null && pfTaskVoList.size()>0){
            userNames=pfTaskVoList.get(0).getUserVo().getUserName();
        }

        if (pfTaskVoList.size()>1)
            userNames=userNames + "等";

        return Action.SUCCESS;
    }

    public String getHistoryTaskById() throws Exception {
        if(StringUtils.isNotBlank(taskId)){
            String[] taskIds = taskId.split(",");

            PfTaskVo pfTaskVo = sysTaskService.getHistoryTask(taskIds[0]);
            PfActivityVo pfActivityVo = sysActivityServiceImpl.getActivityById(pfTaskVo.getActivityId());
            activityNames = pfActivityVo.getActivityName();
            userNames = pfTaskVo.getUserVo().getUserName();
            if(taskIds.length>1){
                activityNames+="等";
                userNames+="等";
            }
        }


        return Action.SUCCESS;
    }


    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public SysTaskService getSysTaskService() {
        return sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}
