package com.gtis.web.action.config;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.util.PropertyPlaceholderHelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @文件说明 用于重新加载初始化egovhome配置文件
 * @作者 deery
 * @创建日期 8:55
 * @版本号 V 1.0
 */
public class ReloadPropertiesAction {
    public String execute() throws Exception{
        try {
            /*****************************************************************/
            /*此处需要修改需要重新加载的配置文件*/
            /*****************************************************************/
            String[] projects = {"egov","platform","portal"};
            Properties properties = new Properties();
            Map appProperties = AppConfig.getProperties();
            Map sysPro = System.getProperties();
            for (int i = 0; i < projects.length; i++) {
                String filePath = getEgovhomeConfigFilePath(projects[i]);
                File file = new File(filePath);
                if (file.exists() && file.isFile()){
                    FileInputStream inputStream = new FileInputStream(file);
                    InputStreamReader reader = new InputStreamReader(inputStream,"UTF-8");
                    Properties prop = new Properties();
                    prop.load(reader);
                    properties.putAll(prop);
                    inputStream.close();
                }
            }

            Enumeration en = properties.propertyNames(); //得到配置文件的名字
            while(en.hasMoreElements()) {
                String key = (String) en.nextElement();
                String newValue = initOptProperties(properties.getProperty(key),properties);
                String oldValue = initOptProperties(AppConfig.getProperty(key),properties);
                if (!StringUtils.equals(newValue,oldValue)){
                    System.setProperty(key, newValue);
                    appProperties.put(key, newValue);
                }
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }

        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("result", "true");
        returnMap.put("msg", "重新加载成功！");
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSON.toJSONString(returnMap));
        return "none";
    }

    /**
     * 获取系统对应的egovhome配置文件路径
     * @param project
     * @return
     * @throws Exception
     */
    private String getEgovhomeConfigFilePath(String project)throws Exception{
        String path = AppConfig.getProperty("egov.conf");
        path = java.net.URLDecoder.decode(path, "UTF-8");
        path = path.replace("file:/", "");
        String filePath = path;
        if (StringUtils.equalsIgnoreCase("egov",project)){
            filePath += "egov.properties";
        }else if (StringUtils.equalsIgnoreCase("gis",project)){
            filePath += "gis.properties";
        }else {
            filePath += project+"/application.properties";
        }
        return filePath;
    }

    /**
     * 格式化url地址为全路径地址
     * @param url
     * @return
     */
    private String initOptProperties(String url,Properties properties) {
        if (url != null) {
            PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
            url = propertyPlaceholderHelper.replacePlaceholders(url, properties);
        }

        return url;
    }
}
