package com.gtis.web.action.admin;

import com.gtis.plat.service.SysRoleService;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;

/**
 * 角色管理
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/7
 */
public class RoleAction {
    private SysRoleService sysRoleService;
    private SplitParam splitParam;

    public SysRoleService getSysRoleService() {
        return sysRoleService;
    }

    public void setSysRoleService(SysRoleService sysRoleService) {
        this.sysRoleService = sysRoleService;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public String execute(){

        SplitParamImpl splitParam1 = new SplitParamImpl();
        HashMap params = new HashMap();
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();

        if(!SessionUtil.getCurrentUser().isAdmin()){
            if(StringUtils.isBlank(regionCode))
                params.put("REGION_CODE", "-99");
            else
                params.put("REGION_CODE", regionCode);
        }
        splitParam1.setQueryParam(params);
        splitParam1.setQueryString("getRoleListByRegionCode");
        splitParam = splitParam1;
        return Action.SUCCESS;
    }
}
