package com.gtis.web.action;

import com.alibaba.fastjson.JSON;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.util.CalendarUtil;
import com.gtis.util.StaticParamHelper;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.*;

public class TurnWorkFlowAction {
    private static final Log log = LogFactory.getLog(TurnWorkFlowAction.class);
    /**
     * 工作流核心服务
     */
    private WorkFlowCoreService workFlowService;
    /**
     * 工作流定义服务
     */
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    /**
     * 工作流实例关系服务
     */
    private SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService;
    /**
     * 工作流实例服务
     */
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    /**
     * 收件单服务
     */
    private SysSjdService sysSjdService;
    /**
     * 文件中心
     */
    private NodeService nodeService;
    /**
     * 意见服务
     */
    private SysOpinionService opinionService;
    /**
     * 子流程服务
     */
    private SysSubProcessService sysSubProcessService;
    /**
     * 活动服务
     */
    private SysTaskService sysTaskService;

    private SysTaskTurnService sysTaskTurnService;
    /**
     * 转发信息xml
     */
    private String turnXml;
    /**
     * 任务id
     */
    private String taskid;
    /**
     * 意见列表
     */
    private String opinions;
    private String nextWdid;
    private static final String CONTENT_TYPE_IMAGE = "text/xml";

    private static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    //是否弹出转发确认
    private boolean confirmTurnInfo = false;
    //是否是子流程结束
    private boolean subProcessFinish = false;

    private List<PfWorkFlowDefineVo> nextWorkflowList;

    private String firstuserEmpty;

    //2018-10-15新增鹤岗需求，办结改为下一步（hasFinish=true的情况下，增加参数,工作流拓展属性增加changeEndName=true）
    private boolean hasChangeEndName = false;
    private String handleStyle;

    public boolean isConfirmTurnInfo() {
        return confirmTurnInfo;
    }

    public String execute() throws Exception {
        firstuserEmpty = AppConfig.getProperty("platform.workflow.turn.firstuser.empty");

        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = null;
        if (sysSubProcessService.isSubProcessFinishing(taskid)) {
            subProcessFinish = true;
            info = workFlowService.getWorkFlowTurnInfo("-1", sysTaskService.getActivity(sysTaskService.getTask(taskid).getActivityId()).getWorkflowInstanceId());
        } else {
            info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        }
        String taskTurnInfo = sysTaskTurnService.getTurnInfoFromGlobalVal(taskid, info.getWorkFlowIntanceVo().getWorkflowIntanceId());
        if (StringUtils.isNotBlank(taskTurnInfo))
            turnXml = taskTurnInfo;
        else
            turnXml = turnInfo(info);
        opinions = JSONUtil.serialize(opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName()));
        //
        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        ActivityModel activityModel = workFlowXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
        if ("true".equals(activityModel.getExtendedAttribute("ConfirmTurnInfo")))
            confirmTurnInfo = true;
        return Action.SUCCESS;
    }

    public String trunXml() throws Exception {
        String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        String taskTurnInfo = sysTaskTurnService.getTurnInfoFromGlobalVal(taskid, info.getWorkFlowIntanceVo().getWorkflowIntanceId());
        if (StringUtils.isNotBlank(taskTurnInfo))
            turnXml = taskTurnInfo;
        else
            turnXml = turnInfo(info);
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(turnXml);

        return Action.NONE;
    }

    public String opinions() throws Exception {
        String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);

        opinions = JSONUtil.serialize(opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName()));
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(opinions);

        return Action.NONE;
    }

    /**
     * <Activitys RelType="or">
     * <Activity Name="转发活动一" Id="a1" MutiSelect="true" DefaultSelected="true">
     * <User Name="××部门" Id="1">
     * <UserInfo Name="u1" Id="u1" DefaultSelected="true"/>
     * <UserInfo Name="u11" Id="u11"/>
     * </User>
     * <User Name="××部门" Id="2">
     * <UserInfo Name="au2" Id="u2"/>
     * <UserInfo Name="au21" Id="u21"/>
     * </User>
     * <User Name="××角色" Id="3">
     * <UserInfo Name="au3" Id="u3" DefaultSelected="true"/>
     * <UserInfo Name="au31" Id="u31"/>
     * <UserInfo  Name="au32" Id="u32"/>
     * </User>
     * </Activity>
     * <Activity Name="转发活动二" Id="a2" MutiSelect="false">
     * <User Name="××部门" Id="11">
     * <UserInfo Name="u1" Id="u1"/>
     * <UserInfo Name="u11" Id="u11"/>
     * </User>
     * </Activitys>
     */

    private String turnInfo(WorkFlowInfo info) throws Exception {

        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());

        String filterType = null;
        List<String> filterStr = null;
        if (StringUtils.isNotBlank(activityModel.getFilterInfo())) {
            //过滤信息对象
            Document fileDoc = DocumentHelper.parseText(activityModel.getFilterInfo());
            //过滤类型：User,Organ,Role
            String user = fileDoc.getRootElement().valueOf("@type");
            Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getUserId(ServletActionContext.getRequest()) + "']/Correspondence");
            if (corNode != null) {
                filterType = corNode.valueOf("@type");
                List<DefaultText> organList = corNode.selectNodes(filterType + "/text()");
                if (organList != null && !organList.isEmpty()) {
                    filterStr = new ArrayList<String>();
                    for (DefaultText text : organList) {
                        filterStr.add(text.getText());
                    }
                }
            }
        }

        WorkFlowTransInfo transInfo = info.getTransInfo();
        Document doc = org.dom4j.DocumentHelper.createDocument();
        //doc.setXMLEncoding("GBK");
        Element root = doc.addElement("Activitys");
        if (transInfo.getTransType().equalsIgnoreCase("and")) {
            root.addAttribute("RelType", "and");
            //是否默认选中所需要转发的所有节点，针对并线转发的时候
            if (StringUtils.equalsIgnoreCase("true", activityModel.getExtendedAttribute("CheckedAllActivity"))) {
                root.addAttribute("CheckedAllActivity", "true");
            } else {
                root.addAttribute("CheckedAllActivity", "false");
            }
        } else {
            root.addAttribute("RelType", "or");
        }

        if (activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")) {
            root.addAttribute("ReqOpinion", "true");
        } else {
            root.addAttribute("ReqOpinion", "false");
        }
        if (activityModel.getIsSendSMS().equalsIgnoreCase("true")) {
            root.addAttribute("SendSMS", "true");
        } else {
            root.addAttribute("SendSMS", "false");
        }
        if (StringUtils.isNotBlank(activityModel.getCooperRootId())) {
            root.addAttribute("cooperRootId", activityModel.getCooperRootId());
        }

        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans.size() < 2)
            root.addAttribute("RelType", "or");
        for (ActivityModel aModel : lstTrans) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
            ActivityEle.addAttribute("Id", aModel.getDefineId());
            ActivityEle.addAttribute("ExtendedMap", JSON.toJSONString(aModel.getExtendedAttributeMap()));
            if (aModel.isMutiSelect())
                ActivityEle.addAttribute("MutiSelect", "true");

            if (!aModel.isSelectAll())
                ActivityEle.addAttribute("SelectAll", "false");
            else
                ActivityEle.addAttribute("SelectAll", "true");

            if (aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName()))
                ActivityEle.addAttribute("DefaultSelected", "true");
            else
                ActivityEle.addAttribute("DefaultSelected", "false");

            //是否将【全部】选项放到下拉框底部，默认是顶部
            String selectAllToEnd = AppConfig.getProperty("platform.workflow.turn.selectall.to.end");
            if (!StringUtils.equalsIgnoreCase("true", selectAllToEnd)) {
                selectAllToEnd = aModel.getExtendedAttribute("SelectAllToEnd");
            }
            ActivityEle.addAttribute("SelectAllToEnd", selectAllToEnd);

            //***********************处理默认选择的人员*************************
            //默认需要选择的人员名单
            HashMap<String, String> defaultUserMap = new HashMap<String, String>();
            String userName = null;
            if (StringUtils.isNotBlank(aModel.getExtendedAttribute("DefaultSelectedUser"))) {
                userName = aModel.getExtendedAttribute("DefaultSelectedUser");
            }

            //针对个别地方要求，默认转给自己，因此增加节点拓展属性，默认选中自己
            String defaultSelectedSelf = aModel.getExtendedAttribute("DefaultSelectedSelf");
            if (StringUtils.equalsIgnoreCase("true", defaultSelectedSelf)) {
                userName = SessionUtil.getCurrentUser().getUsername();
            }

            //针对个别地方要求，默认转给之前的某一个节点的参与人员，根据配置的某一个节点的ID来处理
            String defaultSelectedUserByActivityId = aModel.getExtendedAttribute("DefaultSelectedUserByActivityId");
            if (StringUtils.isNotBlank(defaultSelectedUserByActivityId)) {
                //List<PfTaskVo> tmpList = taskService.getHistoryTaskListByDefineId(info.getWorkFlowIntanceVo().getWorkflowIntanceId(),defaultSelectedUserByActivity);
                PfActivityVo tmpAcVo = sysTaskService.getActivityBywIdandadId(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), defaultSelectedUserByActivityId);
                List<PfTaskVo> tmpList = new ArrayList<PfTaskVo>();
                List<PfTaskVo> tmpTaskList = sysTaskService.getTaskListByActivity(tmpAcVo.getActivityId());
                if (tmpTaskList != null && !tmpTaskList.isEmpty()) {
                    tmpList.addAll(tmpTaskList);
                }
                List<PfTaskVo> tmpHisTaskList = sysTaskService.getHistoryTaskListByActivity(tmpAcVo.getActivityId());
                if (tmpHisTaskList != null && !tmpHisTaskList.isEmpty()) {
                    tmpList.addAll(tmpHisTaskList);
                }
                if (tmpList != null && !tmpList.isEmpty()) {
                    for (int i = 0; i < tmpList.size(); i++) {
                        PfTaskVo tmpVo = tmpList.get(i);
                        defaultUserMap.put(tmpVo.getUserVo().getUserName(), tmpVo.getUserVo().getUserName());
                    }
                }
            }

            if (StringUtils.isNotBlank(userName)) {
                defaultUserMap.put(userName, userName);
            }
            //***********************end处理默认选择的人员*************************

            //是否针对角色增加默认空选项功能，以逗号开始和结尾，便于判断是否完整匹配
            //该功能是对于默认全部的情况下，部分角色需要默认为空
            String allowTurnEmptyRole = "," + aModel.getExtendedAttribute("allowTurnEmptyRole") + ",";

            //针对转发角色，增加默认转发选项为全部的过滤配置，该选项配合使用platform.workflow.turn.firstuser.empty，
            //也就是在配置了empty为空的时候，部分角色要求默认为全部选项
            String allowTurnAllRole = "," + aModel.getExtendedAttribute("allowTurnAllRole") + ",";

            for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if (filterStr != null && userModel.getType().equals(filterType)) {
                    if (!filterStr.contains(userModel.getId())) {
                        continue;
                    }
                }
                Element User = ActivityEle.addElement("User");
                //角色信息
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                //判断哪些角色是默认置空的
                if (StringUtils.contains(allowTurnEmptyRole, "," + userModel.getName() + ",")) {
                    User.addAttribute("allowEmpty", "true");
                }
                //判断哪些角色是默认全部的
                if (StringUtils.contains(allowTurnAllRole, "," + userModel.getName() + ",")) {
                    User.addAttribute("allowAll", "true");
                }

                //是否过滤掉参与人员中的同一个人,根据拓展属性，去掉参与人中的当前人员，避免自己转给自己
                String noRepeatUser = aModel.getExtendedAttribute("noRepeatUser");

                //如果只有一个人员，则不进行去重处理
                if (userModel.getUserList().size() < 2) {
                    noRepeatUser = "false";
                }

                //用户信息
                for (PfUserVo vo : userModel.getUserList()) {
                    //根据拓展属性，去掉参与人中的当前人员，避免自己转给自己
                    if (StringUtils.equalsIgnoreCase("true", noRepeatUser)) {
                        if (StringUtils.equals(vo.getUserId(), SessionUtil.getCurrentUserId())) {
                            continue;
                        }
                    }

                    Element UserInfo = User.addElement("UserInfo");
                    UserInfo.addAttribute("Name", vo.getUserName());
                    UserInfo.addAttribute("Id", vo.getUserId());
                    for (Map.Entry<String, String> entry : defaultUserMap.entrySet()) {
                        String defaultUser = entry.getKey();
                        if (StringUtils.isNotBlank(defaultUser) && vo.getUserName().equalsIgnoreCase(defaultUser)) {
                            User.addAttribute("DefaultSelected", "true");
                            UserInfo.addAttribute("DefaultSelected", "true");
                        }
                    }
                    /*if (vo.getUserId().equals(SessionUtil.getCurrentUserId())){
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo.addAttribute("DefaultSelected", "true");
                    }*/
                }
            }
        }
        // 加入是否可以办结
        if (transInfo.isCanFinish()) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", "任务办结");
            ActivityEle.addAttribute("Id", "-1");
        }

        doc = httpFilterXml(doc, activityModel, info);

        return doc.getRootElement().asXML();
    }

    /**
     * 通过TurnInfo处理url
     *
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc, ActivityModel actModel, WorkFlowInfo info) {
        if (StringUtils.isNotBlank(actModel.getTurnInfoUrl())) {
            String url = actModel.getTurnInfoUrl();
            if (!url.startsWith("http")) {
                url = AppConfig.getPlaceholderValue(url);
            }
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = {
                    new NameValuePair("turnInfo", doc.asXML()),
                    new NameValuePair("userId", info.getUserId()),
                    new NameValuePair("proId", (info.getWorkFlowIntanceVo() == null) ? "" : info.getWorkFlowIntanceVo().getProId())
            };

            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                log.error("TurnInfo filter url request failer{}", e);
            }
            if (status == HttpStatus.SC_OK) {
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if (StringUtils.isNotBlank(xml)) {
                        doc = DocumentHelper.parseText(xml);
                    }
                } catch (Exception e) {
                    log.error("TurnInfo filter url request success,prase failure{}", e);
                }
            } else {
                log.error("TurnInfo filter url request failer");
            }
        }
        return doc;
    }

    /**
     * 开始转发
     *
     * @return
     * @throws Exception <?xml version="1.0" encoding="UTF-8"?>
     *                   <Activitys RelType="or">
     *                   <Activity Id="2806A214134F42A798483B2033DE05FB">
     *                   <UserInfo Id="02501030000007603100000000000000" RoleId="75501003000000000800000000000000"/>
     *                   </Activity>
     *                   <ReMark>
     *                   <text/>
     *                   </ReMark>
     *                   </Activitys>
     */
    public String TurnTask() throws Exception {
        try {
            doTurnTask(parseTurnInfo(), taskid);
        } catch (Exception e) {
            e.printStackTrace();
            printResult(e.getMessage());
        }
        //printResult(null);
        //gaizao
        Map result = new HashMap();
        result.put("backxml","true");
        result.put("taskid",taskid);
        handleStyle = AppConfig.getProperty("portal.handle.style");
        Struts2Utils.renderJson(result);
        return Action.NONE;
    }

    /**
     * @param turnInfo 转发信息
     * @param taskId   转发任务ID
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/12/8
     * @description
     */
    private void doTurnTask(Document turnInfo, String taskId) throws Exception {
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(SessionUtil.getCurrentUserId(), taskId);
        workFlowService.turnTask(turnInfo, taskId);

        //如果不是办结节点，没有传递下个工作流定义，则获取当前节点的扩展属性是否包含下个节点的数据配置
        if (StringUtils.isBlank(nextWdid)) {
            WorkFlowXml xmlUtil = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            if (!StringUtils.equals(xmlUtil.getEndActivityDefine(), info.getSourceActivity().getActivityDefinitionId())) {
                ActivityModel activityModel = xmlUtil.getActivity(info.getSourceActivity().getActivityDefinitionId());
                String enabledNextWorkflow = activityModel.getExtendedAttribute("EnabledNextWorkflow");
                if (StringUtils.isNotBlank(enabledNextWorkflow)) {
                    List workflowNameList = Arrays.asList(enabledNextWorkflow.split(","));
                    HashMap tmpMap = new HashMap();
                    tmpMap.put("WORKFLOW_NAME", workflowNameList.get(0));
                    List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineByParam(tmpMap);
                    if (pfWorkFlowDefineVoList != null && pfWorkFlowDefineVoList.size() > 0) {
                        nextWdid = pfWorkFlowDefineVoList.get(0).getWorkflowDefinitionId();
                    }
                }
            }
        }
        if (StringUtils.isNotBlank(nextWdid)) {
            startNextWorkflow(info.getWorkFlowIntanceVo());
        }
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 同类任务（同种工作流定义，并处于同一活动节点）的批量转发，这一类活动的转发节点和参与人都是一样的
     */
    public String batchTurnTask() throws Exception {
        try {
            Document turnInfo = parseTurnInfo();
            String[] taskIds = taskid.split(",");
            for (String value : taskIds) {
                doTurnTask(turnInfo, value);
            }
        } catch (Exception e) {
            e.printStackTrace();
            printResult(e.getMessage());
        }
        printResult(null);
        return Action.NONE;
    }

    /**
     * 读取提交的XML信息
     *
     * @return
     */
    private Document parseTurnInfo() throws Exception {
        Document doc = null;
        SAXReader reader = new SAXReader();
        doc = reader.read(ServletActionContext.getRequest()
                .getInputStream());
        return doc;
    }

    private void printResult(String info) {
        WorkFlowUtil.clearCache("WorkFlowInstanceCache");
        try {
            ServletActionContext.getResponse().setContentType("text/html; charset=utf-8");
            PrintWriter out = ServletActionContext.getResponse().getWriter();
            if (info == null)
                out.print("true");
            else
                out.println(info);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 复杂的办结页面
     *
     * @return
     * @throws Exception
     */
    public String finishWorkflow() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String enabledNextWorkflow = activityModel.getEnabledNextWorkflow();
        if (StringUtils.isNotBlank(enabledNextWorkflow)) {
            nextWorkflowList = new ArrayList<PfWorkFlowDefineVo>();
            List workflowNameList = Arrays.asList(enabledNextWorkflow.split(","));
            List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
            for (PfWorkFlowDefineVo pfWorkFlowDefineVo : pfWorkFlowDefineVoList) {
                if (workflowNameList.indexOf(pfWorkFlowDefineVo.getWorkflowName()) > -1) {
                    nextWorkflowList.add(pfWorkFlowDefineVo);
                }
            }
        }
        String changeEndName = xmlDao.getExtendedAttribute("changeEndName");
        if (StringUtils.isNotBlank(changeEndName)) {
            hasChangeEndName = true;
        }
        return "finish";
    }

    /**
     * 办结时是否需要有后续流程可启动
     *
     * @return
     * @throws Exception
     */
    public String hasNextWorkflow() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String enabledNextWorkflow = activityModel.getEnabledNextWorkflow();
        if (StringUtils.isNotBlank(enabledNextWorkflow))
            printResult(null);
        else
            printResult("false");
        return Action.NONE;
    }

    /**
     * 启动后续流程
     *
     * @param pfWorkFlowInstanceVo
     * @throws Exception
     */
    private void startNextWorkflow(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception {
        String currentWorkflowName = pfWorkFlowInstanceVo.getWorkflowIntanceName();
        PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(nextWdid);
        //获取该流程的工作流关联信息，判断是否已经创建过新流程
        boolean isOk = true;
        List<PfWorkFlowInstanceVo> voList = sysWorkFlowInstanceRelService.getWorkFlowRelList(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        if (voList != null || voList.size() > 0) {
            for (int i = 0; i < voList.size(); i++) {
                if (StringUtils.equals(voList.get(i).getWorkflowDefinitionId(), nextWdid)) {
                    isOk = false;
                    break;
                }
            }
        }
        if (isOk) {
            //首先获取当前工作流id下相关信息，主要包括文件中心、工作流名称
            Space space = nodeService.getWorkSpace(WORK_FLOW_STUFF, true);
            com.gtis.fileCenter.model.Node curNode = nodeService.getNode(space.getId(), pfWorkFlowInstanceVo.getWorkflowIntanceId(), true);
            Integer curNodeId = curNode.getId();
            List<com.gtis.fileCenter.model.Node> curNodeList = nodeService.getChildNodes(curNodeId);
            Integer[] curNodes = null;
            if (curNodeList != null && curNodeList.size() > 0) {
                curNodes = new Integer[curNodeList.size()];
                for (int i = 0; i < curNodeList.size(); i++) {
                    curNodes[i] = curNodeList.get(i).getId();
                }
            }

            //创建wdid对应的工作流实例ID
            String newProid = UUIDGenerator.generate();
            com.gtis.fileCenter.model.Node newNode = nodeService.getNode(space.getId(), newProid, true);
            Integer newNodeId = newNode.getId();

            //开始文件中心记录复制
            if (curNodes != null && curNodes.length > 0) {
                nodeService.copy(curNodes, newNodeId, true);
            }

            //开始创建目标工作流
            String userid = SessionUtil.getCurrentUserId();
            String username = SessionUtil.getCurrentUser().getUsername();
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            intanceVo.setWorkflowDefinitionId(nextWdid);
            intanceVo.setWorkflowIntanceId(newProid);
            intanceVo.setProId(newProid);
            //标明是大流程
            String remark = StaticParamHelper.FULL_WFINSTANCE;
            intanceVo.setRemark(remark);
            intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setPriority("1");
            intanceVo.setWorkflowIntanceName(currentWorkflowName);
            intanceVo.setCreateUser(userid);
            intanceVo.setCreateTime(CalendarUtil.getCurHMDate());
            intanceVo.setDistrict(pfWorkFlowInstanceVo.getDistrict());

            //保存关联工作流信息
            sysWorkFlowInstanceRelService.insertWorkFlowRel(pfWorkFlowInstanceVo.getWorkflowIntanceId(), newProid);
            //创建工作流
            WorkFlowInfo infoObj = workFlowService.createWorkFlowInstance(intanceVo, userid);
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userid)) {
                    taskid = taskVo.getTaskId();
                    break;
                }
            }
            if (taskid == null || taskid.equals("")) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskid = taskVo.getTaskId();
                    break;
                }
            }


            //初始化收件单材料，合并当前收件单材料和新流程的收件材料
            sysSjdService.createSjdByPreviousWorkflow(newProid, username, newNodeId, pfWorkFlowInstanceVo.getWorkflowIntanceId());
        }
    }


    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getOpinions() {
        return opinions;
    }

    public WorkFlowCoreService getWorkFlowService() {
        return workFlowService;
    }

    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }

    public String getTurnXml() {
        return turnXml;
    }

    public void setTurnXml(String turnXml) {
        this.turnXml = turnXml;
    }

    public void setOpinionService(SysOpinionService opinionService) {
        this.opinionService = opinionService;
    }

    public SysWorkFlowDefineService getSysWorkFlowDefineService() {
        return sysWorkFlowDefineService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }

    public List<PfWorkFlowDefineVo> getNextWorkflowList() {
        return nextWorkflowList;
    }

    public void setNextWorkflowList(List<PfWorkFlowDefineVo> nextWorkflowList) {
        this.nextWorkflowList = nextWorkflowList;
    }

    public NodeService getNodeService() {
        return nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public SysSjdService getSysSjdService() {
        return sysSjdService;
    }

    public void setSysSjdService(SysSjdService sysSjdService) {
        this.sysSjdService = sysSjdService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public SysWorkFlowInstanceRelService getSysWorkFlowInstanceRelService() {
        return sysWorkFlowInstanceRelService;
    }

    public void setSysWorkFlowInstanceRelService(SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService) {
        this.sysWorkFlowInstanceRelService = sysWorkFlowInstanceRelService;
    }

    public String getNextWdid() {
        return nextWdid;
    }

    public void setNextWdid(String nextWdid) {
        this.nextWdid = nextWdid;
    }

    public SysSubProcessService getSysSubProcessService() {
        return sysSubProcessService;
    }

    public void setSysSubProcessService(SysSubProcessService sysSubProcessService) {
        this.sysSubProcessService = sysSubProcessService;
    }

    public boolean isSubProcessFinish() {
        return subProcessFinish;
    }

    public void setSubProcessFinish(boolean subProcessFinish) {
        this.subProcessFinish = subProcessFinish;
    }

    public SysTaskService getSysTaskService() {
        return sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }

    public void setSysTaskTurnService(SysTaskTurnService sysTaskTurnService) {
        this.sysTaskTurnService = sysTaskTurnService;
    }

    public String getFirstuserEmpty() {
        return firstuserEmpty;
    }

    public void setFirstuserEmpty(String firstuserEmpty) {
        this.firstuserEmpty = firstuserEmpty;
    }

    public boolean isHasChangeEndName() {
        return hasChangeEndName;
    }

    public void setHasChangeEndName(boolean hasChangeEndName) {
        this.hasChangeEndName = hasChangeEndName;
    }

    public String getHandleStyle() {
        return handleStyle;
    }

    public void setHandleStyle(String handleStyle) {
        this.handleStyle = handleStyle;
    }
}
