package com.gtis.web.action;

import java.util.HashMap;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.gtis.plat.wf.WorkFlowUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

public class TurnBackWorkFlowAction {

	WorkFlowCoreService workFlowService;
	String taskid;
	List<PfActivityVo> backActivitys;  //退回活动  
	String adids;
	String remark;
	
	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	private static final org.apache.commons.logging.Log log = LogFactory
			.getLog(TurnBackWorkFlowAction.class);

	public WorkFlowCoreService getWorkFlowService() {
		return workFlowService;
	}

	public void setWorkFlowService(WorkFlowCoreService workFlowService) {
		this.workFlowService = workFlowService;
	}

	public String execute() throws Exception {
		String userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		WorkFlowInfo info=workFlowService.getWorkFlowTurnBackInfo(userId, taskid);
		backActivitys=info.getTargetActivitys();
		return Action.SUCCESS;
	}

    /**
     * 直接退回节点
     * @return
     * @throws Exception
     */
	public String BackTask() throws Exception {
		String userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		if (adids!=null && !adids.equals("")){
			String[] backDefineActivitys=adids.split(",");
			try {
				workFlowService.postBackWorkFlow(userId, taskid, backDefineActivitys,remark);
				ServletActionContext.getResponse().getWriter().println("true");
			} catch (Exception e) {
				ServletActionContext.getResponse().getWriter().println(e.getMessage());
				//log.error(e.getMessage(), e);
			}
		}
		return Action.NONE;
	}

    /**
     * 选择人员进行退回
     * @return
     * @throws Exception
     */
	public String BackTaskByUser() throws Exception {
		String userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		if (StringUtils.isNotBlank(adids)){
			try {
				HashMap<String,String> selectAcMap = JSON.parseObject(adids,HashMap.class);
				workFlowService.postBackWorkFlow(userId, taskid, selectAcMap,remark);
				ServletActionContext.getResponse().getWriter().println("true");
			} catch (Exception e) {
				ServletActionContext.getResponse().getWriter().println(e.getMessage());
				//log.error(e.getMessage(), e);
			}
		}
		WorkFlowUtil.clearCache("TaskHistoryCache");
		return Action.NONE;
	}

    /**
     * 批量退回
     * @return
     * @throws Exception
     */
    public String BackTaskBatch() throws Exception{
        String userId=SessionUtil.getCurrentUserId();
        WorkFlowInfo info=workFlowService.getWorkFlowTurnBackInfo(userId, taskid);
        backActivitys=info.getTargetActivitys();
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        if (backActivitys!=null&&backActivitys.size()>0){
            try {
                String[] backDefineActivitys = {backActivitys.get(0).getActivityDefinitionId()};
                workFlowService.postBackWorkFlow(userId, taskid, backDefineActivitys,remark);
            } catch (Exception e) {
                ServletActionContext.getResponse().getWriter().println(e.getMessage());
            }
        }else{
            ServletActionContext.getResponse().getWriter().println("不存在上一个节点，无法退回！");
        }
        return Action.NONE;
    }

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public List<PfActivityVo> getBackActivitys() {
		return backActivitys;
	}

	public void setBackActivitys(List<PfActivityVo> backActivitys) {
		this.backActivitys = backActivitys;
	}

	public String getAdids() {
		return adids;
	}

	public void setAdids(String adids) {
		this.adids = adids;
	}
}
