package com.gtis.web.action;

import org.apache.commons.logging.LogFactory;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.opensymphony.xwork2.Action;

public class TaskModifyAction {

	private String taskid;
	private SysTaskService taskService;
	private SysWorkFlowInstanceService intanceService;
	private String taskName;
	static final org.apache.commons.logging.Log log = LogFactory
			.getLog(TaskModifyAction.class);
	private boolean result=false;
	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public String execute() throws Exception {
		PfTaskVo taskVo=taskService.getTask(taskid);
		PfActivityVo activityVo=taskService.getActivity(taskVo.getActivityId());
		PfWorkFlowInstanceVo workFlowInstanceVo=intanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
		taskName=workFlowInstanceVo.getWorkflowIntanceName();
		return Action.SUCCESS;
	}

	public String save() throws Exception {
		PfTaskVo taskVo=taskService.getTask(taskid);
		PfActivityVo activityVo=taskService.getActivity(taskVo.getActivityId());
		PfWorkFlowInstanceVo workFlowInstanceVo=new PfWorkFlowInstanceVo();
		workFlowInstanceVo.setWorkflowIntanceId(activityVo.getWorkflowInstanceId());
		workFlowInstanceVo.setWorkflowIntanceName(taskName);
		intanceService.updateWorkFlowIntanceName(workFlowInstanceVo);
		result=true;
		return Action.SUCCESS;
	}
	
	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public SysWorkFlowInstanceService getIntanceService() {
		return intanceService;
	}

	public void setIntanceService(SysWorkFlowInstanceService intanceService) {
		this.intanceService = intanceService;
	}

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public boolean isResult() {
		return result;
	}

	public void setResult(boolean result) {
		this.result = result;
	}
}
