package com.gtis.web.action;

import java.text.SimpleDateFormat;
import java.util.*;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.rss.RssAction;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public abstract class TaskListActionAbstract extends RssAction{

    //当前时间
    private Date cDate;
    /** 分页 */
	private SplitParam splitParam;
    /** 工作流定义列表 */
	private List<PfWorkFlowDefineVo> lstWorkFlowDefine;
    /** 业务列表 */
    private List<PfBusinessVo> businessList;
    /** 工作流定义服务 */
	private SysWorkFlowDefineService workFlowDefineService;
    /** 用户管理服务 */
	private SysUserService userService;
    private SysDistrictService districtService;
    /** 系统配置 */
	PfConfigVo configVo;
    /** 业务类型，可以传入用来过滤不同的业务 */
    private String btypes;

    private String businessid;
    private String regionCode;
    private boolean filterRegioncode;
    private String canQueryTransUsers;

    boolean barCodeQuery=false;   //是否使用条形码查询功能

    String lastDate; //

    private List<Map> activityDefineList;
    private String wdid;

    private List<PfDistrictVo> disList;

    private List<PfOrganVo> organList;

    private String handleStyle;

    public String getLastDate() {
        return lastDate;
    }

    public void setLastDate(String lastDate) {
        this.lastDate = lastDate;
    }

    public boolean isBarCodeQuery() {
        return barCodeQuery;
    }

    public void setBusinessid(String businessid) {
        this.businessid = businessid;
    }

    public Date getcDate() {
        return Calendar.getInstance().getTime();
    }

    private void initPageWDList(){
        lstWorkFlowDefine = new ArrayList<PfWorkFlowDefineVo>();
        HashMap param = new HashMap();
        if (StringUtils.isNotBlank(businessid)){
            param.put("BUSINESS_ID",businessid);
        }
        if (StringUtils.isNotBlank(regionCode)){
            regionCode = StringUtils.removeEnd(regionCode,"0000");
            regionCode = StringUtils.removeEnd(regionCode,"00");
            param.put("REGION_CODE",regionCode);
        }
        boolean filterUser = AppConfig.getBooleanProperty("wdlist.filter.user",false);
        if (filterUser){
            UserInfo userInfo = SessionUtil.getCurrentUser();
            param.put("USER_ID",userInfo.getId());
            if (userInfo.isAdmin()){
                param.remove("USER_ID");
            }
            lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineByUserAndParam(param);
        }else {
            lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineByParam(param);
        }
        if (lstWorkFlowDefine == null){
            lstWorkFlowDefine = new ArrayList<PfWorkFlowDefineVo>();
        }
    }

    private void initPageBSList(){
        businessList = new ArrayList<PfBusinessVo>();
        HashMap param = new HashMap();
        boolean filterUser = AppConfig.getBooleanProperty("wdlist.filter.user",false);
        if (filterUser){
            UserInfo userInfo = SessionUtil.getCurrentUser();
            param.put("USER_ID",userInfo.getId());
            if (userInfo.isAdmin()){
                param.remove("USER_ID");
            }
            businessList = workFlowDefineService.getBusinessListByUserAndParam(param);
        }else {
            businessList = workFlowDefineService.getBusinessSimpleList();
        }
        if (businessList == null){
            businessList = new ArrayList<PfBusinessVo>();
        }
    }

    public String getWorkFlowDefineList()throws Exception{
        initPageWDList();
        if (lstWorkFlowDefine != null && lstWorkFlowDefine.size() > 0) {
			if (!StringUtils.contains(lstWorkFlowDefine.get(0).getWorkflowName(), "所有流程")) {
				PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
		        vo.setWorkflowName("----所有流程----");
		        vo.setWorkflowDefinitionId("");
		        lstWorkFlowDefine.add(0, vo);
			}
		}
        ServletActionContext.getResponse().setContentType("text/xml;charset=utf-8");
        String json= ObjectJSONUtil.ObjectToJson(lstWorkFlowDefine);
        ServletActionContext.getResponse().getOutputStream().write(json.toString().getBytes("utf-8"));
        ServletActionContext.getResponse().getOutputStream().flush();
        ServletActionContext.getResponse().getOutputStream().close();
        return Action.NONE;
    }

    public String getActivityList()throws Exception{
        activityDefineList = new ArrayList<Map>();
        Map activityMap = null;
        if(StringUtils.isNotBlank(wdid)) {
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineService.getWorkFlowDefine(wdid));
            List<ActivityModel> activityModelList = xmlDao.getActivityList();
            for(ActivityModel activityModel:activityModelList){
                activityMap = new HashMap();
                activityMap.put("activityName",activityModel.getActivityDefineName());
                activityMap.put("activityValue", activityModel.getActivityDefineName());
                activityDefineList.add(activityMap);
            }
        }
        if (activityDefineList != null && activityDefineList.size() > 0) {
			if (!StringUtils.contains(MapUtils.getString(activityDefineList.get(0),"activityName"), "所有活动")) {
				activityMap = new HashMap();
		        activityMap.put("activityName","----所有活动----");
		        activityMap.put("activityValue", "");
		        activityDefineList.add(0, activityMap);
			}
		}

        ServletActionContext.getResponse().setContentType("text/xml;charset=utf-8");
        String json= ObjectJSONUtil.ObjectToJson(activityDefineList);
        ServletActionContext.getResponse().getOutputStream().write(json.toString().getBytes("utf-8"));
        ServletActionContext.getResponse().getOutputStream().flush();
        ServletActionContext.getResponse().getOutputStream().close();
        return Action.NONE;
    }

    public String execute() throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR,-1);
        lastDate = simpleDateFormat.format(calendar.getTime());

		SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString(this.getIbatisQueryName());
		splitParam1.setQueryParam(this.getParam());
		splitParam=splitParam1;

        initPageWDList();
        if (lstWorkFlowDefine != null && lstWorkFlowDefine.size() > 0) {
            if (!org.apache.commons.lang3.StringUtils.contains(lstWorkFlowDefine.get(0).getWorkflowName(), "所有业务")) {
                PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
                vo.setWorkflowName("----所有业务----");
                vo.setWorkflowDefinitionId("");
                lstWorkFlowDefine.add(0, vo);
            }
        }

        initPageBSList();
        if (businessList != null && businessList.size() > 0) {
            if (!org.apache.commons.lang3.StringUtils.contains(getBusinessList().get(0).getBusinessName(), "所有业务")) {
                PfBusinessVo pbv = new PfBusinessVo();
                pbv.setBusinessName("----所有业务----");
                pbv.setBusinessId("");
                businessList.add(0,pbv);
            }
        }

        activityDefineList = new ArrayList<Map>();
        Map activityMap = new HashMap();
        activityMap.put("activityName","");
        activityMap.put("activityValue", "");
        activityDefineList.add(0, activityMap);

        configVo=SessionUtil.getUserConfig(ServletActionContext.getRequest());
		ServletActionContext.getRequest().setAttribute("USERID",SessionUtil.getUserId(ServletActionContext.getRequest()));

        //是否使用条形码查询功能
        String barcode= AppConfig.getProperty("barcode.enable");
        if ("true".equalsIgnoreCase(barcode))
            barCodeQuery= true;

        disList = districtService.queryAllDistrict();
        if (disList == null){
            disList = new ArrayList<PfDistrictVo>();
        }

        if (CollectionUtils.isNotEmpty(disList) && StringUtils.isNotBlank(disList.get(0).getDistrictCode())) {
            PfDistrictVo disVo = new PfDistrictVo();
            disVo.setDistrictCode("");
            disVo.setDistrictName("----所有----");
            disList.add(0,disVo);
        }

        filterRegioncode = AppConfig.getBooleanProperty("wdlist.filter.regioncode", false);
        canQueryTransUsers = AppConfig.getProperty("platform.taskoverlist.query.transusers");

        organList = new ArrayList<PfOrganVo>();
        if (SessionUtil.getCurrentUser().isAdmin()){
            organList = userService.getAllOrganList();
        }else{
            organList = userService.getOrganListByUser(SessionUtil.getCurrentUser().getId());
        }
        if (organList == null){
            organList = new ArrayList<PfOrganVo>();
        }
        if (StringUtils.isNotBlank(organList.get(0).getOrganId())) {
            PfOrganVo organVo = new PfOrganVo();
            organVo.setOrganId("");
            organVo.setOrganName("----所有----");
            organList.add(0,organVo);
        }

        handleStyle = AppConfig.getProperty("portal.handle.style");
        return Action.SUCCESS;
	}

    /**
     * rss源发布
     * @return
     * @throws Exception
     */
	public String rss() throws Exception {
		SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString(this.getIbatisQueryName());
		splitParam1.setQueryParam(this.getParam());
		super.setRssParam(splitParam1);
		return super.rss();
	}

    /**
     * 参数处理
     * @return
     */
    public HashMap<String,String> getParam() {
        HashMap<String,String> mapParam= new HashMap<String, String>();
        String bType= buildBusinessTypes();
        if (StringUtils.isNotBlank(bType))
            mapParam.put("workflowcodes",bType);
//        if(!(SessionUtil.getCurrentUserId().equals("0"))){
//        	mapParam.put("userIds", SessionUtil.getCurrentUserIds());
//            mapParam.put("workflowcodes",buildBusinessTypes());
//            mapParam.put("regionCode",this.getUserService().getUserRegionCode(SessionUtil.getUserId(ServletActionContext.getRequest())));
//        }
        //mapParam.put("userId", SessionUtil.getUserId(ServletActionContext.getRequest()));
        return mapParam;
    }

    /**
     * 将转入的btype（，号隔开，用‘’隔开，方便查询）
     * @return
     */
    private String buildBusinessTypes(){
        if (!StringUtils.isBlank(btypes)){
            String[] bTypeArray=StringUtils.split(btypes,",");
            StringBuffer sbTypes=new StringBuffer();
            for (String BType : bTypeArray) {
                    sbTypes.append("'" + BType + "',");
            }
            if (sbTypes.length()>0)
                return  sbTypes.toString().substring(0,sbTypes.toString().length()-1);
            else
                return null;
        }
        return null;
    }
	public String exceptionList() throws Exception{

		return "";
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public String getIbatisQueryName(){
		return "";
	}

	public PfConfigVo getConfigVo() {
		return configVo;
	}

	public void setConfigVo(PfConfigVo configVo) {
		this.configVo = configVo;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

    public String getBtypes() {
        return btypes;
    }

    public void setBtypes(String btypes) {
        this.btypes = btypes;
    }

    public SplitParam getSplitParam() {
		return splitParam;
	}

	public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
		return lstWorkFlowDefine;
	}

	public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
		this.lstWorkFlowDefine = lstWorkFlowDefine;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

    public List<PfBusinessVo> getBusinessList() {
        return businessList;
    }

    public void setBusinessList(List<PfBusinessVo> businessList) {
        this.businessList = businessList;
    }

    public List<Map> getActivityDefineList() {
        return activityDefineList;
    }

    public void setActivityDefineList(List<Map> activityDefineList) {
        this.activityDefineList = activityDefineList;
    }

    public String getWdid() {
        return wdid;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }

    public List<PfDistrictVo> getDisList() {
        return disList;
    }

    public void setDisList(List<PfDistrictVo> disList) {
        this.disList = disList;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public SysDistrictService getDistrictService() {
        return districtService;
    }
    public void setDistrictService(SysDistrictService districtService) {
        this.districtService = districtService;
    }

    public boolean isFilterRegioncode() {
        return filterRegioncode;
    }

    public void setFilterRegioncode(boolean filterRegioncode) {
        this.filterRegioncode = filterRegioncode;
    }

    public List<PfOrganVo> getOrganList() {
        return organList;
    }

    public void setOrganList(List<PfOrganVo> organList) {
        this.organList = organList;
    }

    public String getHandleStyle() {
        return handleStyle;
    }

    public void setHandleStyle(String handleStyle) {
        this.handleStyle = handleStyle;
    }

    public String getCanQueryTransUsers() {
        return canQueryTransUsers;
    }

    public void setCanQueryTransUsers(String canQueryTransUsers) {
        this.canQueryTransUsers = canQueryTransUsers;
    }
}
