package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.UserUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.HashMap;
import java.util.List;

public class TaskListAction extends TaskListActionAbstract {
    private static final String IBATIS_QUERY_NAME = "getTaskList";
    boolean hasExport = false; // 是否具有导出权限
    String taskState;
    SysAuthorService authorService;
    String rid;
    String userName;

    public String getUserName() {
        return userName;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }

    public SysAuthorService getAuthorService() {
        return authorService;
    }

    public boolean isHasExport() {
        return hasExport;
    }

    public void setHasExport(boolean hasExport) {
        this.hasExport = hasExport;
    }

    public String getTaskState() {
        return taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    @Override
    public String execute() throws Exception {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            this.hasExport=true;
        }else{
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions = authorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("导出")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("export")) {
                        this.hasExport = true;
                        break;
                    }
                }
            }
        }

        this.userName=SessionUtil.getCurrentUser().getUsername();
        return super.execute();
    }

    /**
     * 显示超期任务
     *
     * @return
     * @throws Exception
     */
    public String overtime() throws Exception {
        super.execute();
        SplitParamImpl splitParam1 = new SplitParamImpl();
        splitParam1.setQueryString(this.getIbatisQueryName());
        HashMap<String, String> mapParam = getParam();
        mapParam.put("TASK_STATE", "1");
        splitParam1.setQueryParam(mapParam);
        this.setSplitParam(splitParam1);
        this.taskState = "1";
        return Action.SUCCESS;
    }

    @Override
    public String getIbatisQueryName() {
        return IBATIS_QUERY_NAME;
    }

    /**
     * 待办任务的查询参数
     * 待办任务主要是userids和workflowcodes
     * @return
     */
    @Override
    public HashMap<String, String> getParam() {
        HashMap<String,String> mapParam= super.getParam();
        //设置userids
        UserUtil.setTaskUserMapIds(mapParam);
        //设置定义排序
        if (StringUtils.isNotBlank(AppConfig.getProperty("tasklisk.orderfield")))
            mapParam.put("_orderfield_",AppConfig.getProperty("tasklisk.orderfield"));

        return mapParam;    //To change body of overridden methods use File | Settings | File Templates.
    }

    /**
     * 代办任务列表
     *
     * @return
     */
    public String agent() {
        SplitParam splitParam = new SplitParamImpl();
        splitParam.setQueryString("getTaskAgentList");
        HashMap<String, Object> paramMap = new HashMap();
        List<PfTaskAgentVo> agentList = getUserService().getAgentUserList(SessionUtil.getCurrentUser().getId());
        if (agentList.isEmpty()) {
            paramMap.put("agentList", null);
        } else {
            paramMap.put("agentList", agentList);
        }
        splitParam.setQueryParam(paramMap);
        setSplitParam(splitParam);

        setLstWorkFlowDefine(getWorkFlowDefineService().getWorkFlowDefineList());
        if (getLstWorkFlowDefine() != null && getLstWorkFlowDefine().size() > 0) {
			if (!StringUtils.contains(getLstWorkFlowDefine().get(0).getWorkflowName(), "所有业务")) {
				PfWorkFlowDefineVo vo = new PfWorkFlowDefineVo();
		        vo.setWorkflowName("----所有业务----");
		        vo.setWorkflowDefinitionId("");
		        getLstWorkFlowDefine().add(0, vo);
			}
		}

        setBusinessList(getWorkFlowDefineService().getBusinessList());
        if (getBusinessList() != null && getBusinessList().size() > 0) {
			if (!StringUtils.contains(getBusinessList().get(0).getBusinessName(), "所有业务")) {
				PfBusinessVo pbv = new PfBusinessVo();
		        pbv.setBusinessName("----所有业务----");
		        pbv.setBusinessId("");
		        getBusinessList().add(0, pbv);
			}
		}

        configVo = SessionUtil.getUserConfig(ServletActionContext.getRequest());
        ServletActionContext.getRequest().setAttribute("USERID", SessionUtil.getUserId(ServletActionContext.getRequest()));

        return Action.SUCCESS;
    }
}
