package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.UserUtil;
import com.gtis.plat.wf.WorkFlowUtil;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SysResourceAction {
    String rid;
    SysMenuService menuService;
    SysTaskService taskService;
    SysWorkFlowInstanceService workFlowInstanceService;
    SysUserService sysUserService;
    String code;
    String taskid;
    String wiid;
    String resourceUrl;
    String from;
    String title;
    boolean disable = false;
    String handleType;//标示该页面是待办任务、已办任务、项目列表，分别对应task/taskover/project

    public String getTitle() {
        return title;
    }

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysWorkFlowInstanceService getWorkFlowInstanceService() {
        return workFlowInstanceService;
    }

    public void setWorkFlowInstanceService(
            SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String execute() throws Exception {
        if (StringUtils.isNotBlank(wiid)){
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowInstanceService.getWorkflowInstance(wiid);
            if (workFlowInstanceVo != null){
                ServletActionContext.getRequest().setAttribute("workflowState",workFlowInstanceVo.getWorkflowState());
            }
        }

        PfResourceVo resourceVo = null;
        if (code != null && !code.equals("")) {
            resourceVo = menuService.getResourceByCode(code);
            this.rid = resourceVo.getResourceId();
        } else{
            resourceVo = menuService.getResource(rid);
        }

        if (resourceVo != null) {
            this.title = resourceVo.getResourceName();
            if (resourceVo.getResourceType() == 1) { // 动态表单
                resourceUrl = "./form.action?dfid=" + rid;
                resourceUrl = resourceUrl + "&" + ServletActionContext.getRequest().getQueryString();
                ServletActionContext.getResponse().sendRedirect(resourceUrl);
                return Action.NONE;
            } else if (resourceVo.getResourceType() == 6) { // 表单查询
                resourceUrl = "./forms/fromQuery.action?id=" + rid;
                resourceUrl = resourceUrl + "&" + ServletActionContext.getRequest().getQueryString();
                ServletActionContext.getResponse().sendRedirect(resourceUrl);
                return Action.NONE;
            }else if(10 == resourceVo.getResourceType()) { //帆软报表
                ServletActionContext.getResponse().sendRedirect(handleResourceUrl(resourceVo.getResourceUrl()));
                return Action.NONE;
            }else {
                resourceUrl = resourceVo.getResourceUrl();
            }
            resourceUrl = handleResourceUrl(resourceUrl);
            if (!disable) {
                if (resourceUrl.indexOf("disable") > 0){
                    disable = true;
                }
            }
        }
        return Action.SUCCESS;
    }

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param resourceUrl 资源url
     * @return 处理后的url字符串
     * @description 对资源url进行处理，包括占位符，查询参数和行政区代码
     */
    private String handleResourceUrl(String resourceUrl){
        StringBuffer result = new StringBuffer(AppConfig.getPlaceholderValue(resourceUrl));
        if (result.indexOf("?") > 0) {
            result.append("&");
        } else {
            result.append("?");
        }
        String requestParam = ServletActionContext.getRequest().getQueryString();//;
        if (StringUtils.isNotBlank(requestParam) && StringUtils.contains(requestParam,"&EXTEND_PARAM&")){
            requestParam = requestParam.split("&EXTEND_PARAM&")[0];
            result.append(requestParam);
        }else{
            result.append(requestParam);
        }

        result.append("&pf_xzqdm=").append(SessionUtil.getCurrentUser().getRegionCode());
        //return result.toString();

        //转换为新的帆软地址：
        //http://localhost/report/ReportServer?
        // reportlet=com.fr.function.AnthorEgovCpt
        // &cpturl=\tdcbdkxx\cb_ydxz_qrtblsqb
        // &op=write
        // &cptName=cb_ydxz_qrtblsqb
        // &proid=14CD5729GQEFH102&from=task&wiid=14CD5729GQEFH102&taskid=14CD5729IVEFH105
        // &rid=291EB14222574F10B43AEB0B4294F68A&pf_xzqdm=321283
        // &userid=76419A8494064A8DAEAB8C12AA3D4DDC
        // &isProjectList=true&isAllDisable=true

        //原始帆软地址
        //http://localhost/report/ReportServer?
        // reportlet=tdcbdkxx/cb_ydxz_qrtblsqb.cpt
        // &op=write
        // &proid=14CD5729GQEFH102&from=task&wiid=14CD5729GQEFH102&taskid=14CD5729IVEFH105
        // &rid=291EB14222574F10B43AEB0B4294F68A&pf_xzqdm=321283

        //解析url参数，将参数转为map对象，之后通过freemarker方式，将url中的变量转换为对应的值
        Map<String,String> paramMap = new HashMap<String,String>();
        String[] paramAry =  ServletActionContext.getRequest().getQueryString().split("&");
        for(String keyvalue:paramAry){
            String[] pair = keyvalue.split("=");
            if(pair.length==2 && !StringUtils.contains(pair[1],"$")){
                paramMap.put(pair[0], pair[1]);
            }
        }
        String url = result.toString();
        if (StringUtils.contains(url,"${")){
            HashMap curUserMap = new HashMap();
            if (StringUtils.isNotBlank(wiid) && StringUtils.isNotBlank(taskid) && StringUtils.isNotBlank(handleType)){
                //根据任务id，获取当前任务的节点有哪些权限，把这些角色也作为当前地址的全局参数：
                List<String> activityRoleList = WorkFlowUtil.getActivityRolesByTaskId(taskid,taskService,workFlowInstanceService);
                curUserMap = UserUtil.initCurUserUrlMap(activityRoleList);
            }else {
                curUserMap = UserUtil.initCurUserUrlMap(null);
            }
            curUserMap.putAll(paramMap);
            url = UserUtil.freemarkerProcess(curUserMap,url);
        }

        //System.out.println(url);
        LinkedHashMap<String, String> param = getUrlParams(StringUtils.substringAfter(url,"?"));
        param.put("userid",SessionUtil.getCurrentUserId());
        String transUrl = MapUtils.getString(param,"transUrl");
        if (StringUtils.isBlank(transUrl) || !StringUtils.equalsIgnoreCase(transUrl,"false")){
            if (StringUtils.isNotBlank(handleType) && StringUtils.contains(url,"ReportServer?reportlet=") && !StringUtils.contains(url,"ReportServer?reportlet=com.fr.function.")){
                String[] urlAry = StringUtils.split(url,"?");
                if (param.containsKey("reportlet") && StringUtils.isNotBlank(param.get("reportlet"))){
                    String authorPath = AppConfig.getProperty("platform.finereport.author.path");
                    if (StringUtils.isNotBlank(authorPath)){
                        String reportlet = MapUtils.getString(param,"reportlet");
                        String cpturl = StringUtils.removeEndIgnoreCase(reportlet,".cpt");
                        cpturl = StringUtils.replace(cpturl,"%2F","/");

                        if (StringUtils.contains(cpturl,"/")){

                        }
                        String cptName = StringUtils.substringAfterLast(cpturl,"/");
                        if (StringUtils.isBlank(cptName)){
                            cptName = StringUtils.substringAfterLast(cpturl,"%2");
                        }
                        String[] cptPath = StringUtils.split(cpturl,"/");
                        cpturl = StringUtils.replace(cpturl,"/","\\");
                        cpturl = "\\"+cpturl;
                        param.put("reportlet",authorPath);
                        param.put("cpturl",cpturl);
                        param.put("cptName",cptName);
                    }
                }
                if (StringUtils.equalsIgnoreCase(handleType,"task")){
                    param.put("isProjectList","false");
                    param.put("isAllDisable","false");
                }else{
                    //针对已办任务和项目列表
                    //用过该资源的url地址配置了该参数，那就取url地址中的，如果没有配置，则默认全部都不可不编辑
                    if (!(param.containsValue("isAllDisable") && StringUtils.isNotBlank(param.get("isAllDisable")))){
                        param.put("isAllDisable","true");
                    }
                    param.put("isProjectList","true");
                }

                url = urlAry[0]+"?"+getUrlParamsByMap(param);
                //System.out.println(url);
                return url;//UserUtil.freemarkerProcess(param,url);
            }
        }

        return url;//UserUtil.freemarkerProcess(param,url);
    }

    /**
     * 将url参数转换成map
     * @param
     * @return
     */
    public static LinkedHashMap<String, String> getUrlParams(String link) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(0);
        if (StringUtils.isBlank(link)) {
            return map;
        }
        String[] params = link.split("&");
        for (int i = 0; i < params.length; i++) {
            String[] p = params[i].split("=");
            if (p.length == 2) {
                map.put(p[0], p[1]);
            }
        }
        return map;
    }

    /**
     * 将map转换成url
     * @param map
     * @return
     */
    public static String getUrlParamsByMap(LinkedHashMap<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = org.apache.commons.lang.StringUtils.substringBeforeLast(s, "&");
        }
        return s;
    }

    public String resource() throws Exception {
        if (StringUtils.isNotBlank(rid)){
            PfResourceVo resourceVo = menuService.getResource(rid);
            if (resourceVo == null){
                resourceVo = new PfResourceVo();
            }
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(resourceVo));
            return Action.NONE;
        }
        return null;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public SysMenuService getMenuService() {
        return menuService;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public String getProId() {
        if (wiid == null || wiid.equals("")) {
            PfTaskVo taskVo = taskService.getTask(taskid);
            if (taskVo == null)
                taskVo = taskService.getHistoryTask(taskid);
            PfActivityVo activityVo = taskService.getActivity(taskVo
                    .getActivityId());
            PfWorkFlowInstanceVo instanceVo = workFlowInstanceService
                    .getWorkflowInstance(activityVo.getWorkflowInstanceId());
            return instanceVo.getProId();
        }
        return "";
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isDisable() {
        return disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public String getHandleType() {
        return handleType;
    }

    public void setHandleType(String handleType) {
        this.handleType = handleType;
    }

    public SysUserService getSysUserService() {
        return sysUserService;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }
}
