package com.gtis.web.action;

import java.io.Reader;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.*;

import com.gtis.plat.dao.BaseDao;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.util.CalendarUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.EcExceptionVo;
import com.gtis.plat.vo.EcSupervisorVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;

public class SuperviseAction extends ActionSupport {
	private static final long serialVersionUID = -1332406189603283039L;
	
	private SysSupervisorService supervisorService;
	private SysActivityService activityService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
	private SysExceptionService sysExceptionService;
	private SysTaskService sysTaskService;
	private SysCollectExceptionService collectExceptionSe;
	private BaseDao baseDao;

	private EcSupervisorVo supervisorVo;
	private EcExceptionVo exceptionVo;
	private String workflowInstanceId;
	private String activityId;
	private String superId;
	private String supervisorExplain;
	List<PfWorkFlowDefineVo> lstWorkFlowDefine;
	private SysWorkFlowDefineService workFlowDefineService;	
	private String superInfo;//督办内容
	private String ids;//项目ID 集合用于对多个项目发送督办
	private SplitParam splitParam;
	private String[] users;

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    // 对多个项目 进行督办（领导发出）
	public String sendSuperActvityInfo() throws Exception {
		List<HashMap> activityInfoList = activityService.queryActivityDetailInfoById(supervisorVo.getWorkflowInstanceId());

		HashMap<String, List<HashMap>> dealMap = new HashMap<String, List<HashMap>>();
		for (HashMap map : activityInfoList) {
			String activityId = map.get("ACTIVITY_ID").toString();
			List<HashMap> activityList = dealMap.get(activityId);
			if (activityList == null) {
				activityList = new ArrayList<HashMap>();
			}
			map.put("leaf", true);
			if("1".equals(map.get("ACTIVITY_STATE").toString())){
				map.put("checked", false);
			}
			map.put("singleClickExpand", true);
			map.put("text", map.get("USER_NAME"));
			activityList.add(map);
			dealMap.put(activityId, activityList);
		}

		List<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();
		
		Set<Map.Entry<String,List<HashMap>>> dealIter = dealMap.entrySet();
		
		for(Map.Entry<String,List<HashMap>> entry : dealIter){
			HashMap<String, Object> activityMap = new HashMap<String, Object>();
			String activityId = entry.getKey();
			activityMap.put("children", entry.getValue());
			activityMap.put("singleClickExpand", true);
			activityMap.put("expanded", true);
			activityMap.put("cls", "folder");
			if("1".equals(entry.getValue().get(0).get("ACTIVITY_STATE").toString())){
				activityMap.put("checked", false);
			}
			activityMap.put("text", entry.getValue().get(0).get("ACTIVITY_NAME"));
			mapList.add(activityMap);
		}

		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(mapList));

		return Action.NONE;
	}

//	public String saveSuperInfo() throws Exception{
//		StringBuilder returnInfo = new StringBuilder();
//		for(String user : users){
//			HashMap map = (HashMap)JSONUtil.deserialize(user);
//			EcSupervisorVo supervisor = new EcSupervisorVo();
//			supervisor.setSupervisorInfoId(UUIDGenerator.generate());
//			supervisor.setActivityId(map.get("ACTIVITY_ID").toString());
//			supervisor.setSupervisorInfo(map.get("SUPERVISOR_INFO").toString());
//			supervisor.setWorkflowInstanceId(map.get("WORKFLOW_INSTANCE_ID").toString());
//			supervisor.setActivityId(map.get("ACTIVITY_ID").toString());
//			supervisor.setTargetId(map.get("USER_ID").toString());
//			supervisor.setTargetType(12);
//			supervisor.setSupervisorUserId(SessionUtil.getUserId(ServletActionContext.getRequest()));
//			supervisor.setSupervisorTime(new Date(System.currentTimeMillis()));
//			supervisorService.saveEcSupervisorVo(supervisor);
//		}
//
//		return Action.NONE;
//	}
	// 根据项目ID 获得其所有督办
	public String superListByInstanceId() throws Exception {
		List<HashMap> superLists = new ArrayList();
		HashMap temp = null;
		List<HashMap> stmp = this.supervisorService
				.statSupervisorByInstanceId(workflowInstanceId);
		for (HashMap map : stmp) {
			temp = new HashMap();
			if (map.get("ACTIVITY_NAME") == null) {
				temp.put("ACTIVITY_NAME", "");//项目督办
			} else {
				temp.put("ACTIVITY_NAME", map.get("ACTIVITY_NAME"));
			}
			if (map.get("USER_NAME") == null) {
				temp.put("USER_NAME", "系统督办");
			} else {
				temp.put("USER_NAME", map.get("USER_NAME"));
			}
			temp.put("SUPER_TIME", map.get("SUPERVISOR_TIME"));
			temp.put("SUPER_ID", map.get("SUPERVISORINFO_ID"));
			superLists.add(temp);
		}
		HashMap hash = new HashMap();
		hash.put("root", superLists);
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(
				JSONUtil.serialize(hash));
		return Action.NONE;
	}
	
	// 对多个项目 进行督办（领导发出），是针对工作流项目进行督办，而非对工作流的某个人的某个活动督办
	public String sendSuperInfo() throws Exception {

		StringBuilder Msg = new StringBuilder();
		if (StringUtils.isBlank(ids)) {
			return Action.NONE;
		} else {
			for (int i = 0; i < ids.split(",").length; i++) {
				String wiid = ids.split(",")[i];
				PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
				List<PfActivityVo> pfActivityVoList = sysTaskService.getWorkFlowInstanceActivityList(wiid);
				if (pfWorkFlowInstanceVo != null) {
					Date curDate = CalendarUtil.getCurHMDate();
					if (pfWorkFlowInstanceVo.getOverTime() != null) {
						boolean wfOver = false;//工作流是否超期
						if (pfWorkFlowInstanceVo.getOverTime().compareTo(curDate)<0) {
							wfOver = true;
						}
						if (wfOver) {
							List<EcExceptionVo> exceptionList = sysExceptionService.getEcExceptionByInstanceId(wiid);
							if (exceptionList == null || exceptionList.size() < 1) {
								EcExceptionVo exception = new EcExceptionVo();

								String ecId = UUIDGenerator.generate();
								// 实例化exception对象
								if(pfActivityVoList!=null&&pfActivityVoList.size()>0) {
									PfActivityVo tmpActivityVo = pfActivityVoList.get(0);
									List<PfTaskVo> taskList = sysTaskService.getTaskListByInstance(wiid);
									if (taskList != null && taskList.size() > 0) {
										PfTaskVo tmpTaskVo = taskList.get(0);
										exception.wftime_exception(ecId,wiid,tmpTaskVo.getUserVo().getUserId(),1, 
												null,null,
												tmpActivityVo.getTimeLimit(), tmpTaskVo.getOverTime(), tmpActivityVo.getBeginTime());
										exception.setUserId(tmpTaskVo.getUserVo().getUserId());
									}
									exception.setActivityId(tmpActivityVo.getActivityId());
								}else {
									exception.wftime_exception(ecId, wiid, null, 1,
											null, null, 
											pfWorkFlowInstanceVo.getTimeLimit(), pfWorkFlowInstanceVo.getOverTime(), pfWorkFlowInstanceVo.getCreateTime());
								}
								sysExceptionService.saveException(exception);
							}
						}
						HashMap param = new HashMap();
						param.put("WORKFLOW_DEFINITION_ID", wiid);
//						param.put("ACTIVITY_ID", "");
				        param.put("currentTime", Calendar.getInstance().getTime());
						List<HashMap> actitimeExceptions = baseDao.getHashMapListByIbatisStr(param, "collectActivityException");
						if (actitimeExceptions != null && actitimeExceptions.size() > 0) {
							for (int j = 0; j < actitimeExceptions.size(); j++) {// 遍历收集岗位异常信息
								HashMap activity = (HashMap) actitimeExceptions.get(j);
								HashMap acparam = new HashMap();
								acparam.put("WORKFLOW_DEFINITION_ID", wiid);
								acparam.put("ACTIVITY_ID", MapUtils.getString(activity, "ACTIVITY_ID"));
								List<EcExceptionVo> exceptionList = baseDao.getObjectListByIbatisStr(acparam, "getEcExceptionByMap");
//								List<EcExceptionVo> exceptionList = sysExceptionService.getEcExceptionByActivityId(MapUtils.getString(activity, "ACTIVITY_ID"));// 根据ACTIVITY_ID
								// 获取岗位异常信息
								if (exceptionList == null || exceptionList.size() == 0) {// 异常表中没有ACTIVITY_ID对应的记录
									// 就新增 岗位异常和督办
									EcExceptionVo exception = new EcExceptionVo();
									String orgin_id = null;
									if (activity.get("ORGAN_ID") == null) {
										orgin_id = "";
									} else {
										orgin_id = activity.get("ORGAN_ID").toString();
									}

									exception.actitime_exception(UUIDGenerator.generate(),
											wiid,MapUtils.getString(activity, "ACTIVITY_ID"),MapUtils.getString(activity, "USER_ID"), orgin_id, null,1, null, null,
											MapUtils.getString(activity, "USER_NAME"), MapUtils.getString(activity, "ACTIVITY_NAME"),MapUtils.getString(activity, "TIME_LIMIT"), 
											(Date)activity.get("OVER_TIME"), (Date) activity.get("BEGIN_TIME"));
									sysExceptionService.saveException(exception);
								}
							}
						}
					}
				}
				List<EcExceptionVo> workflowException = sysExceptionService.getEcExceptionByInstanceId(wiid);
				List<EcExceptionVo> activityException = sysExceptionService.getWorkflowActivityException(wiid);
				EcSupervisorVo ecSupervisorVo = null;
				if(workflowException!=null&&workflowException.size()>0){ //如果存在工作流超时异常,对所有在办的活动发起督办
					if(pfActivityVoList!=null&&pfActivityVoList.size()>0) {
						for (PfActivityVo pfActivityVo :pfActivityVoList){
							ecSupervisorVo = new EcSupervisorVo();
							ecSupervisorVo.setSupervisorInfoId(UUIDGenerator.generate());
							ecSupervisorVo.setSupervisorInfo(superInfo);
							ecSupervisorVo.setSupervisorTime(Calendar.getInstance().getTime());
							ecSupervisorVo.setActivityId(pfActivityVo.getActivityId());
							ecSupervisorVo.setWorkflowInstanceId(wiid);
							ecSupervisorVo.setExceptionId(workflowException.get(0).getExceptionId());
							ecSupervisorVo.setSupervisorUserId(SessionUtil.getCurrentUserId());
							ecSupervisorVo.setTargetType(EcSupervisorVo.WFINSTANCE_TYPE);
							supervisorService.saveEcSupervisorVo(ecSupervisorVo);
						}
					}
				}else if(activityException!=null&&activityException.size()>0){ //如果当前活动的节点存在超时异常，则对这些活动发起督办
					for(EcExceptionVo ecExceptionVo:activityException){
						ecSupervisorVo = new EcSupervisorVo();
						ecSupervisorVo.setSupervisorInfoId(UUIDGenerator.generate());
						ecSupervisorVo.setSupervisorInfo(superInfo);
						ecSupervisorVo.setSupervisorTime(Calendar.getInstance().getTime());
						ecSupervisorVo.setActivityId(ecExceptionVo.getActivityId());
						ecSupervisorVo.setWorkflowInstanceId(wiid);
						ecSupervisorVo.setExceptionId(ecExceptionVo.getExceptionId());
						ecSupervisorVo.setSupervisorUserId(SessionUtil.getCurrentUserId());
						ecSupervisorVo.setTargetType(EcSupervisorVo.ACTIVITY_TYPE);
						supervisorService.saveEcSupervisorVo(ecSupervisorVo);
					}
				}else{  //当前工作流不超期，当前活动节点不超时，则发起一般督办不与异常关联
					if(pfActivityVoList!=null&&pfActivityVoList.size()>0) {
						for (PfActivityVo pfActivityVo :pfActivityVoList){
							ecSupervisorVo = new EcSupervisorVo();
							ecSupervisorVo.setSupervisorInfoId(UUIDGenerator.generate());
							ecSupervisorVo.setSupervisorInfo(superInfo);
							ecSupervisorVo.setSupervisorTime(Calendar.getInstance().getTime());
							ecSupervisorVo.setActivityId(pfActivityVo.getActivityId());
							ecSupervisorVo.setWorkflowInstanceId(wiid);
							ecSupervisorVo.setSupervisorUserId(SessionUtil.getCurrentUserId());
							ecSupervisorVo.setTargetType(EcSupervisorVo.ACTIVITY_TYPE);
							supervisorService.saveEcSupervisorVo(ecSupervisorVo);
						}
					}
				}
				sysWorkFlowInstanceService.UpdateWorkFlowInstanceMonitor(wiid,"1");
			}
			if (Msg.toString().equals("")) {
				ServletActionContext.getResponse().getWriter().println(
						"{revertResult:true}");
			} else {
				Msg.deleteCharAt(Msg.length());
				ServletActionContext.getResponse().getWriter().println(
						"{revertResult:" + Msg.toString() + "}");
			}

		}
		return Action.NONE;
	}



//	public String sendSuperInfo() throws Exception {
//		StringBuilder Msg = new StringBuilder();
//		HashMap supervisorVo = null;
//		if (ids == null || ids.trim().equals("")) {
//			return Action.NONE;
//		} else {
//			String id = null;
//			Object obj = null;
//			for (int i = 0; i < ids.split(",").length; i++) {
//				supervisorVo = new HashMap();
//				supervisorVo.put("SUPERVISOR_INFO", superInfo);
//				supervisorVo.put("SUPERVISOR_TIME", new Date(System
//						.currentTimeMillis()));
//				supervisorVo.put("WORKFLOW_INSTANCE_ID", ids.split(",")[i]);
//				supervisorVo.put("SUPERVISOR_USERID", SessionUtil
//						.getUserId(ServletActionContext.getRequest()));
//				supervisorVo.put("TARGETTYPE", EcSupervisorVo.WFINSTANCE_TYPE);  //针对工作流项目进行督办，而非对工作流的某个人的某个活动督办
//				supervisorVo.put("TARGETID", ids.split(",")[i]);
//				supervisorVo.put("SUPERVISORINFO_ID", UUIDGenerator.generate());
//				supervisorService.saveEcSupervisorVoByLeader(supervisorVo);
//				/////插入项目实例表///////////////////////////
//				sysWorkFlowInstanceService.UpdateWorkFlowInstanceMonitor(supervisorVo.get("WORKFLOW_INSTANCE_ID").toString(),
//						supervisorVo.get("SUPERVISORINFO_ID").toString());
//				///////////////////////////////////////////
//				supervisorVo = null;
//			}
//			if (Msg.toString().equals("")) {
//				ServletActionContext.getResponse().getWriter().println(
//						"{revertResult:true}");
//			} else {
//				Msg.deleteCharAt(Msg.length());
//				ServletActionContext.getResponse().getWriter().println(
//						"{revertResult:" + Msg.toString() + "}");
//			}
//
//		}
//		return Action.NONE;
//	}
	
	/**
	 * 督办回复
	 * @return
	 * @throws Exception
	 */
	public String fillExplain()throws Exception{
		int isUpdate = supervisorService.fillEcSuperExplain(supervisorVo);
		
		HashMap<String,Object> hashMap = new HashMap<String,Object>();
		hashMap.put("revertResult", isUpdate);
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(hashMap));
		
		return Action.NONE;
	}

	/**
	 * 获得督办明细 根据督办ID
	 * @return
	 * @throws Exception
	 */
	public String superDetail() throws Exception {
		HashMap<String,Object> condition = new HashMap<String,Object>();
		condition.put("SUPERVISORINFO_ID", supervisorVo.getSupervisorInfoId());
		
		HashMap supe = this.supervisorService.queryEcSupervisorById(condition);
		HashMap result = new HashMap();
		String info = null;
		if(supe.get("EXCEPTION_TYPE") != null){
			info = descXML(supe);
		}else {
			if(supe.get("SUPERVISOR_INFO") != null){
				info = supe.get("SUPERVISOR_INFO").toString();
			}
		}
		result.put("SUPERVISOR_EXPLAIN", supe.get("SUPERVISOR_EXPLAIN"));
		result.put("TARGETTYPE", supe.get("TARGETTYPE"));
		result.put("INFO", info);
		result.put("currentUserId", SessionUtil.getUserId(ServletActionContext.getRequest()));
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(result));
		
		return Action.NONE;
	}

	/**
	 * 获得督办列表
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public String superviseDetailList() throws Exception {
		HashMap condition = new HashMap();
		condition.put("USER_ID", SessionUtil.getUserId(ServletActionContext.getRequest()));
		condition.put("ACTIVITY_ID", supervisorVo.getActivityId());
		condition.put("WORKFLOW_INSTANCE_ID", supervisorVo.getWorkflowInstanceId());
		
		List<HashMap> supervisorList = supervisorService.getSupervisorDetailList(condition);
		
		List<HashMap> result = new ArrayList();
		
		for (HashMap sup : supervisorList) {
			HashMap temp = new HashMap();
			
			temp.put("SOURC", sup.get("USER_NAME"));
			temp.put("SUPERVISORINFO_ID", sup.get("SUPERVISORINFO_ID"));
			temp.put("WORKFLOW_INSTANCE_NAME", sup.get("WORKFLOW_INSTANCE_NAME"));
			temp.put("ACTIVITY_NAME", sup.get("ACTIVITY_NAME"));
			temp.put("TARGETTYPE", sup.get("TARGETTYPE"));
			
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp.put("SUPERVISOR_TIME", sdf.format(sup.get("SUPERVISOR_TIME")));
			
			if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals(supervisorVo.getTargetId())){
				if(sup.get("TARGETTYPE") != null){
					if(!String.valueOf(EcSupervisorVo.ACTIVITY_TYPE).equals(sup.get("TARGETTYPE").toString()) && !String.valueOf(EcSupervisorVo.WFINSTANCE_TYPE).equals(sup.get("TARGETTYPE").toString())){
						continue;
					}
				}
			}
			result.add(temp);
		}
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(result));
		
		return Action.NONE;
	}


	public String descXML(HashMap source) throws Exception {
		int exceptionType = Integer.parseInt((source.get("EXCEPTION_TYPE").toString()));
		String exceptionRecTime = CommonUtil.formateDate((Date)source.get("EXCEPTION_REC_TIME"));
		if (source.get("DESC_XML") == null) {
			return "";
		}
		Clob descXmlClob = (Clob) source.get("DESC_XML");
		SAXReader reader = new SAXReader();
		Reader descXmlReader = descXmlClob.getCharacterStream();
		Document document = reader.read(descXmlReader);
		Element descDocument = document.getRootElement();// 得到根节点
		StringBuilder builder = new StringBuilder();
		if (exceptionType == 1) {
			String over_time = descDocument.attributeValue("over_time");
			String timeLimit = descDocument.attributeValue("time_limit");
			String beginTime = descDocument.attributeValue("begin_time");
			String outTime = descDocument.attributeValue("out_time");
			String userName = source.get("USER_NAME").toString();
			String activityName = descDocument.attributeValue("activity_name");
			builder.append(userName);
			builder.append("于");
			builder.append(beginTime);
			builder.append("接收到“");
			builder.append(activityName);
			builder.append("”办理，活动限时");
			builder.append(timeLimit);
			builder.append("天，活动截止办理时间为");
            builder.append(over_time);
            builder.append("，因其于");
			builder.append(exceptionRecTime);
			builder.append("尚未办理完成，活动办理超期");
			builder.append("，进行系统督办。");
		} else if (exceptionType == 2) {
			String beginTime = descDocument.attributeValue("begin_time");
			String timeLimit = descDocument.attributeValue("time_limit");
			String over_time = descDocument.attributeValue("over_time");
			String outTime = descDocument.attributeValue("out_time");

			builder.append("本项目于");
			builder.append(beginTime);
			builder.append("开始办理，流程限时");
			builder.append(timeLimit);
            builder.append("天，项目截止办理时间为");
            builder.append(over_time);
			builder.append("，因其于");
			builder.append(exceptionRecTime);
			builder.append("尚未办理完成，项目办理超期");
            builder.append("，进行系统督办。");
		} else if (exceptionType == 3) {
			String beginTime = descDocument.attributeValue("backtimes");
			builder.append("本活动被打回");
			builder.append(beginTime);
			builder.append("次，超过了允许的范围。");
		} else if (exceptionType == 4) {
			builder.append("该活动决定与其他办理人员意见不符。");
		} else if (exceptionType == 5) {
			String needFee = descDocument.attributeValue("needfee");
			String getFree = descDocument.attributeValue("getfee");
			builder.append("本项目应收费");
			builder.append(needFee);
			builder.append("，实收费");
			builder.append(getFree);
			builder.append("。");
		} else if (exceptionType == 6) {
			builder.append("该活动发生挂起异常。");
		} else if (exceptionType == 7) {
			String id = descDocument.attributeValue("id");
			builder.append(id);
		} else if (exceptionType == 8) {
			builder.append("无");
		}
		return builder.toString();
	}
	
	/**
	 * 显示当前登录人所有发出的督办信息 
	 * @return
	 * @throws Exception
	 */
	public String getReplySupervisor() throws Exception {
		SplitParamImpl splitParamImpl = new SplitParamImpl();
		splitParamImpl.setQueryString("getReplySupervisor");
		splitParam = splitParamImpl;
		HashMap user = new HashMap();
        if(!SessionUtil.getCurrentUser().isAdmin()) {
            user.put("USER_ID", SessionUtil.getCurrentUserId());
            splitParam.setQueryParam(user);
        }
		
		lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineList();
        if (lstWorkFlowDefine != null && lstWorkFlowDefine.size() > 0) {
			if (!StringUtils.contains(lstWorkFlowDefine.get(0).getWorkflowName(), "所有流程")) {
				PfWorkFlowDefineVo vo = new PfWorkFlowDefineVo();
		        vo.setWorkflowName("----所有流程----");
		        vo.setWorkflowDefinitionId("");
		        lstWorkFlowDefine.add(0, vo);
			}
		}
        
		return "replySupervisor";
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
		return lstWorkFlowDefine;
	}

	public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
		this.lstWorkFlowDefine = lstWorkFlowDefine;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public String getSuperInfo() {
		return superInfo;
	}
	public void setSuperInfo(String superInfo) {
		this.superInfo = superInfo;
	}
	public String getSuperId() {
		return superId;
	}

	public String getIds() {
		return ids;
	}
	public void setIds(String ids) {
		this.ids = ids;
	}
	public String getSupervisorExplain() {
		return supervisorExplain;
	}
	public void setSupervisorExplain(String supervisorExplain) {
		this.supervisorExplain = supervisorExplain;
	}
	public void setSuperId(String superId) {
		this.superId = superId;
	}

	public String getWorkflowInstanceId() {
		return workflowInstanceId;
	}

	public void setWorkflowInstanceId(String workflowInstanceId) {
		this.workflowInstanceId = workflowInstanceId;
	}

	public String getActivityId() {
		return activityId;
	}

	public void setActivityId(String activityId) {
		this.activityId = activityId;
	}

	public SysSupervisorService getSupervisorService() {
		return supervisorService;
	}

	public void setSupervisorService(SysSupervisorService supervisorService) {
		this.supervisorService = supervisorService;
	}

	public EcExceptionVo getExceptionVo() {
		return exceptionVo;
	}

	public void setExceptionVo(EcExceptionVo exceptionVo) {
		this.exceptionVo = exceptionVo;
	}

	public EcSupervisorVo getSupervisorVo() {
		return supervisorVo;
	}

	public void setSupervisorVo(EcSupervisorVo supervisorVo) {
		this.supervisorVo = supervisorVo;
	}

	public SysActivityService getActivityService() {
		return activityService;
	}

	public void setActivityService(SysActivityService activityService) {
		this.activityService = activityService;
	}

	public String[] getUsers() {
		return users;
	}

	public void setUsers(String[] users) {
		this.users = users;
	}

	public SysExceptionService getSysExceptionService() {
		return sysExceptionService;
	}

	public void setSysExceptionService(SysExceptionService sysExceptionService) {
		this.sysExceptionService = sysExceptionService;
	}

	public SysTaskService getSysTaskService() {
		return sysTaskService;
	}

	public void setSysTaskService(SysTaskService sysTaskService) {
		this.sysTaskService = sysTaskService;
	}

	public SysCollectExceptionService getCollectExceptionSe() {
		return collectExceptionSe;
	}

	public void setCollectExceptionSe(SysCollectExceptionService collectExceptionSe) {
		this.collectExceptionSe = collectExceptionSe;
	}

	public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
		return sysWorkFlowInstanceService;
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
}
