package com.gtis.web.action;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;

import com.gtis.plat.vo.PfWorkFlowPostVo;
import net.sf.ehcache.CacheManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.util.CalendarUtil;
import com.opensymphony.xwork2.Action;

public class ShowFlowRemarkAction {

	SysWorkFlowInstanceService workFlowInstanceService;
    SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService;
	SysTaskService taskService;
	SysWorkFlowDefineService workFlowDefineService;
	SysCalendarService calendarService;
	SysWorkFlowPostService sysWorkFlowPostService;
	SysUserService userService;
	String wiid;
	String taskid;
	List<PfActivityVo> activityList;
    List<Map<String,Object>> workFlowInstanceList;
	String flowTableOrder;
//	List<PfTaskVo> taskOverList;
//	List<PfTaskVo> taskList;
	static Log log = LogFactory.getLog(ShowFlowRemarkAction.class);
	boolean canClick = false;//节点是否可点击，主要用于点击节点，返回对应节点id和名称

	//#平台的人员是否按照岗位来处理，如果按照岗位，签名图片需要重复保存到签名表，不能使用id，并且工作流程图第三页列表上在现有人名基础上会显示对应办理人员的签名信息
	private String accrodJob;

	private String handleStyle;
	private CacheManager cacheManager;

	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public List<PfActivityVo> getActivityList() {
		return activityList;
	}

	public void setActivityList(List<PfActivityVo> activityList) {
		this.activityList = activityList;
	}

//	public List<PfTaskVo> getTaskOverList() {
//		return taskOverList;
//	}
//
//	public void setTaskOverList(List<PfTaskVo> taskOverList) {
//		this.taskOverList = taskOverList;
//	}
//
//	public List<PfTaskVo> getTaskList() {
//		return taskList;
//	}
//
//	public void setTaskList(List<PfTaskVo> taskList) {
//		this.taskList = taskList;
//	}

	public String execute() throws Exception {
		if (taskid != null && !taskid.equals("")) {
			PfTaskVo taskVo = taskService.getTaskAll(taskid);
			PfActivityVo activityVo = taskService.getActivity(taskVo
					.getActivityId());
			wiid = activityVo.getWorkflowInstanceId();
		}
		if(StringUtils.isNotBlank(flowTableOrder)&&"task".equals(flowTableOrder))
			activityList = taskService.getWorkflowInstanceActivityByTask(wiid);
		else
			activityList = taskService.getWorkFlowInstanceAllActivityList(wiid);

		if (activityList != null) {
			for (int i = 0; i < activityList.size(); i++) {
				PfActivityVo activityVo = activityList.get(i);
				Date finish = activityVo.getFinishTime();
				if (finish == null) {
					finish = CalendarUtil.getCurDate();
				}
				List<Date> dateList = calendarService.getWorkDateList(activityVo.getBeginTime(), finish);
				if (dateList != null) {
					activityVo.setHandlesDay(dateList.size());
				}

				/**
				 * 查找当前节点的挂起信息列表
				 */
				List<PfTaskVo> taskList = taskService.getTaskListByActivity(activityVo.getActivityId());
				if (taskList == null){
					taskList = new ArrayList<PfTaskVo>();
				}
				List<PfTaskVo> taskOverList = taskService.getHistoryTaskListByActivity(activityVo.getActivityId());
				if (taskOverList != null && !taskOverList.isEmpty()){
					taskList.addAll(taskOverList);
				}
				List<PfWorkFlowPostVo> postList = new ArrayList<PfWorkFlowPostVo>();
				if (taskList != null && !taskList.isEmpty()){
					for (int j = 0; j < taskList.size(); j++) {
						List<PfWorkFlowPostVo> tmpList = sysWorkFlowPostService.getPostByTask(taskList.get(j).getTaskId());
						if (tmpList != null && !tmpList.isEmpty()){
							postList.addAll(tmpList);
						}
					}
				}
				for (int k = 0; k < postList.size(); k++) {
					PfWorkFlowPostVo postVo = postList.get(k);
					postVo.setPostUser(userService.getUserVo(postVo.getPostUser()).getUserName());
				}
				activityVo.setExtensionMap(new HashMap());
				activityVo.getExtensionMap().put("postList",postList);
				activityVo.getExtensionMap().put("taskList",taskList);
				activityList.set(i, activityVo);
			}
		}
//		taskList = taskService.getTaskListByInstance(wiid);
//		taskOverList = taskService.getHistoryTaskListByInstance(wiid);
//		// 把办结任务中重复的人员去掉
//		List<String> taskIds = new ArrayList<String>();
//		for (PfActivityVo activityVo : activityList) {
//			String activityId = activityVo.getActivityId();
//			List<String> userIds = new ArrayList<String>();
//			for (PfTaskVo taskVo : taskOverList) {
//				if (taskVo.getActivityId().equals(activityId)) {
//					if (userIds.contains(taskVo.getUserVo().getUserId())) {
//						taskIds.add(taskVo.getTaskId());
//					} else {
//						userIds.add(taskVo.getUserVo().getUserId());
//					}
//				}
//			}
//			for (PfTaskVo taskVo : taskList) {
//				if (taskVo.getActivityId().equals(activityId)) {
//					if (userIds.contains(taskVo.getUserVo().getUserId())) {
//						taskIds.add(taskVo.getTaskId());
//						for (PfTaskVo taskVo1 : taskOverList) {
//							if (taskVo1.getActivityId().equals(activityId)
//									&& taskVo.getTaskId().equals(
//											taskVo.getUserVo().getUserId())) {
//								taskIds.add(taskVo1.getTaskId());
//							}
//						}
//					}
//				}
//			}
//		}
//		for (String taskId : taskIds) {
//			for (PfTaskVo taskVo : taskOverList) {
//				if (taskVo.getTaskId().equals(taskId)) {
//					taskOverList.remove(taskVo);
//                    break;
//				}
//			}
//		}
		PfWorkFlowInstanceVo pfWorkFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
		ServletActionContext.getRequest().setAttribute("workflowIntanceName", pfWorkFlowInstanceVo.getWorkflowIntanceName());
		return StringUtils.isNotBlank(flowTableOrder)&&"task".equals(flowTableOrder)?"task":Action.SUCCESS;
	}



    public String fullWorkflowChart() throws Exception {
        workFlowInstanceList = new ArrayList<Map<String,Object>>();
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
        getFullWorkflowList(pfWorkFlowInstanceVo);

		handleStyle = AppConfig.getProperty("portal.handle.style");
        Collections.sort(workFlowInstanceList, new Comparator<Map<String, Object>>() {
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return((Date)o1.get("createTime")).compareTo((Date)o2.get("createTime"));
            }
        });
        return "full";
    }

    private void getFullWorkflowList(PfWorkFlowInstanceVo pfWorkFlowInstanceVo){
        if(isExistWorkflow(pfWorkFlowInstanceVo))
            return;
        Map tmpWorkflowMap = new HashMap();
        tmpWorkflowMap.put("wiid",pfWorkFlowInstanceVo.getWorkflowIntanceId());
        tmpWorkflowMap.put("workflowIntanceName",pfWorkFlowInstanceVo.getWorkflowIntanceName());
        tmpWorkflowMap.put("workflowState",pfWorkFlowInstanceVo.getWorkflowState());
        tmpWorkflowMap.put("createTime",pfWorkFlowInstanceVo.getCreateTime());
        tmpWorkflowMap.put("finishTime",pfWorkFlowInstanceVo.getFinishTime());
        tmpWorkflowMap.put("handlesDay",pfWorkFlowInstanceVo.getHandlesDay());
        Date finish = pfWorkFlowInstanceVo.getFinishTime();
		if (finish == null) {
			finish = CalendarUtil.getCurDate();
		}
        List<Date> dateList = calendarService.getWorkDateList(pfWorkFlowInstanceVo.getCreateTime(), finish);
		if (dateList != null) {
			tmpWorkflowMap.put("handlesDay",dateList.size());
		}
        
        tmpWorkflowMap.put("workflowDefinitionName", workFlowDefineService.getWorkFlowDefine(pfWorkFlowInstanceVo.getWorkflowDefinitionId()).getWorkflowName());
        workFlowInstanceList.add(tmpWorkflowMap);
        List<PfWorkFlowInstanceVo> nextWorkflowInstanceList = sysWorkFlowInstanceRelService.getWorkFlowRelList(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        for(PfWorkFlowInstanceVo nextWorkflow:nextWorkflowInstanceList){
            getFullWorkflowList(nextWorkflow);
        }
    }

    private boolean isExistWorkflow(PfWorkFlowInstanceVo pfWorkFlowInstanceVo){
        for(Map workflow:workFlowInstanceList){
            if(workflow.get("wiid").equals(pfWorkFlowInstanceVo.getWorkflowIntanceId()))
                return true;
        }
        return false;
    }
    
    
    public String taskOverList() throws Exception {
		if (AppConfig.getBooleanProperty("platform.enforce.clear.cache",false)){
			cacheManager.clearAll();
		}

		accrodJob = AppConfig.getProperty("platform.user.accrod.job");
    	List<PfTaskVo> taskOverList = new ArrayList<PfTaskVo>();
    	if (StringUtils.isNotBlank(wiid)) {
    		taskOverList = taskService.getHistoryTaskListByInstance(wiid);
		}
		if (taskOverList == null) {
			taskOverList = new ArrayList<PfTaskVo>();
		}
		activityList = new ArrayList<PfActivityVo>();
		if (taskOverList != null) {
			for (int i = 0; i < taskOverList.size(); i++) {
				PfTaskVo taskVo = taskOverList.get(i);
				PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
                activityVo.setWorkflowInstanceId(wiid);
				activityVo.setOrganId(taskVo.getTaskId());
				activityVo.setBeginTime(taskVo.getBeginTime());
				activityVo.setFinishTime(taskVo.getFinishTime());
				Date finish = activityVo.getFinishTime();
				if (finish == null) {
					finish = CalendarUtil.getCurDate();
				}
				List<Date> dateList = calendarService.getWorkDateList(activityVo.getBeginTime(), finish);
				if (dateList != null) {
					activityVo.setHandlesDay(dateList.size());
				}
				activityVo.setRemark(taskVo.getRemark());
				activityVo.setOrganId(taskVo.getUserVo().getUserName());
                activityVo.setPriority(taskVo.getUserVo().getUserId());
				activityVo.setActivityBefore("正常流转");

				String back = "转发";
				List<PfTaskVo> volist = taskService.getTasksByBefore(taskVo.getTaskId());
				if (volist != null && volist.size() > 0) {
					for (int j = 0; j < volist.size(); j++) {
						if (volist.get(j).isBackState() || taskVo.isBackState()) {
							activityVo.setActivityBefore("退回");
							back = "<span style='color:red;'>退回</span>";
							break;
						}
					}
				}else{
					if (taskVo.isBackState()) {
						activityVo.setActivityBefore("退回");
						back = "<span style='color:red;'>退回</span>";
					}
				}
				String before = "";
				if (StringUtils.isNotBlank(taskVo.getTaskBefore())){
					PfTaskVo beforeTask = taskService.getTaskAll(taskVo.getTaskBefore());
					if (beforeTask != null){
						PfActivityVo beforeActivity = taskService.getActivity(beforeTask.getActivityId());
						if (beforeActivity != null){
							before += "<b>上一个节点：</b>"+beforeActivity.getActivityName()+"；<br>";
						}
						before += "<b>"+back+"人员：</b>"+beforeTask.getUserVo().getUserName()+"；";
					}
				}
				activityVo.setActivityBefore(before);

				List<PfWorkFlowPostVo> postList = sysWorkFlowPostService.getPostByTask(taskVo.getTaskId());
				if (postList == null){
					postList = new ArrayList<PfWorkFlowPostVo>();
				}
				for (int k = 0; k < postList.size(); k++) {
					PfWorkFlowPostVo postVo = postList.get(k);
					postVo.setPostUser(userService.getUserVo(postVo.getPostUser()).getUserName());
				}
				activityVo.setExtensionMap(new HashMap());
				activityVo.getExtensionMap().put("postList",postList);
				activityList.add(activityVo);
			}
		}
		PfWorkFlowInstanceVo pfWorkFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
		ServletActionContext.getRequest().setAttribute("workflowIntanceName", pfWorkFlowInstanceVo.getWorkflowIntanceName());
		Collections.sort(activityList, new Comparator() {
			public int compare(Object o1, Object o2) {
			return ((PfActivityVo)o1).getBeginTime().compareTo(((PfActivityVo)o2).getBeginTime());
			}
		});
		return "taskoverlist";
	}

	public SysWorkFlowInstanceService getWorkFlowInstanceService() {
		return workFlowInstanceService;
	}

	public void setWorkFlowInstanceService(
			SysWorkFlowInstanceService workFlowInstanceService) {
		this.workFlowInstanceService = workFlowInstanceService;
	}

	public String getWiid() {
		return wiid;
	}

	public void setWiid(String wiid) {
		this.wiid = wiid;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

    public List<Map<String, Object>> getWorkFlowInstanceList() {
        return workFlowInstanceList;
    }

    public void setWorkFlowInstanceList(List<Map<String, Object>> workFlowInstanceList) {
        this.workFlowInstanceList = workFlowInstanceList;
    }

    public SysWorkFlowInstanceRelService getSysWorkFlowInstanceRelService() {
        return sysWorkFlowInstanceRelService;
    }

    public void setSysWorkFlowInstanceRelService(SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService) {
        this.sysWorkFlowInstanceRelService = sysWorkFlowInstanceRelService;
    }

	public void setFlowTableOrder(String flowTableOrder) {
		this.flowTableOrder = flowTableOrder;
	}

	public boolean isCanClick() {
		return canClick;
	}

	public void setCanClick(boolean canClick) {
		this.canClick = canClick;
	}
	public SysCalendarService getCalendarService() {
        return calendarService;
    }

    public void setCalendarService(SysCalendarService calendarService) {
        this.calendarService = calendarService;
    }

	public String getAccrodJob() {
		return accrodJob;
	}

	public void setAccrodJob(String accrodJob) {
		this.accrodJob = accrodJob;
	}

	public String getFlowTableOrder() {
		return flowTableOrder;
	}

	public String getHandleStyle() {
		return handleStyle;
	}

	public void setHandleStyle(String handleStyle) {
		this.handleStyle = handleStyle;
	}

	public SysWorkFlowPostService getSysWorkFlowPostService() {
		return sysWorkFlowPostService;
	}

	public void setSysWorkFlowPostService(SysWorkFlowPostService sysWorkFlowPostService) {
		this.sysWorkFlowPostService = sysWorkFlowPostService;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

	public CacheManager getCacheManager() {
		return cacheManager;
	}

	public void setCacheManager(CacheManager cacheManager) {
		this.cacheManager = cacheManager;
	}
}
