package com.gtis.web.action;

import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.wf.UserUtil;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ProjectListAction extends TaskListActionAbstract {

	String IBATIS_QUERY_NAME = "getProjectList";
    boolean hasDel = false; // 是否具有删除权限
    boolean hasRestart = false;
    boolean moreSelect = false;
    String state;
    String rid;
    SysAuthorService authorService;
    SysMenuService menuService;

    public SysMenuService getMenuService() {
        return menuService;
    }

    public boolean isHasRestart() {
        return hasRestart;
    }

    public void setHasRestart(boolean hasRestart) {
        this.hasRestart = hasRestart;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public SysAuthorService getAuthorService() {
        return authorService;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public boolean isHasDel() {
        return hasDel;
    }

    public void setHasDel(boolean hasDel) {
        this.hasDel = hasDel;
    }

    @Override
    public String execute() throws Exception {
        this.hasDel=false;
        this.hasRestart = false;
        super.execute();
        if (SessionUtil.getUserInfo(ServletActionContext.getRequest()).isAdmin()) {
            this.hasDel=true;
            this.hasRestart = true;
        }else{
            //根据授权判断是否有列表删除权限
            String roles = SessionUtil.getUserInfo(ServletActionContext.getRequest()).getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions=authorService.getSystemResrouceFunAuthorList(roles,rid);
            if (lstfPartitions!=null){
                for (PfPartitionInfoVo partitionInfoVo:lstfPartitions){
                    if (partitionInfoVo.getElementName().endsWith("删除")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("del")){
                        this.hasDel=true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo:lstfPartitions){
                    if (partitionInfoVo.getElementName().endsWith("重办")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("restart")){
                        this.hasRestart=true;
                        break;
                    }
                }
            }
            //获取可以查看项目的列表
            HashMap<String,String> mapParam= (HashMap<String,String>)this.getSplitParam().getQueryParam();
            List<String> listWdids=this.menuService.getProjectWorkFlowDefineIds(roles);
            StringBuffer bufferWdids=new StringBuffer("''");
            if (listWdids!=null){
                for(int index = 0; index < listWdids.size(); index ++){
                    bufferWdids.append(",");
                    bufferWdids.append("'" + listWdids.get(index) + "'");
                }
            }
            mapParam.put("wdids",bufferWdids.toString());
        }
        return Action.SUCCESS;
    }
    
    /**
     * 打开项目选择页面，提供多选、单选和工作流状态参数
     * 主要用于业务系统调用工作流项目列表中的项目信息
     */
    public String selectProjectList() throws Exception{
    	execute();
		if (StringUtils.isNotBlank(state)) {
			HashMap<String,String> mapParam= (HashMap<String,String>)this.getSplitParam().getQueryParam();
			mapParam.put("STATE", state);
		}
    	
    	return "projectselectlist";
    }

    /**
     * 由当前用户创建的项目
     * @return
     * @throws Exception
     */
    public String viewbycreator()throws Exception{
        this.IBATIS_QUERY_NAME="getProjectListByCreater";
        this.execute();
        HashMap<String,String> mapParam= (HashMap<String,String>)this.getSplitParam().getQueryParam();
        mapParam.put("CREATE_USER",SessionUtil.getCurrentUserId());
        mapParam.put("wdids",null);
        mapParam.put("regionCode",null);
        return Action.SUCCESS;
    }

    /**
     * 由当前用户参与审批的项目
     * @return
     * @throws Exception
     */
    public String viewbyperformer()throws Exception{
        this.IBATIS_QUERY_NAME="getProjectListByPerformer";
        this.execute();
        HashMap<String,String> mapParam= (HashMap<String,String>)this.getSplitParam().getQueryParam();
        mapParam.put("USER_ID",SessionUtil.getCurrentUserId());
        mapParam.put("wdids",null);
        mapParam.put("regionCode",null);
        return Action.SUCCESS;
    }

    /**
     * 根据用户的regioncode查找，不用like
     * @return
     * @throws Exception
     */
    public String viewbyregioncode() throws Exception{
        this.IBATIS_QUERY_NAME="getProjectListByRegionCode";
        this.execute();
        return Action.SUCCESS;
    }
    @Override
    public String rss() throws Exception {
        String result= super.rss();

		return result;
    }

    /**
     * 项目列表的查询参数
     * 待办任务主要是userids、workflowcodes和regionCode
     * 另外还有一个条件是权限
     * @return
     */
    @Override
    public HashMap<String,String> getParam() {
        HashMap<String,String> params = super.getParam();
        String roles = SessionUtil.getUserInfo(ServletActionContext.getRequest()).getRoleIds();
        if (StringUtils.isNotBlank(roles)){
            List<String> listWdids=this.menuService.getProjectWorkFlowDefineIds(roles);
            StringBuilder builderWdids=new StringBuilder("''");
            for(int index = 0; index < listWdids.size(); index ++){
                builderWdids.append(",");
                builderWdids.append("'" + listWdids.get(index) + "'");
            }
            params.put("wdids",builderWdids.toString());
        }
        //获取当前人员所属部门的行政区代码
        List<PfOrganVo> organList = SessionUtil.getCurrentUser().getLstOragn();
        if (organList != null && organList.size() > 0){
            String regionCodes = "''";
            HashMap<String,String> regionMap = new HashMap<String, String>();
            for (int i = 0; i < organList.size(); i++) {
                regionMap.put(organList.get(i).getRegionCode(),organList.get(i).getRegionCode());
            }

            for(Map.Entry<String,String> entry : regionMap.entrySet()){
                regionCodes += ",'"+entry.getKey()+"'";
            }
            params.put("REGION_CODES",regionCodes);
        }
        //params.put("regionCode",this.getUserService().getUserRegionCode(SessionUtil.getCurrentUserId()));
        return params;
    }
    
    @Override
	public String getIbatisQueryName() {
		return IBATIS_QUERY_NAME;
		
	}

	public boolean isMoreSelect() {
		return moreSelect;
	}

	public void setMoreSelect(boolean moreSelect) {
		this.moreSelect = moreSelect;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

}
