package com.gtis.web.action;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;

import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.ResourceModel;
import com.gtis.util.CalendarUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ProjectHandleAction {
    String proid;
    String wiid;
    String wdno;
    SysTaskService taskService;
    SysWorkFlowInstanceService workFlowIntanceService;
    SysWorkFlowDefineService workFlowDefineService;
    SysMenuService menuService;
    NodeService nodeService;   //用来获取附件

    PfWorkFlowInstanceVo workFlowInstanceVo;
    PfWorkFlowDefineVo workFlowDefineVo;
    String menu;
    boolean disable = true;
    private static final String CONTENT_TYPE = "text/html; charset=utf-8";
    private String fileTokenId;   //文件中心用tokenid
    private int fileCenterNodeId;
    //勘测定界扩展属性配置
    private String kcdjTypeConfig;
    private String busiType;

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public String getActivityNames() throws Exception{
        StringBuffer userNameBuffer=new StringBuffer();
        if (StringUtils.isNotBlank(wiid)) {
            List<PfActivityVo> activityVoList= taskService.getWorkFlowInstanceActivityList(wiid);
            for (int i = 0; i < activityVoList.size(); i++) {
                if (i>0) {
                    userNameBuffer.append(";");
                }
                try {
                    PfActivityVo activityVo = activityVoList.get(i);
                    userNameBuffer.append(activityVo.getActivityName());
                    String projectShowTime= AppConfig.getProperty("projectlist.activityName.otherTime.show");
                    if(org.apache.commons.lang3.StringUtils.equals(projectShowTime,"true")) {
                        List<PfTaskVo> taskList = taskService.getTaskListByActivity(activityVo.getActivityId());
                        if (taskList != null && taskList.size() > 0) {
                            PfTaskVo taskVo = taskList.get(0);
                            if (taskVo.getOverTime().compareTo(CalendarUtil.getCurDate()) < 0) {
                                userNameBuffer.append("已超期");
                            } else {
                                long days = CalendarUtil.getDaysByTwoDate(CalendarUtil.getCurDate(), taskVo.getOverTime());
                                userNameBuffer.append("剩余" + days + "天");
                            }
                        }
                        if (i > 0) {
                            userNameBuffer.append("...");
                            break;
                        } else {
                            userNameBuffer.append("");
                        }
                    }
                }catch (Exception ex){}
            }
        }
        ServletActionContext.getResponse().getWriter().println(userNameBuffer.toString());
        return Action.NONE;
    }

    public String execute() throws Exception {
        if (wiid != null && !wiid.equals("")) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
        } else {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
        }
        if (workFlowInstanceVo!=null){
            workFlowDefineVo= workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            wiid = workFlowInstanceVo.getWorkflowIntanceId();
        }else if(StringUtils.isNotBlank(wdno)){
            workFlowDefineVo= workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        if (workFlowDefineVo==null){
            ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
            ServletActionContext.getResponse().getWriter().println("工作流异常，请检查工作流定义！");
            return Action.NONE;
        }
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
        this.disable = xmlDao.isDisable();
        ///////客户端用来获取附件////////////////////////////////////////
        Space space = nodeService.getWorkSpace(StuffManageAction.WORK_FLOW_STUFF, true);
        try {
            Node node=null;
            if (StringUtils.isBlank(wiid))
                node = nodeService.getNode(space.getId(), proid, true);
            else
                node = nodeService.getNode(space.getId(), wiid, false);
            if (node != null) {
                fileTokenId = nodeService.getToken(node);
                fileCenterNodeId = node.getId();
            }
        } catch (Exception ex) {

        }
        ////////////////////////////////////////////////////////////
        //扩展属性中关于勘测定界管理模块的配置属性获取
        kcdjTypeConfig = xmlDao.getExtendedAttribute("KcdjTypeConfig") + "";
        busiType = xmlDao.getExtendedAttribute("BusiType") + "";
        if (StringUtils.isBlank(busiType)) {
            busiType = xmlDao.getExtendedAttribute("busiType") + "";
        }
        return Action.SUCCESS;
    }

    public String menu() throws Exception {
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
        HttpServletResponse response = ServletActionContext.getResponse();

        String roles = SessionUtil.getUserInfo(ServletActionContext.getRequest()).getRoleIds();
        if (wiid != null && !wiid.equals("")) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
        } else {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
        }
        if (workFlowInstanceVo!=null){
            workFlowDefineVo= workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
        }else if(StringUtils.isNotBlank(wdno)){
            workFlowDefineVo= workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        List<PfResourceVo> lstResult = menuService.getProjectMenu(roles,workFlowDefineVo.getWorkflowDefinitionId());

        String resources = "";
        /**
         * 此处主要是存放已经插入的菜单，如果存在id和name相同的资源，则不再重复插入
         */
        HashMap<String, String> insertedMenuMap = new HashMap<String, String>();
        if (lstResult != null) {
            //<Resources>
            // <Resource Id="914BC82E837940A18931C0C8023594C5" Name="收件单" Type="5" Visible="true"/>
            // </Resources>
            Element rowDataElement = DocumentHelper.createElement("Resources");
            for (int i = 0; i < lstResult.size(); i++) {
                PfResourceVo menuVo = lstResult.get(i);
                String tempKey = menuVo.getResourceId() + "_" + menuVo.getResourceName();
                if (insertedMenuMap.get(tempKey) != null) {
                    continue;
                }
                insertedMenuMap.put(tempKey, tempKey);

                Element rowElement = DocumentHelper.createElement("Resource");
                rowElement.addAttribute("Id", menuVo.getResourceId());
                rowElement.addAttribute("Name", menuVo.getResourceName());
                rowElement.addAttribute("Type", "5");
                rowElement.addAttribute("Visible", "true");
                rowDataElement.add(rowElement);
            }
            resources = rowDataElement.asXML();
        }
        boolean acmenu = AppConfig.getBooleanProperty("workflow.project.handle.activity.menu",false);
        if ((lstResult == null || lstResult.isEmpty()) && acmenu){
            resources = getActivityMenu();
        }
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/xml");
        response.getWriter().println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        response.getWriter().println(resources);
        return Action.NONE;
    }

    /**
     * 获取节点menu
     * #项目管理中菜单的调用是否需要采用工作流定义的节点菜单，而非工作流实例菜单
     #如果配置为true，则无权限控制，仅仅是方便查看，减少配置
     #处理逻辑：优先当前活动菜单，其次办结节点，最后开始节点菜单
     * @return
     * @throws Exception
     */
    public String getActivityMenu() {
        if (StringUtils.isBlank(proid)){
            proid = wiid;
        }
        if (StringUtils.isNotBlank(proid)) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(proid);
            if (workFlowInstanceVo != null) {
                ActivityModel aModel = null;
                WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
                List<PfTaskVo> taskList = taskService.getTaskListByInstance(proid);
                if (taskList != null && taskList.size() > 0) {
                    PfTaskVo taskVo = taskList.get(0);
                    PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
                    aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
                } else {
                    String acdId = xmlModel.getEndActivityDefine();
                    aModel = xmlModel.getActivity(acdId);
                    if (!(aModel != null && aModel.getResourceList() != null && aModel.getResourceList().size() > 0)) {
                        acdId = xmlModel.getBeginActivityDefine();
                        aModel = xmlModel.getActivity(acdId);
                    }
                }
                return aModel.getResources();
            }
        }
        return "<Resources/>";
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public String getFileTokenId() {
        return fileTokenId;
    }

    public int getFileCenterNodeId() {
        return fileCenterNodeId;
    }

    public boolean isDisable() {
        return disable;
    }

    public String getMenu() {
        return menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }

    public SysWorkFlowInstanceService getWorkFlowIntanceService() {
        return workFlowIntanceService;
    }

    public void setWorkFlowIntanceService(
            SysWorkFlowInstanceService workFlowIntanceService) {
        this.workFlowIntanceService = workFlowIntanceService;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return workFlowDefineService;
    }

    public void setWorkFlowDefineService(
            SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public PfWorkFlowInstanceVo getWorkFlowInstanceVo() {
        return workFlowInstanceVo;
    }

    public void setWorkFlowInstanceVo(PfWorkFlowInstanceVo workFlowInstanceVo) {
        this.workFlowInstanceVo = workFlowInstanceVo;
    }

    public PfWorkFlowDefineVo getWorkFlowDefineVo() {
        return workFlowDefineVo;
    }

    public void setWorkFlowDefineVo(PfWorkFlowDefineVo workFlowDefineVo) {
        this.workFlowDefineVo = workFlowDefineVo;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public SysMenuService getMenuService() {
        return menuService;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public String getKcdjTypeConfig() {
        return kcdjTypeConfig;
    }

    public void setKcdjTypeConfig(String kcdjTypeConfig) {
        this.kcdjTypeConfig = kcdjTypeConfig;
    }

    public String getBusiType() {
        return busiType;
    }

    public void setBusiType(String busiType) {
        this.busiType = busiType;
    }

    public String getWdno() {
        return wdno;
    }

    public void setWdno(String wdno) {
        this.wdno = wdno;
    }
}
