package com.gtis.web.action;

import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.UserUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;

import org.apache.struts2.ServletActionContext;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 活动监察列表
 */
public class ProjectActivityListAction{
    /** 分页 */
    private SplitParam splitParam;
    /** 业务列表 */
    private List<PfBusinessVo> businessList;
    /** 工作流定义服务 */
    private SysWorkFlowDefineService workFlowDefineService;
    /** 工作流定义列表 */
    private List<PfWorkFlowDefineVo> lstWorkFlowDefine;
    private List<Map> activityDefineList;

    public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
        return lstWorkFlowDefine;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public List<PfBusinessVo> getBusinessList() {
        return businessList;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    /**
     * 异常在办活动监察列表
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        HashMap<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("chk_chaoqi","0");
        mapParam.put("chk_banli","0");
        mapParam.put("chk_isOffSite","0");
        mapParam.put("currentTime", Calendar.getInstance().getTime());

        SplitParamImpl splitParam1=new SplitParamImpl();
        splitParam1.setQueryString("getProjectActiviyList");
        splitParam1.setQueryParam(mapParam);
        splitParam=splitParam1;


        businessList = workFlowDefineService.getBusinessSimpleList();
        PfBusinessVo pbv = new PfBusinessVo();
        pbv.setBusinessName("----所有业务----");
        pbv.setBusinessId("");
        businessList.add(0,pbv);

        lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineList();
        PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
        vo.setWorkflowName("----所有流程----");
        vo.setWorkflowDefinitionId("");
        lstWorkFlowDefine.add(0, vo);
        
        activityDefineList = new ArrayList<Map>();
        Map activityMap = new HashMap();
        activityMap.put("activityName","");
        activityMap.put("activityValue", "");
        activityDefineList.add(0, activityMap);

        return Action.SUCCESS;
    }

	public List<Map> getActivityDefineList() {
		return activityDefineList;
	}

	public void setActivityDefineList(List<Map> activityDefineList) {
		this.activityDefineList = activityDefineList;
	}


}
