package com.gtis.web.action;

import com.gtis.common.util.TokenUtils;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.util.CookieGenerator;
import javax.servlet.http.HttpServletResponse;

/**
 * 一张图与政务平台跳转
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/12/15
 */
public class OnemapAction {
    private String url;
    private static final String EGOV_TOKEN="_egov";

    public String execute() throws Exception{
        HttpServletResponse response = ServletActionContext.getResponse();
        if(StringUtils.isNotBlank(SessionUtil.getCurrentUserId())) {
            CookieGenerator generator = new CookieGenerator();
            generator.setCookieName(EGOV_TOKEN);
            generator.addCookie(response, TokenUtils.encrypt(SessionUtil.getCurrentUserId()));
        }
        response.sendRedirect(response.encodeRedirectURL(url));
        return Action.NONE;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
