package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysNewsService;
import com.gtis.plat.vo.PfNewsVo;
import com.gtis.util.htmltagExtract;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import oracle.sql.CLOB;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class NewsManageAction extends ActionSupport implements ServletResponseAware {
	private static final long serialVersionUID = -8927776759684553440L;
	
	private SysNewsService newsService;
	HttpServletResponse response;
	private NodeService nodeService;
	private SplitParam splitParam;
	private PfNewsVo pnv;
	private List<PfNewsVo> newsList;
	
	private String type;
	private String flag;
	private String[] newsIds;
	private String config;
	private HashMap newsInfo;
	private Integer nodeId;
	private String token;
	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
	
	private static final String FCKEDIT_STUFF = NewsManageAction.class.getName();
	
	/**
	 * 获得新闻列表
	 */
	public String execute() throws Exception {
		splitParam = new SplitParamImpl();
		splitParam.setQueryString("getNewListByType");
		HashMap params = new HashMap();
		params.put("NEW_TYPE", type);
		splitParam.setQueryParam(params);
		
		return Action.SUCCESS;
	}

	/**
	 * 删除新闻
	 * @return
	 * @throws Exception
	 */
	public String del() throws Exception{
		for(String newsId:newsIds){
			newsService.deleteNews(newsId);
		}
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(true);
		
		return Action.NONE;
	}
	
	/**
	 * 新建新闻
	 * @return
	 * @throws Exception
	 */
	public String newNews() throws Exception{
		Space space = nodeService.getWorkSpace(FCKEDIT_STUFF,true);
		
		Node newsNode = null;
		if(pnv.getNewsId() == null || "".equals(pnv.getNewsId())){
			pnv.setNewsId(UUIDGenerator.generate());
			pnv.setNewsDate(new Date());
            String userName=SessionUtil.getCurrentUser().getUsername();
            pnv.setNewsAuthor(userName);
            pnv.setNewPublisher(userName);
		}else {
			pnv = newsService.getNewsById(pnv.getNewsId());
		}

		newsNode = nodeService.getNode(space.getId(), pnv.getNewsId(),true);

		String path = CommonUtil.getCurrStrDate();
		String token = nodeService.getToken(newsNode);
		int nodeId = newsNode.getId();
		
		HashMap<String,Object> map = new HashMap<String,Object>();
		map.put("token", token);
		map.put("nodeId", nodeId);
		map.put("path", path);
		map.put("news", pnv);
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(map));
		
		return Action.NONE;
	}

	/**
	 * 进入编辑界面
	 * @return
	 * @throws Exception
	 */
	public String entryNews() throws Exception{
		return "edit";
	}

    public String removeTrim(String resource)
    {
        StringBuffer buffer=new StringBuffer();
        int position=0;
        char currentChar;

        while(position<resource.length())
        {
            currentChar=resource.charAt(position++);
            if(currentChar!=160&&currentChar!=32)    buffer.append(currentChar);
        }
        return buffer.toString();
    }

	/**
	 * 保存新闻
	 * @return
	 * @throws Exception
	 */
	public String saveNews() throws Exception{
		HashMap<String,Object> condition = (HashMap<String,Object>) JSONUtil.deserialize(config);
		PfNewsVo newsVo = new PfNewsVo();
		if(condition.get("newsId") != null){
			newsVo.setNewsId("" + condition.get("newsId"));
		}
		if(condition.get("newsTitle") != null){
			newsVo.setNewsTitle("" + condition.get("newsTitle"));
		}
		if(condition.get("newsDate") != null){
            String newsDate = condition.get("newsDate").toString();
            newsDate = newsDate.replace('T',' ');//去除日期格式中的T字符
			newsVo.setNewsDate(CommonUtil.formateDateToStr(newsDate));
		}
		
		if(condition.get("type") != null){
			newsVo.setNewsType("" + condition.get("type"));
		}
		if(condition.get("newsContent") != null){
            String content = condition.get("newsContent").toString().trim();
			newsVo.setNewsContent("" + content);
		}
		if(condition.get("newsSummary") != null){
			newsVo.setNewsSummary("" + condition.get("newsSummary"));
		}
		if(condition.get("imageUrl") != null){
            newsVo.setImageUrl("" + condition.get("imageUrl"));
        }
        if(condition.get("newsAuthor") != null){
            newsVo.setNewsAuthor("" + condition.get("newsAuthor"));
        }
        if(condition.get("newPublisher") != null){
            newsVo.setNewPublisher("" + condition.get("newPublisher"));
        }
		if("new".equals(flag)){
			//newsVo.setNewsAuthor(SessionUtil.getUserId(ServletActionContext.getRequest()));
			newsService.insertNews(newsVo);
		}else if("update".equals(flag)){
			newsService.updateNews(newsVo);
		}
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(true);
		
		return Action.NONE;
	}
	
	/**
	 * 新闻页面
	 * @return
	 * @throws Exception
	 */
	public String viewEnterDetail() throws Exception{
		newsInfo = newsService.getNewsInfoById(pnv.getNewsId());
        if (newsInfo.get("NEW_CONTENT")!=null){
            CLOB contentClob = (CLOB) newsInfo.get("NEW_CONTENT");
            if(contentClob != null){
                newsInfo.put("NEW_CONTENT", clob2string(contentClob));
            }else {
                newsInfo.put("NEW_CONTENT", "");
            }
        }
		Space space = nodeService.getWorkSpace(FCKEDIT_STUFF,true);
		Node newsNode = nodeService.getNode(space.getId(), pnv.getNewsId(),true);
		
		nodeId = newsNode.getId();
		token = this.nodeService.getToken(newsNode);
		return "detail";
	}
	
	//处理哈尔滨电子政务系统新闻图片和新闻内容之间的链接
	public String getHrefAndImageUrl() throws IOException, JSONException{
		String newsContent="";
		String imageUrl="";
		HashMap<String,String> resultObj = new HashMap<String,String>();
		List<HashMap<String,String>> UrlList=new ArrayList<HashMap<String,String>>();
		//构造地址
		String host = ServletActionContext.getRequest().getServerName();
		String port =   ServletActionContext.getRequest().getServerPort() + "";
		String context = ServletActionContext.getRequest().getContextPath();
		String httpurl = "http://" + host +":"+ port;
		String contextUrl = "http://" + host +":"+ port + context;
		//获取新闻记录list
		newsList=newsService.getNewsList();
		if(newsList.size()>0){
			for(int i=0;i<this.newsList.size();i++){
				newsContent=newsList.get(i).getNewsContent();
				imageUrl=htmltagExtract.getImageUrl(newsContent);
				if(imageUrl.equals(""))
					continue;
				else{
					if(imageUrl.indexOf("&#63;")>-1){
						imageUrl=imageUrl.replace("&#63;","?");
					}
					resultObj = new HashMap<String,String>();
					resultObj.put("imageUrl",httpurl+imageUrl);
					resultObj.put("hrefUrl",contextUrl+"/news!viewEnterDetail.action?pnv.newsId="+newsList.get(i).getNewsId());
					UrlList.add(resultObj);
					
				}
			}
		}
		
		response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
        out.println(JSONUtil.serialize(UrlList));
		out.flush();
		out.close();
		return Action.NONE;
	}
	
	/**   
	* CLOB转换为STRING处理
	*/   
	public static String clob2string(CLOB   c) {     
		StringBuffer sb = new StringBuffer(1024);   
		Reader instream = null;   
		try{   
			instream = c.getCharacterStream();   
			char[] buffer = new char[(int)c.length()];   
			int length = 0;   
			while ((length = instream.read(buffer)) != -1){   
				sb.append(buffer);   
			}   
		}catch(Exception ex){   
			ex.printStackTrace();   
		}finally{   
			try{   
				if(instream != null){
					instream.close();   
				}
			}catch(Exception   dx){   
				instream = null;   
			}
			return sb.toString();   
		}   
	}
	
	public SysNewsService getNewsService() {
		return newsService;
	}

	public void setNewsService(SysNewsService newsService) {
		this.newsService = newsService;
	}

	public NodeService getNodeService() {
		return nodeService;
	}

	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}

	public PfNewsVo getPnv() {
		return pnv;
	}

	public void setPnv(PfNewsVo pnv) {
		this.pnv = pnv;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String[] getNewsIds() {
		return newsIds;
	}

	public void setNewsIds(String[] newsIds) {
		this.newsIds = newsIds;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getConfig() {
		return config;
	}

	public void setConfig(String config) {
		this.config = config;
	}

	public Integer getNodeId() {
		return nodeId;
	}

	public void setNodeId(Integer nodeId) {
		this.nodeId = nodeId;
	}

	public HashMap getNewsInfo() {
		return newsInfo;
	}

	public void setNewsInfo(HashMap newsInfo) {
		this.newsInfo = newsInfo;
	}

	public List<PfNewsVo> getNewsList() {
		return newsList;
	}

	public void setNewsList(List<PfNewsVo> newsList) {
		this.newsList = newsList;
	}

	public void setServletResponse(HttpServletResponse response) {
		// TODO Auto-generated method stub
		this.response=response;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}
}
