package com.gtis.web.action;


import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.gtis.plat.wf.UserUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.dao.SysMessageDAO;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.spring.Container;
import com.opensymphony.xwork2.Action;
import com.gtis.web.SessionUtil;
import org.apache.struts2.json.JSONUtil;

import javax.servlet.http.HttpServletResponse;

public class MessagePopAction {
	public String execute() throws Exception{
		String noReadMsgCounts = "0";
		String noReadNotify="0";
		//获取未读的通知数量
		SysMessageDAO sysMessageDAO = (SysMessageDAO) Container.getBean("SysMessageDao");
		noReadNotify=sysMessageDAO.getPopNotify(SessionUtil.getUserId(ServletActionContext.getRequest()));
		
		//获取未读的消息数量
		noReadMsgCounts = sysMessageDAO.getPopMessage(SessionUtil.getUserId(ServletActionContext.getRequest()));
		
		//获取待办任务数量
		SysWorkFlowInstanceDao tempSysWorkFlowInstanceDao = (SysWorkFlowInstanceDao) Container.getBean("SysWorkFlowInstanceDao");
		HashMap<String,String> paraMap = new HashMap<String,String>();
        UserUtil.setTaskUserMapIds(paraMap);
		String taskCount = tempSysWorkFlowInstanceDao.getTaskCount(paraMap);

		if (taskCount != null && taskCount.trim().length()>0)
			noReadMsgCounts = noReadNotify+","+noReadMsgCounts+","+taskCount;
		else
			noReadMsgCounts = noReadNotify+","+noReadMsgCounts+","+0;

		paraMap=new HashMap<String,String>();
		UserUtil.setTaskUserMapIds(paraMap);  //设置userids
		paraMap.put("TASK_STATE", "2");   //表示超期任务
		String taskCQCount= tempSysWorkFlowInstanceDao.getTaskCount(paraMap);

		if(StringUtils.isNotBlank(taskCQCount))
			noReadMsgCounts += ","+taskCQCount;
		else
			noReadMsgCounts += ","+0;

		String taskHasCount = tempSysWorkFlowInstanceDao.getAllTaskOverCount(paraMap);
		if(StringUtils.isNotBlank(taskHasCount))
			noReadMsgCounts += ","+taskHasCount;
		else
			noReadMsgCounts += ","+0;

		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(noReadMsgCounts);
		return Action.NONE;
	}

	public String countBSWD() throws Exception{
		HashMap<String, List<HashMap>> countBSWDs = new HashMap<String, List<HashMap>>();

		SysWorkFlowInstanceDao tempSysWorkFlowInstanceDao = (SysWorkFlowInstanceDao) Container.getBean("SysWorkFlowInstanceDao");
		List<HashMap> resultMap = getBSWDTaskCount(tempSysWorkFlowInstanceDao);
		countBSWDs.put("task",initTaskMapList(resultMap));
		resultMap = getBSWDAllTaskOverCount(tempSysWorkFlowInstanceDao);
		countBSWDs.put("taskover",initTaskMapList(resultMap));
		resultMap = getBSWDCQTaskCount(tempSysWorkFlowInstanceDao);
		countBSWDs.put("taskcq",initTaskMapList(resultMap));

		HttpServletResponse response = ServletActionContext.getResponse();
		response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
		out.println(JSONUtil.serialize(countBSWDs));
		out.flush();
		out.close();
		return Action.NONE;
	}

	private List<HashMap> getBSWDTaskCount(SysWorkFlowInstanceDao workFlowInstanceDao){
		HashMap<String,String> map=new HashMap<String,String>();
		//设置userids
		UserUtil.setTaskUserMapIds(map);
		List<HashMap> resultMap = workFlowInstanceDao.getBSWDTaskCount(map);
		if (resultMap == null){
			resultMap = new ArrayList<HashMap>();
		}
		for (int i = 0; i < resultMap.size(); i++) {
			Integer icount = MapUtils.getInteger(resultMap.get(i),"ICOUNT");
			if (icount == null){
				resultMap.get(i).put("ICOUNT",0);
			}
		}
		return resultMap;
	}

	private List<HashMap> getBSWDAllTaskOverCount(SysWorkFlowInstanceDao workFlowInstanceDao){
		HashMap<String,String> map=new HashMap<String,String>();
		//map.put("userIds", userId);
		UserUtil.setTaskUserMapIds(map);  //设置userids
		List<HashMap> resultMap = workFlowInstanceDao.getBSWDAllTaskOverCount(map);
		if (resultMap == null){
			resultMap = new ArrayList<HashMap>();
		}
		for (int i = 0; i < resultMap.size(); i++) {
			Integer icount = MapUtils.getInteger(resultMap.get(i),"ICOUNT");
			if (icount == null){
				resultMap.get(i).put("ICOUNT",0);
			}
		}
		return resultMap;
	}

	private List<HashMap> getBSWDCQTaskCount(SysWorkFlowInstanceDao workFlowInstanceDao){
		HashMap<String,String> map=new HashMap<String,String>();
		UserUtil.setTaskUserMapIds(map);  //设置userids
		map.put("TASK_STATE","2");   //表示超期任务
		List<HashMap> resultMap = workFlowInstanceDao.getBSWDTaskCount(map);
		if (resultMap == null){
			resultMap = new ArrayList<HashMap>();
		}
		for (int i = 0; i < resultMap.size(); i++) {
			Integer icount = MapUtils.getInteger(resultMap.get(i),"ICOUNT");
			if (icount == null){
				resultMap.get(i).put("ICOUNT",0);
			}
		}
		return resultMap;
	}

	private List<HashMap> initTaskMapList(List<HashMap> resultMap){
		if (resultMap == null){
			resultMap = new ArrayList<HashMap>();
		}
		for (int i = 0; i < resultMap.size(); i++) {
			Integer icount = MapUtils.getInteger(resultMap.get(i),"ICOUNT");
			if (icount == null){
				resultMap.get(i).put("ICOUNT",0);
			}
		}
		return resultMap;
	}
	
}
