package com.gtis.web.action;

import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.dao.SysMessageDAO;
import com.gtis.spring.Container;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.struts2.ServletActionContext;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.HashMap;

/**
 * @(#)LoginAction.java 2010-12-7 9:59:31
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class LoginAction implements Action {
    private UserInfo userInfo;
    private SysWorkFlowInstanceService instanceService;

    private String taskCount;
    private String msgCount;

    public String execute() throws Exception {
        userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
        userInfo.setPassword("");
        XStream xstr = new XStream(new DomDriver());
        xstr.alias("user",UserInfo.class);
        xstr.alias("organ", PfOrganVo.class);
        xstr.alias("role", PfRoleVo.class);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(xstr.toXML(userInfo));

        HashMap<String,String> map=new HashMap<String,String>();
		map.put("userId",userInfo.getId());
		taskCount = instanceService.getTaskCount(map);

        SysMessageDAO sysMessageDAO = (SysMessageDAO) Container.getBean("SysMessageDao");
        msgCount  = sysMessageDAO.getPopMessage(SessionUtil.getUserId(ServletActionContext.getRequest()));

        return Action.SUCCESS;
    }

    //代办任务条数
    public String getTaskCounts() throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("html/text");
        PrintWriter out = null;
        try {
            userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
            userInfo.setPassword("");
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            HashMap<String,String> map=new HashMap<String,String>();
            map.put("userId",userInfo.getId());
            taskCount = instanceService.getTaskCount(map);
            out = response.getWriter();
            out.print(taskCount);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    //未读短信
    public String getMsgCounts() throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("html/text");
        PrintWriter out = null;
        try {
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            SysMessageDAO sysMessageDAO = (SysMessageDAO) Container.getBean("SysMessageDao");
            msgCount  = sysMessageDAO.getPopMessage(SessionUtil.getUserId(ServletActionContext.getRequest()));
            out = response.getWriter();
            out.print(msgCount);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setInstanceService(SysWorkFlowInstanceService instanceService) {
        this.instanceService = instanceService;
    }

    public String getTaskCount() {
        return taskCount;
    }

    public String getMsgCount() {
        return msgCount;
    }

    public UserInfo getUserInfo() {
        return userInfo;
    }


} 