package com.gtis.web.action;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.form.FormModelFactory;
import com.gtis.web.ResourceFileLoader;

public class FormXlstAction {

	String responseType;
	String dfid;

	public String getDfid() {
		return dfid;
	}

	public void setDfid(String dfid) {
		this.dfid = dfid;
	}

	public String getResponseType() {
		return responseType;
	}

	public void setResponseType(String responseType) {
		this.responseType = responseType;
	}

	public String execute() throws Exception {
		String path = ServletActionContext.getRequest().getContextPath();
		// responseType="1";
		if (dfid != null && !dfid.equals("")) {
			if (responseType == null || responseType.equals("0")) { // 动态输出
				writeXlst(FormModelFactory.getFormDefineVo(dfid)
						.getDefinitionXlst());
			} else if (responseType.equals("1")) { // 先输出为文件，有了就不输出
				writeFile(dfid);
				ServletActionContext.getResponse().sendRedirect(
						path + "/xlst/" + dfid + ".xlst");
			} else if (responseType.equals("2")) { // 直接选择文件
				ServletActionContext.getResponse().sendRedirect(
						path + "xlst/" + dfid + ".xlst");
			}
		}
		return null;
	}

	/**
	 * 写入文件
	 * @param defineId
	 * @throws Exception
	 */
	private void writeFile(String defineId) throws Exception {
		String filePath = ResourceFileLoader.getPlatPath() + "xlst";
		filePath = filePath.replace("file:/", ""); // jar包中怎么有file:/
		File folder = new File(filePath);
		File file = new File(filePath + "/" + defineId + ".xlst");
		if (!folder.exists())
			folder.mkdirs();
		if (!file.exists()) {
			file.createNewFile();
			OutputFormat format = OutputFormat.createPrettyPrint();
			format.setEncoding("utf-8");
			XMLWriter writer = null;
			try {
				String xlstString = FormModelFactory.getFormDefineVo(defineId)
						.getDefinitionXlst();
				FileOutputStream out = new FileOutputStream(file);
				Document doc = DocumentHelper.parseText(xlstString);
				writer = new XMLWriter(out, format);
				writer.write(doc);
				out.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}

	private void writeXlst(String xlstString) throws Exception {
		Document doc = DocumentHelper.parseText(xlstString);
		// 写入页面
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().setContentType("text/xml");
		OutputFormat format = OutputFormat.createPrettyPrint();
		format.setEncoding("utf-8");
		XMLWriter writer = null;
		writer = new XMLWriter(ServletActionContext.getResponse()
				.getOutputStream(), format);
		writer.write(doc);

		ServletActionContext.getResponse().getOutputStream().flush();
		ServletActionContext.getResponse().getOutputStream().close();
	}
}
