
package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserSignVo;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;

import java.util.Date;


/** 
 * MyEclipse Struts
 * Creation date: 04-06-2007
 * 
 * XDoclet definition:
 * @struts.action validate="true"
 * @struts.action-forward name="sign" path="/forms/sign/Form_Sign.jsp"
 */
public class FormSignAction {
	
	String signid;
	String id;
	SysFormDao formDao;
	PfUserSignVo userSignVo;
	String taskid;
    String userid;
    SysTaskService taskService;
    String disableTime;
	/**是否进行签名前用户密码确认*/
	boolean signUserCheck;

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String execute() throws Exception{
		if (StringUtils.isNotBlank(signid)){
			userSignVo=formDao.getSign(signid);
		}
		signUserCheck = AppConfig.getBooleanProperty("signUserCheck.enable", false);
		return Action.SUCCESS;
	}
	
	public String getSign() throws Exception{
		if (StringUtils.isNotBlank(signid)){
			userSignVo=formDao.getSign(signid);
		}else {
			userSignVo = new PfUserSignVo();
			userSignVo.setSignDate(new Date());
		}
        //判断是否委托任务
        if (StringUtils.isNotBlank(taskid)){
            PfTaskVo taskVo=taskService.getTask(taskid);
            if (StringUtils.isNotBlank(taskVo.getTaskBefore())){
                PfTaskVo beforeTaskVo=taskService.getHistoryTask(taskVo.getTaskBefore());
                if (beforeTaskVo!=null && StringUtils.isNotBlank(beforeTaskVo.getRemark())
                    && beforeTaskVo.getRemark().indexOf("委托")>-1 ){
                    this.userid= beforeTaskVo.getUserVo().getUserId();
                }
            }
        }

		return "sign";
	}
	
	public String getSignid() {
		return signid;
	}
	public void setSignid(String signid) {
		this.signid = signid;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public SysFormDao getFormDao() {
		return formDao;
	}
	public void setFormDao(SysFormDao formDao) {
		this.formDao = formDao;
	}
	public PfUserSignVo getUserSignVo() {
		return userSignVo;
	}
	public void setUserSignVo(PfUserSignVo userSignVo) {
		this.userSignVo = userSignVo;
	}

	public String getDisableTime() {
		return disableTime;
	}

	public void setDisableTime(String disableTime) {
		this.disableTime = disableTime;
	}

	public boolean isSignUserCheck() {
		return signUserCheck;
	}

	public void setSignUserCheck(boolean signUserCheck) {
		this.signUserCheck = signUserCheck;
	}
}